package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseForTask;
import com.horizon.wf.action.base.IActionForStartSubFlow;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.INodeUser;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVar;
import com.horizon.wf.global.StaticVarExtend;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 一、单步退回操作实现类
 * 1)不接收前台直接指定的办理人
 * 2)如果无法找到办理人，则需要前台指定
 * 3)如果一个节点反复经过多次，有不同的办理人，则查找最近一次的办理人
 * 4)不支持分支退回到分支之前
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class ActionReject extends BaseForTask implements ICustomAction,IActionForStartSubFlow {
	public boolean execute(ITaskNode curTaskNode){
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_REJECT);
		setActionname("Reject_Msg0001","退回");
		//不能退回到分支之前的节点
		//判断当前节点是否为当前路径的第一个节点,如果是,则不允许退回,提示使用任意退回
		DBTrack curTrack = getCurTrack();
		String snapshotecords = curTrack._getTrackJson().getSnapshotecords();
		String[] snapnodes =snapshotecords.split(StaticVar.StrSplitChar); 
		if(snapnodes.length == 1){
			result = StaticVarExtend.F_STATUS_OtherError; 
			msg = pubInfo.getInfo("Reject_Msg0002","当前节点是分支开始节点,不允许使用[退回],请使用[任意退回]");
		}
		else{
			executeReject(curTaskNode);
			List<INextNode> nextNodes = curTaskNode.getGNextNodes();
			if(StaticVarExtend.F_STATUS_Success == result){
				if(!isAllowReject(nextNodes)){
					result = StaticVarExtend.F_STATUS_OtherError; 
					msg = pubInfo.getInfo("Reject_Msg0003","上一节点的节点类型不允许退回");
				}
				//获取退回节点的办理人
				else{
					doWithNextNodeResult(false);
					if(result ==  StaticVarExtend.F_STATUS_Success){
						msg = pubInfo.getInfo("Reject_Msg0004","退回成功");
						doWithCurNodeAuth();
						curTrack.setEnd(true);//结束当前节点
						ac.dowithTimer("cancel", getCurNodeType(), runningdata, getIdentifier());//如果当前节点包含定时任务则撤销定时任务
						if(executeEventSave()){
//							selectedUsers = ac.makeAgentUser(selectedUsers, runningdata);
							runningdata.setUpdateTask(true);
							runningdata.setTitle(paraBean.getTitle());//设置待办发送的标题
							memoBuffer.append(pubInfo.getInfo("Reject_Msg0005","退回到节点"));
							for (int i = 0, n = nextNodes.size(); i < n; i++) {
								INextNode nextNode = nextNodes.get(i);
								doMemoFromSelected(nextNode);
							}
						}
					}
				}
			}
			resultBean.setNextNodes(nextNodes);
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	
	/**
	 * 判断给定的节点是否是允许回退的节点类型
	 * @param nodes
	 * @return true: 允许回退
	 */
	private boolean isAllowReject(List<INextNode> nodes){
		for(int i=0,n=nodes.size();i<n;i++){
			INextNode node = nodes.get(i);
			int nodetype = node.getFlowNode().getNodetype();
			if(!ac.isNormalNode(nodetype)){
				runningdata.putMsgToConsole("[msg]reject nodetype:"+nodetype+",nodeid"+node.getNodeid()+",nodename:"+node.getNodename());
				return false;
			}
		}
		return true;
	}
	
	private void executeReject(ITaskNode curTaskNode) {
		//执行回退
		curTaskNode.rejectToPrevNode(nextNodeList, selectedUsers);
		INextNode curNode = curTaskNode.getCurNode();
		result = curNode.getInitResult();
		msg = curNode.getBackMsg();
	}
	
	/**
	 * 处理当前节点参与者权限
	 */
	private void doWithCurNodeAuth() {
		List<DBWorkAuth> auths = runningdata
				.getListAuthLikeAuthorByTrackid(getCurTrack().getId());
		if(CollectionUtil.isListNotEmpty(auths)){
			for(int i=0,n=auths.size();i<n;i++){
				DBWorkAuth auth = auths.get(i);
				if(auth.equalsRunUser(getCurUser())){
					auth.setStatus(StaticVarExtend.AUTH_DONE);
				}
				else{
					auth.setStatus(StaticVarExtend.AUTH_CREADER);
				}
			}
		}
		runningdata.setCurAuthToMap(auths);
	}
	
	public Map<String,List<Object>>  actionForTask() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		actionForTask(saveMap);
		//下一节点任务创建
		for(int i=0,n=runningdata.getNextTrackList().size();i<n;i++){
			DBTrack tTrack =runningdata.getNextTrackList().get(i);
			createTaskObj(null,tTrack,saveMap);
		}
		return saveMap;
	}
/*
	private void createTaskObj(DBTask xTask,DBTrack xTrack,Map<String, List<Object>> saveMap){
		DBWork xWork = runningdata.getWork();
		if(xTask == null){
			xTask = new DBTask();
			xTask.setId(StaticFunExtend.getUnid());
			xTask.setFlowid(xWork.getFlowid());
			xTask.setFlowname(xWork.getFlowname());
			xTask.setWorkid(xWork.getId());		
			IXmlFlowInfo flowInfo = runningdata.getInstanceDefinition().getFlowInfo();
			int[] ls = flowInfo.getLimitSet();
			
			xTask.setFlowlimitdate(ls[1]);
			xTask.setFlowlimittype(String.valueOf(ls[0]));
			
			xTask.setStarttime(xWork.getStarttime());	
			//计算流程超期时间点，如果没有设置，默认为一年
			int tp  =xTask.getFlowlimitdate();
			
			Date date = addDateForTask(xTask.getStarttime(),ls[0], tp);  
//			DateUtil.addDateDay(DateUtil.getDateTime(xTask.getStarttime()), tp==0?365:tp);  
			xTask.setFlowlimittime(DateUtil.formatDateTime(date,"yyyy-MM-dd HH:mm:ss"));
		
			String nowtime = DateUtil.getNow();
			xTask.setReceivetime(nowtime);//节点到达时间，计入xml中
//			curNode.setNodeRecevieTime(nowtime);
			//int[] ns = runningdata.getCurXMLNode().getNodeLimit(); 
			int[] ns = flowInfo.getNodeById(xTrack.getNodeid()).getNodeLimit();
			
			String outerCofig = paraBean.getOuterConfig();
			if(StringUtilExtend.isNull(outerCofig)){
				outerCofig = runningdata.getOuterSetType();
			}
			
			if(StringUtilExtend.isNotNull(outerCofig)){
				String limittime = RuleUtil.getOuterLimittime(flowInfo.getFlowid(), xTrack.getNodeid(), outerCofig, getIdentifier());
				if(StringUtilExtend.isNull(limittime)){
					limittime = "0";
				}
				xTask.setNodelimitdate(Integer.parseInt(limittime));				
			}else{
				xTask.setNodelimitdate(ns[1]);				
			}
			xTask.setNodelimittype(String.valueOf(ns[0]));
						
			xTask.setWaringdate(ns[2]);
			xTask.setWaringtype(String.valueOf(ns[0]));
			xTask.setDooverpass(ns[4]);
			xTask.setRemsgnum(ns[3]);
			xTask.setRedonenum(0);
			tp  =xTask.getNodelimitdate();
			
			date = addDateForTask(xTask.getReceivetime(),ns[0], tp);  
//			DateUtil.addDateDay(DateUtil.getDateTime(xTask.getReceivetime()), tp==0?365:tp);  
            xTask.setNodelimittime(DateUtil.formatDateTime(date,"yyyy-MM-dd HH:mm:ss"));
            xTask.setTrackid(xTrack.getId());
		}
		
		xTask.setFlowstatus(xTrack.getFlowstatus());		//流程状态更新
		xTask.setNodetype(runningdata.getCurXMLNode().getNodetype());
		
		xTask.setTitle(xWork.getTitle());
		xTask.setStatus(StaticVarExtend.Task_Normal);
		xTask.setNodeid(xTrack.getNodeid());					
		xTask.setNodename(xTrack.getNodename());		
				
		xTask.getSQL(saveMap);
	}
	//*/
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		if(isNotSaveToDB){
			return;
		}
		makeSendInfoByCurAuthList(auths);
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		Map<String,String> map = new HashMap<String,String>();
		if(!isNotSaveToDB){
			map.put(StaticVarExtend.AUTH_AUTHOR, StaticVarExtend.AUTH_CREADER);
		}
		return map;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
		super.actionAfterSaveToDB();
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		if(!StaticFunExtend.getActionExtraData().doWithNextNodesExtraData(this)){
			return null;
		}
		sendTodo();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
	/**
	 * 发送待办
	 */
	protected void sendTodo(){
		sendTodoForSelectedUsers();
	}
}
