package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseForTask;
import com.horizon.wf.action.base.IActionForStartSubFlow;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.node.INodeRouter;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;

import java.util.*;

/**
 * 补发路由
 * @author liys
 * @version 1.0
 * @since v7.2
 *
 */
public class ActionReissueRouter extends BaseForTask implements ICustomAction,IActionForStartSubFlow {
	
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_REISSUE_ROUTER);
		setActionname("Router_Msg0001","分支补发");
		initNextNodePara();//初始化下一节点信息
		if(null == nextNodeList || nextNodeList.isEmpty()){
			runningdata.putMsgToConsole("[msg]goto operator need select node!");
			result = StaticVarExtend.F_STATUS_SelectNode;
			msg = pubInfo.getInfo("Router_Msg0002","请选择补发的分支节点");
			List<INextNode> rNodes = runningdata.getReissueNodes();
			if(rNodes == null){
				result = StaticVarExtend.F_STATUS_OtherError;
				msg  =pubInfo.getInfo("Router_Msg0003","当前节点不符合补发分支条件");
			}
			else{
				resultBean.setNextNodes(rNodes);
			}
		}
		else{
			thinkJump(curTaskNode);
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	
	/**
	 * 考虑补发节点被跳过的情况
	 * @param curTaskNode
	 */
	private void thinkJump(ITaskNode curTaskNode){
		List<INextNode> nextNodes = leaveByRouter(curTaskNode);
		
		if(nextNodes == null){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Router_Msg0004","补发分支失败");
		}
		else{
			doWithNextNodeResult(false);
			if(result == StaticVarExtend.F_STATUS_Success){
				msg = pubInfo.getInfo("Router_Msg0005","补发分支成功");
			}
			//20150513增加下一节点按路由序号排序
			sortNextNodes(nextNodes);
			
			resultBean.setNextNodes(nextNodes);//(curTaskNode.getGNextNodes());
			StringBuilder sb = new StringBuilder(1000);
			memoBuffer.append(pubInfo.getInfo("Router_Msg0006","补发分支到节点"));
			for(int i=0,m=nextNodes.size();i<m;i++){
				INextNode n = nextNodes.get(i);
				if(n.isSelected()){
					sb.append(StaticVarExtend.MARK_NODE_SPLIT).append(n.getSelectedIdStr());
					doMemoFromSelected(n);
				}
			}
			if(sb.length()>0){
				sb.deleteCharAt(0);
				nextNodeId = sb.toString();
				runningdata.setUpdateTask(true);
			}
		}
	}
	
	private List<INextNode> leaveByRouter(ITaskNode curTaskNode){
		curTaskNode.reissueRouters(nextNodeList, selectedUsers);
		result = curTaskNode.getCurNode().getInitResult();
		int initResult = runningdata.getResultCode();
		if(initResult != StaticVarExtend.F_STATUS_Success){
			initResult = runningdata.getResultCode();
			msg = runningdata.getBackMsg();
			return null;
		}
		msg = curTaskNode.getCurNode().getBackMsg();
		List<INextNode> nextNodes = curTaskNode.getGNextNodes();// 获取符合条件的节点列表
		return nextNodes;
	}
	
	private void sortNextNodes(List<INextNode> nextNodes){
		List<INextNode> nodes =nextNodes;
		List<INextNode> sortNodes = new ArrayList<INextNode>();
		List<INextNode> tmpNode = new ArrayList<INextNode>();
		
		for(int i=0,n=nodes.size();i<n;i++){
			INextNode node = nodes.get(i);
			//排序准备
			INodeRouter tmpRouter = node.getFromXmlRouter();
			if(tmpRouter == null){
				sortNodes.add(node);
			}
			else{
				tmpNode.add(node);
			}
		}
		Collections.sort(tmpNode, new Comparator<INextNode>() {
			public int compare(INextNode o1, INextNode o2) {
				return o1.getFromXmlRouter().getSortnum() - o2.getFromXmlRouter().getSortnum();
			}
		});
		sortNodes.addAll(tmpNode);
		
		nextNodes = sortNodes;
	}
	//=================================================================================
	
	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		//下一节点任务创建
		for(int i=0,n=runningdata.getNextTrackList().size();i<n;i++){
			DBTrack tTrack =runningdata.getNextTrackList().get(i);
			createTaskObj(null,tTrack,saveMap);
		}
		return saveMap;
	}

	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
			
		if(!StaticFunExtend.getActionExtraData().doWithNextNodesExtraData(this)){
			return null;
		}
		
		sendTodo();			
		actionBefore(saveMap);
		//把子流程启动的SQLMap放入saveMap中
		actionBeforeForSubFlow(saveMap);
		return saveMap ;
	}
	
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
		//执行子流程启动时的actionAfterSaveToDB方法
		actionAfterForSubFlow();
		//发送定时任务
		super.actionAfterSaveToDB();
		
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
	
	protected void sendTodo(){
		sendTodoForSelectedUsers();
	}
}
