package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.api.AgentUtil;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.track.json.impl.ITrackNodeJson;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVar;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 补发操作
 * @author liys
 * @version 1.0
 * @since v7.2
 *
 */
public class ActionReissue extends BaseAction implements ICustomAction {
	private String selectedKey = "";	//获取前台传入办理人的key
	StringBuilder newsb = new StringBuilder(1000);
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_REISSUE);
		setActionname("Reissue_Msg0001","补发");
		if(isReissueAuthor()){
			if(null == selectedUsers || selectedUsers.isEmpty()){
				result = StaticVarExtend.F_STATUS_SelectAuthor;
				msg = pubInfo.getInfo("Reissue_Msg0002","请指定办理人");
			}else{
				List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
				List<DBWorkAuth> auths = getXAuthList(StaticVarExtend.AUTH_AUTHOR);
				if(auths == null || auths.isEmpty()){
	                result = StaticVarExtend.F_STATUS_OtherError;
	                msg = pubInfo.getInfo("Reissue_Msg0007","未能获取到当前办理人(可能是办理人的状态变更为其他状态,比如会签时)");;
	                
	                runningdata.setBackMsg(msg);
	                runningdata.setResultCode(result);
	                return true;
	            }
				//根据当前办理人相关属性生成新的办理人
				List<DBWorkAuth> addAuths =addNewAuth(auths.get(0));
				if(addAuths == null){
					result = StaticVarExtend.F_STATUS_OtherError;
	                msg = pubInfo.getInfo("Reissue_Msg0008","指定补发人已存在当前办理人列表中.");;
	                
	                runningdata.setBackMsg(msg);
	                runningdata.setResultCode(result);
	                return true;
				}
				newAuths.addAll(addAuths);
				runningdata.setCurAuthToMap(newAuths);
				msg = pubInfo.getInfo("Reissue_Msg0003","补发办理人成功");
				result = StaticVarExtend.F_STATUS_Success;	
				if(executeEventSave()){
					runningdata.setUpdateTask(true);
					runningdata.setTitle(paraBean.getTitle());//设置待办发送的标题
					
					String username = getUsernameFormSelectedOrFromDB(selectedKey,newsb.toString());
					memoBuffer.append(pubInfo.getInfo("Reissue_Msg0006","补发办理人:|username|")
							.replace("|username|", username));
				}
			}
		}
		else{
			result = StaticVarExtend.F_STATUS_OtherError;
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	
	private boolean isReissueAuthor() {
		int nodetype = getCurNodeType();
		if(!(NodeTypeEnum.Node_Multi == nodetype || NodeTypeEnum.Node_Order == nodetype)){
			
			msg = pubInfo.getInfo("Reissue_Msg0004","节点类型不支持补发办理人操作");
			return false;
		}
		if(getCurTrack().getFlowstatus() == StaticVarExtend.FlowStatus_GetBack){
			msg = pubInfo.getInfo("Reissue_Msg0005","拿回状态不支持补发办理人操作");
			return false;
		}
		return true;
	}

	/**
	 * 构造一个新的办理人对象
	 * @param auth
	 * @return
	 */
	private List<DBWorkAuth> addNewAuth(DBWorkAuth auth) {
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		String status = StaticVarExtend.AUTH_DONE;	//权限名称
		selectedKey = status;
		String selectedUser = selectedUsers.get(status);		//权限对应的办理人
		if(StringUtilExtend.isNull(selectedUser)){
			selectedKey = getCurNodeid()+StaticVarExtend.MARK_NODE_USER+StaticVarExtend.AUTH_DONE;
			selectedUser = selectedUsers.get(selectedKey);
		}
		if(StringUtilExtend.isNull(selectedUser)){		
			status = StaticVarExtend.AUTH_AUTHOR;
			selectedKey = status;
			selectedUser = selectedUsers.get(status);
		}
		if(StringUtilExtend.isNull(selectedUser)){		
			selectedKey = getCurNodeid()+StaticVarExtend.MARK_NODE_USER+status;
			selectedUser = selectedUsers.get(selectedKey);
		}
		//获取代理人
		INodeAuthUser xmluser = getCurFlowNode().getParticipantsUser(StaticVarExtend.AUTH_AUTHOR);
		if(null != xmluser && xmluser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_AgentFlag) != -1){
			//调用代理
			selectedUser = AgentUtil.getInstance().getAgentUser(selectedUser, getWorkid(), getWork().getFlowid(), getIdentifier());				
		}
		
		List<AuthUserImpl> addLst = AuthUserImpl.getAuthUserList(selectedUser);
		
		int nodetype = getCurNodeType();
		ITrackNodeJson trackNode = getCurTrack()._getTrackNode();
		ITrackUserJson trackAuthorUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
		List<AuthUserImpl> oldPlanLst = AuthUserImpl.getAuthUserList(trackAuthorUser.getPlanId());
		
		//去除已经在办理列表中的人员
		List<AuthUserImpl> repeatLst = new ArrayList<AuthUserImpl>();
		for(int i=0,m=addLst.size();i<m;i++){
			AuthUserImpl n =addLst.get(i);
			for(int j=0,k=oldPlanLst.size();j<k;j++){
				AuthUserImpl o = oldPlanLst.get(j);
				if(o.isSameAuth(n)){
					repeatLst.add(n);
					break;
				}
			}
		}
		for(int i=0,n=repeatLst.size();i<n;i++){
			AuthUserImpl r = repeatLst.get(i);
			addLst.remove(r);
		}
		
		//修改PlanId
		StringBuilder sb = new StringBuilder(1000);
		for(int i=0,n=oldPlanLst.size();i<n;i++){
			AuthUserImpl o = oldPlanLst.get(i);
			sb.append(StaticVar.UserSplitChar).append(o._getFullNameWithAgent());
		}
		//去掉已经存在的办理人
		
		for(int i=0,m=addLst.size();i<m;i++){
			AuthUserImpl n = addLst.get(i);
			newsb.append(StaticVar.UserSplitChar).append(n._getFullNameWithAgent());
		}
		
		//20161108 如果补发的人去重后为空,则返回
		if(newsb.length() == 0){
			return null;
		}
		
		sb.append(newsb);
		sb.deleteCharAt(0);
		runningdata.setPlanId_ForTrackUser(trackAuthorUser, sb.toString());
		
		this.selectedUsers.clear();
		
		if(NodeTypeEnum.Node_Order != nodetype){//如果是顺签则只修改XML信息即可
			for(int i=0,m=addLst.size();i<m;i++){
				AuthUserImpl n = addLst.get(i);
				DBWorkAuth newAuth = n.copyToWorkAuth();
				newAuth.setAuthNo(auth.getAuthNo());
				
				newAuth.setNodeid(auth.getNodeid());
				newAuth.setOldStatus("");
				newAuth.setStatus(status);
				newAuth.setTrackid(auth.getTrackid());
				newAuth.setVersion(auth.getVersion()+1);
				newAuth.setWorkid(auth.getWorkid());
				newAuth.setNodenum(auth.getNodenum());		
				
				newAuths.add(newAuth);
			}
			
			this.selectedUsers.put(StaticVarExtend.AUTH_DONE,newsb.toString());
		}
		return newAuths;
	}

	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		sendTodo();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
	/**
	 * 继承父类发送待办的方法
	 */
	protected void sendTodo(){
		String todoUserids =selectedUsers.get(StaticVarExtend.AUTH_DONE);
		if(StringUtilExtend.isNull(todoUserids))return;
		String msgSendType = getSendType(getCurFlowNode(), StaticVarExtend.AUTH_AUTHOR, paraBean);//获取发送消息的方式
		DBTodo todo = makeDefaultDBTodo();
		makeSendInfoForNewAuth(todo,todoUserids,StaticVarExtend.AUTH_AUTHOR,StaticVarExtend.Send_Todo,
				msgSendType,getCurTrack(),getCurFlowNode());
	}
}
