package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.track.json.impl.ITrackNodeJson;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 减签操作实现类
 * @author liangjw
 * @version 1.0
 * @since v7.2
 */
public class ActionReduceAuthor extends BaseAction implements ICustomAction{
	private StringBuilder sendAuthor = new StringBuilder("");	//发送待办的参与者id
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_REDUCE_AUTHOR);
		setActionname("Reduce_Msg0001","减签");
		
		if(isReduceAuthor()){
			if(isNotSaveToDB || CollectionUtil.isMapEmpty(selectedUsers)){
				String user ;
				ITrackNodeJson trackNode = getCurTrack()._getTrackNode();
				ITrackUserJson trackAuthorUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
				user = trackAuthorUser.getPlanId();

				ITrackUserJson  trackRdyUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_DONE,StaticVarExtend.AUTH_AUTHOR);
				String doneId = trackRdyUser.getNowId(); //已办理人
				
				//多人处理时,如果有人执行了会签,则减签也需要过滤掉
				ITrackUserJson trackHQUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_START_HUIQIAN_AUTHOR,StaticVarExtend.AUTH_AUTHOR);
				String startHQId = trackHQUser.getNowId();//发起会签的办理人
				
				//20171020 liys 需要区分是否为顺签节点,顺签节点需要从个当前人开始往后获取其他节点从已办人中去掉
				String tempUser = getAllowReduceAuthors(user,doneId,startHQId);
				
				if(tempUser.length()>0){
    				tmpUsers.put(getCurUser().getAuthName(), tempUser);
    				tmpUsers.put(getCurNodeid()+StaticVarExtend.MARK_NODE_USER+getCurUser().getAuthName(), tempUser);
    				runningdata.putMsgToConsole("[msg]reduce author:"+tempUser);
    				msg = pubInfo.getInfo("Reduce_Msg0002","请从列表中选择需要减签的人员");
    				result = StaticVarExtend.F_STATUS_SelectAuthor;
				}
				else{
				    msg = pubInfo.getInfo("Reduce_Msg0004","节点只有最后一个办理人时,不能进行减签.");
				    result = StaticVarExtend.F_STATUS_OtherError;
				}
			}else{
				if(CollectionUtil.isMapEmpty(selectedUsers)){
					runningdata.putMsgToConsole("[msg]reduceAuthor operator need select author.");
					runningdata.setBackMsg(pubInfo.getInfo("Reduce_Msg0003","请指定需要减少的办理人"));
					runningdata.setResultCode(StaticVarExtend.F_STATUS_SelectAuthor);
					return false;
				}
				List<DBWorkAuth> auths = getXAuthList(StaticVarExtend.AUTH_AUTHOR);
				runningdata.putMsgToConsole("[msg]reduceAuthor operator start.");
				
				List<DBWorkAuth> newAuths = reduceAuth(auths);
				if(newAuths == null){
					//null的时候表示是最后一个人,isEmpty是顺签且不需要修改任何权限(只要不是减签当前办理人,就不需要处理)
					runningdata.putMsgToConsole("[msg]reduceAuthor operator need select author.");
					runningdata.setBackMsg(pubInfo.getInfo("Reduce_Msg0004","节点只有最后一个办理人时,不能进行减签."));
					runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
					return false;
				}
				
				
				runningdata.setCurAuthToMap(newAuths);//减少办理人
				runningdata.putMsgToConsole("[msg]reduceAuthor operator real author is :"+sendAuthor);
				result = StaticVarExtend.F_STATUS_Success;
				msg = pubInfo.getInfo("Reduce_Msg0005","减少办理人成功");
				executeEventSave();//执行操作完成事件
				runningdata.putMsgToConsole("[msg]reduceAuthor operator is end.");
			}
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	/**
	 * 判断是否有减签权限
	 * @return
	 */
	private boolean isReduceAuthor(){
		int nodetype = getCurNodeType();
		if(!nodetypeSupportReduceAuthor(nodetype)){
			runningdata.putMsgToConsole("[msg]reduceAuthor operator :not support nodetype.nodetype:"+nodetype);
			result = StaticVarExtend.F_STATUS_Not_Operator_Nodetype;
			msg = pubInfo.getInfo("Reduce_Msg0006","该节点类型不支持减少办理人操作");
			return false;
		}
		return true;
	}
	/**
	 * 获取节点上可以被减少的办理人列表
	 * @return
	 */
	private String getAllowReduceAuthors(String allPlanusers,String doneId,String startHQId){
		StringBuilder tempUser = new StringBuilder(1000);
		List<AuthUserImpl> planAuthLst =  AuthUserImpl.getAuthUserList(allPlanusers);	
		if(getCurNodeType() == NodeTypeEnum.Node_Order){//多人顺序节点
			List<AuthUserImpl> doneAuthLst =  AuthUserImpl.getAuthUserList(doneId);
			int i=doneAuthLst.size(),n=planAuthLst.size();
			if(i <= n-1){
				//判断当前位置是否为当前人,如果是则不允许减少,办理人执行和管理员执行时有差别
				AuthUserImpl auth = planAuthLst.get(i);
				if(!auth.equalsRunUser(getCurUser())){
					tempUser.append(auth._getFullNameWithAgent()).append(StaticVarExtend.UserSplitChar);
				}
				i++;
			}
			for(;i<n;i++){
				AuthUserImpl auth = planAuthLst.get(i);
				tempUser.append(auth._getFullNameWithAgent()).append(StaticVarExtend.UserSplitChar);
			}
		}
		else{
			List<AuthUserImpl> doneAuthLst =  AuthUserImpl.getAuthUserList(doneId + StaticVarExtend.UserSplitChar + startHQId);			
			
			
			for(int i=0,n=planAuthLst.size();i<n;i++){
				AuthUserImpl auth = planAuthLst.get(i);
				boolean isDoneAuth = false;
				for(int j=0,m=doneAuthLst.size();j<m;j++){
					AuthUserImpl u = doneAuthLst.get(j);
					if(auth.isSameAuth(u)){
						isDoneAuth = true;
						break;
					}
				}
				
				if( !(isDoneAuth || auth.equalsRunUser(getCurUser()))){
					tempUser.append(auth._getFullNameWithAgent()).append(StaticVarExtend.UserSplitChar);
				}
			}
		}
		return tempUser.toString();
	}
	
	
	/**
	 * 减签
	 * authorMap 需要减少的办理人
	 * oldAuths  当前所有的办理人
	 * @return 
	 */
	private List<DBWorkAuth> reduceAuth(List<DBWorkAuth> oldAuths) {
		if(CollectionUtil.isMapEmpty(selectedUsers)){
			runningdata.putMsgToConsole("[msg]before jiaqian operator getAuthor is null from selectedUsers.");
			return null;
		}
		//获取前台传入的减签人员
		String selectedKey = getCurNodeid()+StaticVarExtend.MARK_NODE_USER+getCurUser().getAuthName();
		String author = selectedUsers.get(selectedKey);
		if(StringUtilExtend.isNull(author)){
			selectedKey = getCurUser().getAuthName();
			author = selectedUsers.get(selectedKey);
		}
		
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		boolean isLast = false;
		if(getCurNodeType() == NodeTypeEnum.Node_Order){//多人顺序节点
			isLast = reduceAuthForOrderNode(newAuths,author,oldAuths.get(0));
		}
		else{
			isLast = reduceAuthForMultiNode(newAuths,author,oldAuths);
		}
		if(isLast){
			return null;
		}
		
		String username = getUsernameFormSelectedOrFromDB(selectedKey,author);
		memoBuffer.append(pubInfo.getInfo("Reduce_Msg0007","减少办理人:|username|")
				.replace("|username|", username));
		
		return newAuths;
	}	
	
	private boolean reduceAuthForOrderNode(List<DBWorkAuth> newAuths,String deleteAuthor,DBWorkAuth auth){
		StringBuilder newPlanId = new StringBuilder(1000);
		ITrackNodeJson trackNode = getCurTrack()._getTrackNode();
		//所有办理人
		ITrackUserJson  trackAuthorUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
		String planId = trackAuthorUser.getPlanId();
		//已办理人
		ITrackUserJson  trackRdyUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_DONE,StaticVarExtend.AUTH_AUTHOR);
		String doneId = trackRdyUser.getNowId(); 
		List<AuthUserImpl> doneAuthLst =  AuthUserImpl.getAuthUserList(doneId);
		int doneSize = doneAuthLst.size();//记录已经办理的人数,用于后面循环的起始计数
		
		List<AuthUserImpl> planAuth = AuthUserImpl.getAuthUserList(planId);
		List<AuthUserImpl> delAuthLst =  AuthUserImpl.getAuthUserList(deleteAuthor);
		for(int i=doneSize,n=planAuth.size();i<n;i++){
			AuthUserImpl pAuth = planAuth.get(i);
			//如果节点参与者不在减签列表中，则放到newPlanId以便重新设定办理人
			boolean isAuth = false;
			for(int j=0,m=delAuthLst.size();j<m;j++){
				AuthUserImpl u = delAuthLst.get(j);
				if(pAuth.isSameAuth(u)){
					isAuth = true;
					break;
				}
			}
			if(!isAuth){
				newPlanId.append(pAuth._getFullNameWithAgent()).append(StaticVarExtend.UserSplitChar);
			}
		}
		//新的列表为空,则说明减签之后没有办理人了
		if(newPlanId.length() == 0){
			return true;
		}
		
		//如果减签的办理人包含当前办理人,需要对待办和权限进行处理
		boolean isDelNowAuth = false;
		if(!auth.equalsRunUser(getCurUser())){
			//当前人执行减签时,不需要判断是否是当前人被减少了
			for(int j=0,m=delAuthLst.size();j<m;j++){
				AuthUserImpl u = delAuthLst.get(j);	
				if(auth.isSameAuth(u)){
					isDelNowAuth = true;
					break;
				}
			}
		}
		//如果减签列表中包含当前人(管理员执行减签时)
		if(isDelNowAuth){
			//删除待办记录
			auth.setStatus(StaticVarExtend.AUTH_CREADER);
			newAuths.add(auth); //记录当前权限变更
			
			String newNowId = "";
			String [] newNowIds = newPlanId.toString().split(StaticVarExtend.UserSplitChar);
			newNowId = newNowIds[0];

			runningdata.setNowId_ForTrackUser(trackAuthorUser, newNowId);
			sendAuthor.append(newNowId);
			//创建新的权限对象
			DBWorkAuth newAuth = auth.cloneAuth();
			newAuth.setStatus(StaticVarExtend.AUTH_AUTHOR);
			newAuth.setOldStatus(null);
			newAuth.setAuthId(newNowId);
			newAuth.setId(null);
			newAuths.add(newAuth);
		}
		if(doneSize>0){
			newPlanId.insert(0, StaticVarExtend.UserSplitChar).insert(0,doneId);
		}
		//不论是否减签了当前办理人,都需要对Author/PlanId进行更新
		runningdata.setPlanId_ForTrackUser(trackAuthorUser, newPlanId.toString());
		return false;
	}
	
	private boolean reduceAuthForMultiNode(List<DBWorkAuth> newAuths,String deleteAuthor,List<DBWorkAuth> oldAuths){
		List<AuthUserImpl> delAuthLst =  AuthUserImpl.getAuthUserList(deleteAuthor);
		StringBuilder newPlanId = new StringBuilder(1000);
		//更新办理人当前列表(不包含已办人)
		for(int i=0,n=oldAuths.size();i<n;i++){
			DBWorkAuth auth = oldAuths.get(i);
			boolean isAuth = false;
			for(int j=0,m=delAuthLst.size();j<m;j++){
				AuthUserImpl u = delAuthLst.get(j);
				if(auth.isSameAuth(u)){
					isAuth = true;
					break;
				}
			}
			if(isAuth){
				auth.setStatus(StaticVarExtend.AUTH_CREADER);	//删除权限
				newAuths.add(auth);
			}
			else{
				newPlanId.append(auth._getFullNameWithAgent()).append(StaticVarExtend.UserSplitChar);
			}
		}
		ITrackNodeJson trackNode = getCurTrack()._getTrackNode();
		ITrackUserJson  trackAuthorUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
		//在WorkAction中还会根据当前Auth变更进行重置一次Line:259行左右
		runningdata.setNowId_ForTrackUser(trackAuthorUser, newPlanId.toString());
		
		if(newPlanId.length() == 0){
			return true;
		}
		
		//更新办理人计划列表(包含已办人)
		String planid = trackAuthorUser.getPlanId();
		List<AuthUserImpl> planAuthLst =  AuthUserImpl.getAuthUserList(planid);
		newPlanId.delete(0, newPlanId.length());
		for(int i=0,n=planAuthLst.size();i<n;i++){//所有办理人列表,含已办理
			AuthUserImpl u = planAuthLst.get(i);
			boolean isAuth = false;
			for(int j=0,m=newAuths.size();j<m;j++){//需要删除的列表
				DBWorkAuth auth = newAuths.get(j);
				if(auth.isSameAuth(u)){
					isAuth = true;
					break;
				}
			}
			if(!isAuth){
				newPlanId.append(u._getFullNameWithAgent()).append(StaticVarExtend.UserSplitChar);
			}
		}
		runningdata.setPlanId_ForTrackUser(trackAuthorUser, newPlanId.toString());
		return false;
	}
	
	/**
	 * 判断节点类型是否支持减签
	 * @return
	 */
	private boolean nodetypeSupportReduceAuthor(int nodetype){
		//默认多人办理时支持加签
		if(NodeTypeEnum.Node_Order == nodetype 
				|| NodeTypeEnum.Node_Multi == nodetype){
			return true;
		}
		return false;
	}
	
	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		sendTodo();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
	/**
	 * 继承父类发送待办的方法
	 */
	protected void sendTodo(){
		String todoUserids = sendAuthor.toString();
		if(StringUtilExtend.isNull(todoUserids))return;
		DBTodo todo = makeDefaultDBTodo();
		String msgSendType = getSendType(getCurFlowNode(), StaticVarExtend.AUTH_AUTHOR, paraBean);//获取发送消息的方式
		makeSendInfoForNewAuth(todo,todoUserids,StaticVarExtend.AUTH_AUTHOR,StaticVarExtend.Send_Todo,
				msgSendType,getCurTrack(),getCurFlowNode());
		
	}
}
