package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.global.StaticVarExtend;

import java.util.List;
import java.util.Map;

/**
 * 从分表中恢复流转数据到运行表中
 * 非配置操作
 * @author liys
 * @version 1.0
 * @since v8.1
 */
public class ActionRecovery extends BaseAction implements ICustomAction {
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_RECOVERY);
		paraBean.setActionname(pubInfo.getInfo("Restore_Msg0002","恢复到运行库"));
		paraBean.setSubmitflag("0");

		msg = pubInfo.getInfo("Restore_Msg0003","恢复到运行库执行成功");
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}


	@Override
	public Map<String, List<Object>> actionBeforeSaveToDB() {
		return null;
	}

	@Override
	public void actionAfterSaveToDB() {

	}

	@Override
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		return false;
	}

	@Override
	public Map<String, List<Object>> actionForTask() {
		return null;
	}

	@Override
	public Map<String, String> getCancelTrackAuthRuleMap() {
		return null;
	}

	@Override
	public void cancelTrackAction(String cancelTrackid, List<DBWorkAuth> chgAuths) {

	}
}
