package com.horizon.wf.action;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.db.Access;
import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.entity.db.DBChgTodo;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.tools.DateUtil;
/**
 * 已阅
 * @author liys
 * @version 1.0
 * @since v7.0
 */
public class  ActionReaded extends BaseAction implements ICustomAction {
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_READED);
		setActionname("Readed_Msg0001","已阅");
		msg = pubInfo.getInfo("Readed_Msg0002","已阅标记成功");
		IRunUser curUser = getCurUser();
		
		List<DBWorkAuth> singleAuths = new ArrayList<DBWorkAuth>();
		
		doReaded(runningdata,curUser,false,singleAuths,todoLst);
		
		runningdata.setCurAuthToMap(singleAuths);
		memoBuffer.append(msg);
		executeEventSave();
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	
	private static boolean isChgAll = true;
	/**
	 * 处理待阅权限和已阅消息
	 * 只更新跟当前人userid和subjectionid匹配的待阅
	 * @param rd		RunningData
	 * @param curUser	
	 * @param backAuths 所有增加的权限
	 * @param todoList	待办列表
	 */
	public static void doReaded(RunningData rd,IRunUser curUser,boolean autoReaded,List<DBWorkAuth> backAuths,List<DBTodo> todoList){
	    if(isChgAll){
	        doReadedAll(rd,curUser,autoReaded,backAuths,todoList);
	    }
	    else{
	        doReadedOnly(rd,curUser,autoReaded,backAuths,todoList);
	    }
	}
	private static void doReadedOnly(RunningData rd,IRunUser curUser,boolean autoReaded,List<DBWorkAuth> backAuths,List<DBTodo> todoList){
		String identifier = rd.getInitData().getFlowIdentifier();
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		List<DBWorkAuth> singleAuths = new ArrayList<DBWorkAuth>();
		List<DBWorkAuth> auths = rd.getAllAuthListByStatus(StaticVarExtend.AUTH_READER);
		if(CollectionUtil.isListNotEmpty(auths)){
			for(int i=0,n=auths.size();i<n;i++){
				DBWorkAuth auth = auths.get(i);
				//查找完全匹配当前人的待阅,查找authId=userid的所有待阅
				if(auth.equalsRunUser(curUser)){
					auth.setStatus(StaticVarExtend.AUTH_READED);
					singleAuths.add(auth);
					if(autoReaded){
						chgTodo(todoList,auth);
					}
				}
			}
			//如果没有完全匹配当前人的权限,说明当前可能是集合类权限阅知
			if(singleAuths.isEmpty()){
				for(int i=0,n=auths.size();i<n;i++){
					DBWorkAuth auth = auths.get(i);
					if(auth.getAuthId().equals(StaticVarExtend.NullStr)
							&& auth.getSubjectionId().equals(curUser.getSubjectionid())){
						//增加一条权限信息
						auth.setAuthId(curUser.getUserid());
						auth.setStatus(StaticVarExtend.AUTH_READED);
						auth.setOldStatus("");
						newAuths.add(auth);
					}
						
				}
			}
		}
		else{
			updateAllReader(rd,todoList,curUser);
		}
		if(CollectionUtil.isListNotEmpty(newAuths)){
			for(int i=0,n=newAuths.size();i<n;i++){
				DBWorkAuth newAuth = newAuths.get(i);
				//增加一条已阅信息
				addTodo(todoList,newAuth,curUser,identifier);
				
				//放入返回列表中
				singleAuths.add(newAuth);
			}
		}

		backAuths.addAll(singleAuths);
	}
	/**
	 * 处理待阅权限和已阅消息
	 * 更新当前人的所有有权限的待阅（alluserid）
	 * @param rd		RunningData
	 * @param curUser	
	 * @param backAuths 所有增加的权限
	 * @param todoList	待办列表
	 */
	private static void doReadedAll(RunningData rd,IRunUser curUser,boolean autoReaded,List<DBWorkAuth> backAuths,List<DBTodo> todoList){
		String identifier = rd.getInitData().getFlowIdentifier();
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		List<DBWorkAuth> singleAuths = new ArrayList<DBWorkAuth>();
		List<DBWorkAuth> auths = rd.getAllAuthListByStatus(StaticVarExtend.AUTH_READER);
		List<DBWorkAuth> rdAuths = rd.getAllAuthListByStatus(StaticVarExtend.AUTH_READED);

		if(CollectionUtil.isListNotEmpty(auths)){
		    String[] allUserids = curUser.getAlluserid().split(",");
		    for(int i=0,n=auths.size();i<n;i++){
				DBWorkAuth auth = auths.get(i);
				//authid = userid 
				if(auth.getAuthId().equals(curUser.getUserid())){
					auth.setStatus(StaticVarExtend.AUTH_READED);
					singleAuths.add(auth);
					if(autoReaded){
						chgTodo(todoList,auth);
					}
				}
				else if(auth.getAuthId().equals(StaticVarExtend.NullStr) ){
                    //集合类的判断
                    if(subjectidIndexOfAlluserids(allUserids,auth.getSubjectionId())){
                        //在已阅中查找是否已有存在已阅记录,不存在时添加
                        if(!isInReaded(rdAuths,auth.getSubjectionId(),curUser.getUserid())){
                          //增加一条权限信息
                            auth.setAuthId(curUser.getUserid());
                            auth.setStatus(StaticVarExtend.AUTH_READED);
                            auth.setOldStatus("");
                            newAuths.add(auth);
                        }
                    }
                }
			}
		}
		else {
			//在没有待阅权限的时候,查找待阅记录,并更新
			//比如:在子流程结束时,发送的待阅信息
			updateAllReader(rd,todoList, curUser);
		}
		if(CollectionUtil.isListNotEmpty(newAuths)){
			for(int i=0,n=newAuths.size();i<n;i++){
				DBWorkAuth newAuth = newAuths.get(i);
				//增加一条已阅信息
				addTodo(todoList,newAuth,curUser,identifier);
				
				//放入返回列表中
				singleAuths.add(newAuth);
			}
		}

		
		backAuths.addAll(singleAuths);
	}
	private static boolean isInReaded(List<DBWorkAuth> rdAuths,String subjectionid,String userid ){
		for(int i=0,n=rdAuths.size();i<n;i++){
			DBWorkAuth auth = rdAuths.get(i);
	        //已阅记录中的subjectionid相等,authid = userid;
	       if(auth.getSubjectionId().equals(subjectionid) && userid.equals(auth.getAuthId())){
	           return true;
	       }
	    }
	    
	    return false;
	}
	
	//判断subjectid是否在alluserid中
    private static boolean subjectidIndexOfAlluserids(String[] alluserids,String subjectid){
        for(String orgid:alluserids){
            if(subjectid.equals(orgid)){
                return true;
            }
        }
        return false;
    }
	private static void updateAllReader(RunningData rd,List<DBTodo> todoList,IRunUser curUser){
		DBChgTodo dTodo = new DBChgTodo();
		dTodo._setStatus( StaticVarExtend.AUTH_READED);
		dTodo._setDotime(DateUtil.getNow());

		//设置where条件
		dTodo._setWhere_and_workid_equals(rd.getWork().getId());
		dTodo._setWhere_and_authId_equals(curUser.getUserid());
		dTodo._setWhere_and_status_equals(StaticVarExtend.AUTH_READER);

		todoList.add(dTodo);
	}
	private static void chgTodo(List<DBTodo> todoList,DBWorkAuth auth){
		DBChgTodo dTodo = new DBChgTodo();
		dTodo._setStatus( auth.getStatus());
		dTodo._setDotime(DateUtil.getNow());
		
		//where条件
		dTodo.setTrackid(auth.getTrackid());
		dTodo.setNodeid(auth.getNodeid());
		dTodo.setAuthId(auth.getAuthId());
		dTodo.setSubjectionId(auth.getSubjectionId());
		dTodo.setStatus( auth._getOldStatus());
		dTodo.setId(Access.getUUID());
		//20180814 拆分流转结束的数据到End表时,执行已阅需要的判断条件
		dTodo.setWorkid(auth.getWorkid());
		
		todoList.add(dTodo);
	}
	/**
	 * 增加已阅消息
	 * @param auth
	 * @param curUser
	 * @param identifier
	 * @return
	 */
	private static void addTodo(List<DBTodo> todoList,DBWorkAuth auth,IRunUser curUser,String identifier){
		DBTodo todo = new DBTodo();
		todo.setTrackid(auth.getTrackid());
		todo.setNodeid(auth.getNodeid());
		todo.setSubjectionId(auth.getSubjectionId());
		//数据被重置了,所以不能从auth对象中取值
		todo.setAuthId(StaticVarExtend.NullStr);	
		todo.setStatus(StaticVarExtend.AUTH_READER);//Reader,找到
		todo.setWorkid(auth.getWorkid());

		todo._setIdentifier(identifier);
		
		DBTodo dTodo = todo._getFromDBTodo();
		if(dTodo != null){
			//生成一条新的已阅数据
			dTodo.setAuthId(curUser.getUserid());
			dTodo.setId(Access.getUUID());
//			dTodo.setAuthId(dTodo.getFullNameWithAgent());
			dTodo.setDotime(DateUtil.getNow());
			dTodo.setStatus(auth.getStatus());
			todoList.add(dTodo);
		}
	}
	
	
	/** 
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if (isNotSaveToDB) {
			return;
		}
		actionStartTodoThread();
	}

	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}

}
