package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.entity.db.*;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.tools.DateUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
/**
 * 催办
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class ActionReMsg extends BaseAction implements ICustomAction {

	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_URGE);
		setActionname("ReMsg_Msg0001","催办");
		msg = pubInfo.getInfo("ReMsg_Msg0002","催办成功");
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();

		StringBuilder authors = new StringBuilder("");
		runningdata.setCurAuthToMap(null);
		if(getCurAuthor(authors)){
			//需要认领的情况下,不能催办
			runningdata.setBackMsg(pubInfo.getInfo("ReMsg_Msg0004","当前需要认领,不能进行催办"));
			runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
			runningdata.setCurAuthToMap(null);
			return false;
		}

		DBTask xdTask = DBTask.getTaskByTrackid(runningdata.getResultJson(),getCurTrackid(), identifier);
		if(xdTask!= null) {
			int reDoneNum = xdTask.getRedonenum();        //已经催办次数
			int reMsgNum = xdTask.getRemsgnum();        //允许催办次数

			if (reMsgNum > 0 && reMsgNum <= reDoneNum) {
				runningdata.setBackMsg(pubInfo.getInfo("ReMsg_Msg0003", "催办的次数超过限制"));
				runningdata.setResultCode(StaticVarExtend.F_STATUS_OverReMsg);
				runningdata.setCurAuthToMap(null);
				return false;
			}
			reDoneNum = reDoneNum + 1;
			xdTask.setRedonenum(reDoneNum);            //已经催办次数加1

			xdTask.getSQL(saveMap,runningdata.getResultJson());
		}

		//创建催办记录
		DBTaskLog xdTaskLog = new DBTaskLog();
		xdTaskLog.setId(StaticFunExtend.getUnid());
		xdTaskLog.setNodeid(getCurTrack().getNodeid());
		xdTaskLog.setNodename(getCurTrack().getNodename());
		xdTaskLog.setMemo(paraBean.getComment());
		xdTaskLog.setReceiver(authors.toString());
		xdTaskLog.setRemsgdate(DateUtil.getNow());
		xdTaskLog.setRemsgnode("");
		xdTaskLog.setSender(getCurUserid());
		xdTaskLog.setWorkid(getWorkid());
		xdTaskLog.setTitle(runningdata.getTitle());

		xdTaskLog.getSQL(saveMap,runningdata.getResultJson());
		if(!saveMap.isEmpty()){
			for(Map.Entry<String, List<Object>> entry : saveMap.entrySet() ){
				runningdata.putSQLToDataMap(entry.getKey(),entry.getValue());
			}
		}

		if(executeEventSave()){
			runningdata.setTitle(paraBean.getTitle());//设置待办发送的标题

			String username = getUsernameFormSelectedOrFromDB("",authors.toString());
			memoBuffer.append(pubInfo.getInfo("ReMsg_Msg0006","催促办理人:|username|")
					.replace("|username|", username));
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}


	/**
	 * 获取当前节点主办人
	 * 并判断是否需要认领
	 * @return
	 */
	private boolean getCurAuthor(StringBuilder authors){
		List<DBWorkAuth> auths = runningdata.getXAuthListForCurNode(StaticVarExtend.AUTH_AUTHOR);
		if(CollectionUtil.isListNotEmpty(auths)){
			List<DBWorkAuth> aList = new ArrayList<DBWorkAuth>();
			for(int i=0,n=auths.size();i<n;i++){
				DBWorkAuth auth = auths.get(i);
				if(StaticVarExtend.NullStr.equals(auth.getAuthId())){
					return true;
				}
				authors.append(auth._getFullNameWithAgent());
				authors.append(StaticVarExtend.UserSplitChar);

				auth.setStatus(StaticVarExtend.AUTH_READER);
				auth.setOldStatus("");

				auth.setIgnoreXmlUpdate(true);
				String agentid = auth.getAgentId();
				if(!agentid.equals(StaticVarExtend.NullStr)){
					auth.setAgentId(StaticVarExtend.NullStr);
					//新建一个reader权限
					DBWorkAuth newAuth = auth.cloneAuth();
					newAuth.setAuthId(agentid);
					newAuth.setStatus(StaticVarExtend.AUTH_READER);
					newAuth.setOldStatus("");
					aList.add(newAuth);
				}
			}
			if(!aList.isEmpty()){
				auths.addAll(aList);
			}
		}
		return false;
	}
	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		sendTodo();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);
		}
		return true;
	}

	protected void sendTodo() {
		List<DBWorkAuth> auths = getXAuthList(StaticVarExtend.AUTH_AUTHOR);
		if (CollectionUtil.isListNotEmpty(auths)) {
			DBTodo todo = makeDefaultDBTodo();
			DBTrack track = getCurTrack();
			todo.setTrackid(track.getId());
			todo.setNodeid(track.getNodeid());
			todo.setNodename(track.getNodename());
			todo.setWorkver((track.getVersion()));
			todo.setTrackactive(String.valueOf(track.getActive()));
			todo.setTrackstatus(String.valueOf(track.getFlowstatus()));
			todo.setStatus(StaticVarExtend.AUTH_READER);

			todo.setTitle("[" + pubInfo.getInfo("ReMsg_Msg0001", "催办") + "]"
					+ ac.getTodoTitle(getCurTrackid(), getCurFlowNode(),
					runningdata, StaticVarExtend.Send_Read, StaticVarExtend.AUTH_READER));
			boolean isActiveTodo = true;
			//			String activeTodo = isActiveTodoMap.get(getCurNodeid());
			//			if(StringUtilExtend.isNotNull(activeTodo)){
			//				isActiveTodo = false;
			//			}
			todo.setIsactive(isActiveTodo ? "1" : "0");
			String sendType = paraBean.getMsgSendFlagMap().get(StaticVarExtend.AUTH_READER);
			todo._setOtherstatus(sendType);
			for (int i = 0, n = auths.size(); i < n; i++) {
				DBWorkAuth auth = auths.get(i);
				DBTodo oTodo = todo.copy();
				oTodo.setAuthId(auth._getFullNameNoAgent());
				todoLst.add(oTodo);
				//给代理人也发送一条待阅，因为待阅不能跟authid共用一条
				if (!auth.getAgentId().equals(StaticVarExtend.NullStr)) {
					DBTodo aTodo = todo.copy();
					aTodo.setAuthId(auth.getAgentId());
					todoLst.add(aTodo);
				}
			}
			//20220818新增催办触发其他消息给主办身份
			String msgSendType = getSendType(getCurFlowNode(), StaticVarExtend.AUTH_AUTHOR,paraBean);
			String newotherSendtype = msgSendType.replaceAll("\\|", StaticVarExtend.StrSplitChar);
			String[] msgSendTypes = newotherSendtype.split(StaticVarExtend.StrSplitChar);
			for (String str : msgSendTypes) {
				for (int i = 0, n = auths.size(); i < n; i++) {
					DBTodo oTodo = todo.copy();
					oTodo.setStatus("");
					oTodo._setOtherstatus(str);
					DBWorkAuth auth = auths.get(i);
					oTodo.setAuthId(auth._getFullNameNoAgent());
					todoLst.add(oTodo);
					//给代理人也发送一条待阅，因为待阅不能跟authid共用一条
					if (!auth.getAgentId().equals(StaticVarExtend.NullStr)) {
						DBTodo aTodo = todo.copy();
						oTodo.setStatus("");
						oTodo._setOtherstatus(str);
						aTodo.setAuthId(auth.getAgentId());
						todoLst.add(aTodo);
					}
				}
			}
		}
	}
}
