package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.entity.db.DBChgTodo;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.tools.DateUtil;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 暂停流程,可恢复
 * 1)办理人执行时,暂停当前track,待办中的流程状态trackstatus变更为暂停
 * 2)管理员执行时,暂停所有track,待办中的流程状态trackstatus由暂停恢复到暂停之前的状态
 *   根据当前路径是否暂停状态来确定本次管理员的操作是恢复还是暂停
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class ActionPause extends BaseAction implements ICustomAction {
	private List<DBTrack> tracklst;
	public boolean execute(ITaskNode curTaskNode) {
		IRunUser curUser = getCurUser();
		boolean isManager = curUser.isManager();
		msg = pubInfo.getInfo("Pause_Msg0002","暂停流程成功");
		if(isnewdoc<2){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Pause_Msg0003","当前流程处于起草状态，无法暂停");
		}
		else if(isManager){
			managerAction();
		}
		else{
			authorAction();
		}
		runningdata.setCurAuthToMap(null);
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
		
	}	
	
	/**
	 * 办理人执行时
	 */
	private void authorAction(){
		DBTrack curTrack = getCurTrack();
		if(StaticVarExtend.FlowStatus_End == curTrack.getFlowstatus()){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Pause_Msg0004","结束节点，无法暂停.");
			return;
		}
		else if(StaticVarExtend.FlowStatus_ErrorEnd == curTrack.getFlowstatus()){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Pause_Msg0005","流程已经终止或者已结束,无法暂停");
			return;
		}
		else if(StaticVarExtend.FlowStatus_Cancel == curTrack.getFlowstatus()){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Pause_Msg0006","撤销状态下不能暂停.");
			return;
		}
		String timerType = "";
//		执行暂停和恢复
		if(StaticVarExtend.FlowStatus_Pause == curTrack.getFlowstatus()){
			paraBean.setActionname(pubInfo.getInfo("Action_Msg0010","恢复"));
			//暂停恢复
			runningdata.putMsgToConsole("[msg]pause operator: node is pause,change restore.");
			runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_RESTORE);
			
			curTrack.setFlowstatus(getCurTrack()._getTrackJson().getOldStatus(StaticVarExtend.FlowStatus_Pause));
			
			msg = pubInfo.getInfo("Pause_Msg0007","暂停恢复成功");
			memoBuffer.append(pubInfo.getInfo("Pause_Msg0009","分支暂停恢复"));
			timerType =  "restore";
		}
		else{
			runningdata.putMsgToConsole("[msg]pause operator: node is pause.");
			runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_PAUSE);
			setActionname("Pause_Msg0001","暂停");
			runningdata.setOldStatus(curTrack.getId(),StaticVarExtend.FlowStatus_Pause, curTrack.getFlowstatus());
			curTrack.setFlowstatus(StaticVarExtend.FlowStatus_Pause);
			memoBuffer.append(pubInfo.getInfo("Pause_Msg0008","分支暂停"));
			timerType = "cancel";
		}
		
		//待办恢复
		//当前路径下的待办处理,修改为Reader
		List<DBTodo> list = getListTodoByTrackid(curTrack.getId());
		if(!(list == null || list.isEmpty())){
			for(int i=0,n=list.size();i<n;i++){
				DBTodo a  = list.get(i);
				DBChgTodo todo = new DBChgTodo();
				todo.setTrackid(a.getTrackid());
				todo.setNodeid(a.getNodeid());
				todo.setStatus(a.getStatus());
				todo.setAuthId(a.getAuthId());
				todo.setSubjectionId(a.getSubjectionId());
				
				todo._setTrackstatus(String.valueOf(curTrack.getFlowstatus()));
				todo._setDotime(DateUtil.getNow());
				todoLst.add(todo);
			}
		}
		runningdata.setUpdateTask(true);
		result = StaticVarExtend.F_STATUS_Success;
		ac.dowithTimer(timerType, getCurNodeType(), runningdata, getIdentifier());
	}
	/**
	 * 管理员执行时
	 */
	private void managerAction(){
		tracklst = runningdata.getAllTrackBeforeEndByWorkid(getWorkid());
		int check = checkTrackIsCancel();
		if(check == 1){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Pause_Msg0006","撤销状态下不能暂停.");
		}
		else if(check == 2){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Pause_Msg0005","流程已终止或者已结束,无法暂停");
		}
		else{
			DBTrack curTrack = getCurTrack();
//			记录路径对应的流程状态
			Map<String,String> statusMap = new HashMap<String,String>();
			//根据当前路径是否暂停状态来确定本次管理员的操作是恢复还是暂停
			if(StaticVarExtend.FlowStatus_Pause == curTrack.getFlowstatus()){
				paraBean.setActionname(pubInfo.getInfo("Action_Msg0010","恢复"));
				//暂停恢复
				runningdata.putMsgToConsole("[msg]pause operator: node is pause,change restore.");
				runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_RESTORE);
				
				//修改track状态
				IFlowInfo flowInfo = runningdata.getInstanceDefinition().getFlowinfo();
				for(int i=0,n=tracklst.size();i<n;i++){
					DBTrack track = tracklst.get(i);
					if(StaticVarExtend.FlowStatus_Pause == track.getFlowstatus()){
						track.setFlowstatus(runningdata.getTrackOldStatusForCancelRestore(track.getId(),track.getFlowstatus()));
						if(curTrack.getId().equals(track.getId())){
							curTrack.setFlowstatus(track.getFlowstatus());
						}
						else{
							track.setFunname(StaticVarExtend.OPERATOR_FUNNAME_RESTORE);
						}
						String nodeid = track.getNodeid();
						IFlowNode xmlNode = flowInfo.getNodeById(nodeid);
						ac.dowithTimer("restore", xmlNode.getNodetype(),nodeid,track.getId(), runningdata, getIdentifier());
						
						statusMap.put(track.getId(), String.valueOf(track.getFlowstatus()));
					}
				}
				
				msg = pubInfo.getInfo("Pause_Msg0007","暂停恢复成功");
				memoBuffer.append(pubInfo.getInfo("Pause_Msg0011","流程暂停恢复"));
			}
			else{
				runningdata.putMsgToConsole("[msg]pause operator: node is pause.");
				runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_PAUSE);
				setActionname("Pause_Msg0001","暂停");
				memoBuffer.append(pubInfo.getInfo("Pause_Msg0010","流程暂停"));
				//修改track状态
				IFlowInfo flowInfo = runningdata.getInstanceDefinition().getFlowinfo();
				for(int i=0,n=tracklst.size();i<n;i++){
					DBTrack track = tracklst.get(i);
					if(StaticVarExtend.FlowStatus_Pause != track.getFlowstatus()){
						runningdata.setOldStatus(track.getId(),StaticVarExtend.FlowStatus_Pause, track.getFlowstatus());
						track.setFlowstatus(StaticVarExtend.FlowStatus_Pause);
						if(curTrack.getId().equals(track.getId())){
							curTrack.setFlowstatus(track.getFlowstatus());
						}
						else{
							track.setFunname(StaticVarExtend.OPERATOR_FUNNAME_PAUSE);
						}
						String nodeid = track.getNodeid();
						IFlowNode xmlNode = flowInfo.getNodeById(nodeid);
						ac.dowithTimer("cancel", xmlNode.getNodetype(),nodeid,track.getId(), runningdata, getIdentifier());
						
						statusMap.put(track.getId(), String.valueOf(track.getFlowstatus()));
					}
				}
			}
			runningdata.setUpdateTask(true);
			//待办处理
			//当前所有路径下的待办处理,修改为Reader
			List<DBTodo> list = getListTodoByWorkid(getWorkid());
			if(!(list == null || list.isEmpty())){
				for(int i=0,n=list.size();i<n;i++){
					DBTodo a  = list.get(i);
					String status = statusMap.get(a.getTrackid());
					if(status == null || "".equals(status)){
						continue;
					}
					
					DBChgTodo todo = new DBChgTodo();
					todo.setTrackid(a.getTrackid());
					todo.setNodeid(a.getNodeid());
					todo.setStatus(a.getStatus());
					todo.setAuthId(a.getAuthId());
					todo.setSubjectionId(a.getSubjectionId());
					
					todo._setTrackstatus(status);
					todo._setDotime(DateUtil.getNow());
					todoLst.add(todo);
				}
			}
		}
	}

	/**
	 * 判断路径是否为撤销状态和结束状态
	 * @return 0=正常,1=撤销 ,2=全部结束
	 */
	private int checkTrackIsCancel(){
		boolean isEnd = true;
		for(int i=0,n=tracklst.size();i<n;i++){
			DBTrack track = tracklst.get(i);
			int flowstatus = track.getFlowstatus();
			if(flowstatus == StaticVarExtend.FlowStatus_Cancel){
				return 1;
			}
			if(!(flowstatus == StaticVarExtend.FlowStatus_End || flowstatus == StaticVarExtend.FlowStatus_ErrorEnd)){
				isEnd = false;
			}
		}
		if(isEnd){
			return 2;
		}
		return 0;
	}
	/**
	 * 获取指定路径下所有办理人的工作列表
	 * @return
	 */
	private List<DBTodo> getListTodoByTrackid(String trackid){
		List<DBTodo> list = DBTodo
				.getTodoListByTrackid(runningdata.getResultJson(),trackid, getIdentifier());
		return list;
	}
	
	/**
	 * 获取实例下所有办理人的工作列表
	 * @param workid
	 * @return
	 */
	private List<DBTodo> getListTodoByWorkid(String workid){
		List<DBTodo> list = DBTodo
				.getTodoListByWorkid(runningdata.getResultJson(),workid, getIdentifier());
		return list;
	}
	
	/**
	 * 用于操作完成时,更新所有路径信息时获取所有需要更新的路径对象
	 * 默认为null,由后台自动去库表中获取,
	 * 但在撤办/结束/暂停操作中由于需要对所有路径进行处理,所以此处需要返回处理后的路径列表信息
	 * @return
	 */
	public List<DBTrack> getAllOldTrack(){
		return tracklst;
	}
	
	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
	    Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
	    if(tracklst == null || tracklst.isEmpty()) {
			actionForTask(saveMap);
		}
		else {
			for (int i = 0, n = tracklst.size(); i < n; i++) {
				DBTrack track = tracklst.get(i);
				createTaskObj(null,track,saveMap,true,false);
			}
		}
        return saveMap;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
}
