package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.api.AgentUtil;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.tools.CStrUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 转办操作
 * 将当前人状态改为已办
 * 增加新的办理人
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class ActionMove extends BaseAction implements ICustomAction {
	private String selectUser="";
	private String selectedKey;
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_MOVE);
		setActionname("Move_Msg0001","转办");
		if(!indexOfAuthor(getCurAuthName(),getCurNodeid())){
			runningdata.putMsgToConsole("[msg]move operator no auth.");
			msg = pubInfo.getInfo("Move_Msg0002","无权转办");
			result = StaticVarExtend.F_STATUS_OtherError;
		}else if(null == selectedUsers || selectedUsers.size()==0){
			/*
			//如果需要从当前节点的办理人中选择时,把需要选择的人员列表放在initAuthorMap中,
			//com.horizon.workflow.support.action.AuthorSubmitAction#setSelectAuthors这个方法
			//中的第一行添加super.setSelectAuthors(flowAuthor, authorKey);

			//==========获取自定义办理人开始=======
			IFlowNode xmlNode = getCurXmlNode();
			INodeAuthUser xmluser = xmlNode.getParticipantsUser("Author");
			resultBean     = (WorkResultBean)runningdata.getHmiResultObject();
			Map<String, String>  initAuthorMap = resultBean.getInitAuthorMap();
			StringBuilder sb = new StringBuilder(2000);
			EntryRuleDefault.getUserFromXMLSet(sb,xmlNode,xmluser,runningdata,null,null);
				//System.out.println("办理人为-----"+custome);
			if(sb.length()>0) {
				initAuthorMap.put(xmlNode.getNodeid() + "-Author", sb.toString());
			}
			//=========获取自定义办理人结束========
			//*/
			runningdata.putMsgToConsole("[msg]move operator need author.");
			result = StaticVarExtend.F_STATUS_SelectAuthor;
			msg = pubInfo.getInfo("Move_Msg0003","请指定转办人");
		}else{
			//获取当前节点的所有办理人
			List<DBWorkAuth> auths = getXAuthList(StaticVarExtend.AUTH_AUTHOR);
			List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
			//20150921 liys 所有节点类型都需要修改PlanId
//			int nodetype = getCurNodeType();
			boolean isOrder =  true;//nodetype == NodeTypeEnum.Node_Order ;
			for(int i=0,n= auths.size();i<n;i++){
				DBWorkAuth auth = auths.get(i);
				
				//当前人是否是办理人，如果是则转换成选定的办理人
				if(auth.equalsRunUser(getCurUser())){
					newAuths.add(auth);
					//新建转办人对象
					DBWorkAuth newAuth = addNewAuth(auth);
					if(newAuth == null){
						runningdata.putMsgToConsole("[msg]move operator need author.");
						result = StaticVarExtend.F_STATUS_SelectAuthor;
						msg = pubInfo.getInfo("Move_Msg0003","请指定转办人");
						runningdata.setBackMsg(msg);
						runningdata.setResultCode(result);
						return true;
					}
					
					newAuths.add(newAuth);
					
					if(isOrder){
						chgXml(auth,newAuth);
					}
					//原来办理人改为CReader
					auth.setStatus(StaticVarExtend.AUTH_CREADER);
					
					ac.dowithTimer("cancel", getCurNodeType(), runningdata, getIdentifier());//如果当前节点包含定时任务则撤销定时任务
					break;
				}
			}
			runningdata.setCurAuthToMap(newAuths);
			msg = pubInfo.getInfo("Move_Msg0004","转办成功");
			
			String username = getUsernameFormSelectedOrFromDB(selectedKey,selectUser);
			memoBuffer.append(pubInfo.getInfo("Move_Msg0005","转办给办理人:|username|")
					.replace("|username|", username));
			
			result = StaticVarExtend.F_STATUS_Success;
			executeEventSave();//执行操作完成事件
			runningdata.putMsgToConsole("[msg]move operator success.");
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	
	/**
	 * 判断给定的权限名称是否是主办
	 * @param authname
	 * @return true:拥有主办权限
	 */
	private boolean indexOfAuthor(String authname){
		if(StringUtilExtend.isNull(authname)){
			return false;
		}
		return authname.indexOf(StaticVarExtend.AUTH_AUTHOR)>=0;
	}
	
	/**
	 * 判断给定的权限名称是否是当前节点主办
	 * @return true:拥有主办权限
	 */
	private boolean indexOfAuthor(String name,String nodeid){
		if(StringUtilExtend.isNull(name)){
			return false;
		}
		if(name.startsWith(nodeid)){
			String authname = subNodeidFromAuthname(name, nodeid);
			return StaticVarExtend.AUTH_AUTHOR.equals(authname);
		}
		return indexOfAuthor(name);
	}
	
	/**
	 * 判断给定的authname是否已nodeid开头 如果是则截取掉nodeid
	 * @param authname
	 * @param nodeid
	 * @return 权限名称
	 */
	private String subNodeidFromAuthname(String authname,String nodeid){
		if(authname.startsWith(nodeid)){
			return authname.split(StaticVarExtend.MARK_NODE_USER)[1];
		}
		return authname;
	}
	
	
	private void chgXml(DBWorkAuth oldauth,DBWorkAuth newauth){
		ITrackUserJson tUser = getCurTrack()._getTrackNode().getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
		String planId = tUser.getPlanId();
		List<AuthUserImpl> lstPlan = AuthUserImpl.getAuthUserList(planId);
		StringBuilder newPlan = new StringBuilder(1000);
		for(int i=0,n=lstPlan.size();i<n;i++){
			AuthUserImpl p = lstPlan.get(i);
			newPlan.append(StaticVarExtend.UserSplitChar);
			if(p.isSameAuth(oldauth)){
				newPlan.append(newauth.getAuthId()); //newauth中的authid是未分拆的
			}
			else{
				newPlan.append(p._getFullNameWithAgent());
			}
		}
		newPlan.deleteCharAt(0);
		runningdata.setPlanId_ForTrackUser(tUser, newPlan.toString());
	}
	
	/**
	 * 构造一个新的转办对象
	 * @param auth
	 * @return
	 */
	private DBWorkAuth addNewAuth(DBWorkAuth auth) {
		getSelectParticipants();
		if(CStrUtil.isNull(selectUser)){
			return null;
		}
		INodeAuthUser xmluser = getCurFlowNode().getParticipantsUser(StaticVarExtend.AUTH_AUTHOR);
		if(null != xmluser && xmluser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_AgentFlag) != -1){
			//调用代理
			selectUser = AgentUtil.getInstance().getAgentUser(selectUser, getWorkid(), getWork().getFlowid(), getIdentifier());				
		}
		
		DBWorkAuth newAuth = new DBWorkAuth();
		
		newAuth.setAuthId(selectUser);
		newAuth.setAuthNo(auth.getAuthNo());
		
		newAuth.setNodeid(auth.getNodeid());
		newAuth.setStatus(auth.getStatus());
		newAuth.setOldStatus(auth._getOldStatus());
		newAuth.setTrackid(auth.getTrackid());
		newAuth.setVersion(auth.getVersion()+1);
		newAuth.setWorkid(auth.getWorkid());
		newAuth.setNodenum(auth.getNodenum());
		return newAuth;
	}
	
	/**
	 * 获取选中的参与者，如果有多个，则返回第一个
	 * @return
	 */
	private void getSelectParticipants(){
		selectedKey = getCurNodeid()+StaticVarExtend.MARK_NODE_USER+StaticVarExtend.AUTH_AUTHOR;
		selectUser = selectedUsers.get(selectedKey);
		if(CStrUtil.isNull(selectUser)){
			selectedKey = StaticVarExtend.AUTH_AUTHOR;
			selectUser = selectedUsers.get(selectedKey);
		}
		
//		StringBuilder parti = new StringBuilder();
//		Set<Map.Entry<String,String>> set = selectedUsers.entrySet();
//		for(Map.Entry<String,String> entry : set){
//			parti.append(entry.getValue()).append(StaticVarExtend.UserSplitChar);
//		}
//		if(StringUtilExtend.isNotNull(parti.toString())){
//			//将传入的办理人取第一个返回
//			return parti.toString().split(StaticVarExtend.UserSplitChar)[0];
//		}
//		return parti.toString();
	}
	
	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		sendTodo();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
	/**
	 * 继承父类发送待办的方法
	 */
	protected void sendTodo(){
		DBTodo todo = makeDefaultDBTodo();
		String msgSendType = getSendType(getCurFlowNode(), StaticVarExtend.AUTH_AUTHOR, paraBean);//获取发送消息的方式
		
		makeSendInfoForNewAuth(todo,selectUser,StaticVarExtend.AUTH_AUTHOR,StaticVarExtend.Send_Todo,
				msgSendType,getCurTrack(),getCurFlowNode());
		
	}
}
