package com.horizon.wf.action;

import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 加签操作实现类
 * 支持单人办理和多人办理节点的加签操作
 * 前台指定的加签人如果与节点本身的办理人重复，则去掉节点本身的办理人，将新的加签人放到本身办理人的前面
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class ActionJiaQianBefore extends ActionJiaQian implements ICustomAction{
	protected void setFunnameToRunningdata(){
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_JIAQIAN_BEFORE);
		setActionname("Jiaqian_Msg1001","前加签");
	}
	/**
	 * 判断节点类型是否支持加签
	 * @return
	 */
	protected boolean nodetypeSupportJiaqian(int nodetype){
		//只有顺签节点执行前加签
		if( NodeTypeEnum.Node_Order == nodetype){
			return true;
		}
		return false;
	}
	/**
	 * 前加签重写顺签处理
	 * @param track
	 * @param oldAuths
	 * @param newAuths
	 * @return
	 */
	protected List<DBWorkAuth> dowithForOrderNode(DBTrack track,List<DBWorkAuth> oldAuths,List<DBWorkAuth> newAuths){
		if(getCurNodeType() == NodeTypeEnum.Node_Order){
			doWithForOrderNode(newAuths,oldAuths);
		}
		else{
			String username = getUsernameFormSelectedOrFromDB(selectedKey,sendAuthor.toString());
			memoBuffer.append(pubInfo.getInfo("Jiaqian_Msg1002","前加签给:|username|")
					.replace("|username|", username));
		}
		return newAuths;
	}
	private void doWithForOrderNode(List<DBWorkAuth> newAuths,List<DBWorkAuth> oldAuths){
		//删除当前人的办理,添加当前人已办理到Done节点的PlanId
		DBWorkAuth nowAuth = newAuths.get(0);
		DBWorkAuth oldAuth = oldAuths.get(0);
		DBTrack track = getCurTrack();
		//更新办理人的PlanId		
		ITrackUserJson tAuthorUser = track._getTrackNode().getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
		String oldPlanId = tAuthorUser.getPlanId();
		//20171020 liys 修改
		//当前当前执行人在顺序列表中多于一个时,还需要获取当前执行人的位置
		//已办理人
		ITrackUserJson  trackRdyUser = track._getTrackNode().getTrackUserImpl(StaticVarExtend.AUTH_DONE,StaticVarExtend.AUTH_AUTHOR);
		String doneId = trackRdyUser.getNowId(); 
		List<AuthUserImpl> doneAuthLst =  AuthUserImpl.getAuthUserList(doneId);
		int doneSize = doneAuthLst.size();//记录已经办理的人数,用于后面循环的起始计数
		
		StringBuilder newPlanId = new StringBuilder(1000);
		List<AuthUserImpl> oList = AuthUserImpl.getAuthUserList(oldPlanId);
		for(int i=0,n=oList.size();i<n;i++){
			AuthUserImpl oUser = oList.get(i);
			if(i < doneSize){
				//已办的人直接放入列表中
				newPlanId.append(StaticVarExtend.UserSplitChar).append(oUser._getFullNameWithAgent());
				continue;
			}
			
			if(oldAuth.isSameAuth(oUser)){
				newPlanId.append(StaticVarExtend.UserSplitChar).append(sendAuthor);
			}
			newPlanId.append(StaticVarExtend.UserSplitChar).append(oUser._getFullNameWithAgent());
		}
		//删除第一个分号
		newPlanId.deleteCharAt(0);
		//重置办理人的PlanId
		runningdata.setPlanId_ForTrackUser(tAuthorUser, newPlanId.toString());
		//重置办理人的NowId
		String nowId = nowAuth._getFullNameWithAgent();
		runningdata.setNowId_ForTrackUser(tAuthorUser, nowId);
		
		
		//更新已办人的PlanId
//		IXmlTrackUser tDoneUser = track.getTrackNode().getTrackUserImpl(StaticVarExtend.AUTH_DONE,StaticVarExtend.AUTH_AUTHOR);
//		String doneId = tDoneUser.getPlanId() + StaticVarExtend.UserSplitChar + oldAuth.getFullNameWithAgent();
//		runningdata.setPlanId_ForTrackUser(tDoneUser, doneId);
		
		//更新当前人的待办为只读
		oldAuth.setStatus(StaticVarExtend.AUTH_CREADER);
		
		newAuths.clear();
		newAuths.add(nowAuth);
		newAuths.add(oldAuth);
		sendAuthor.delete(0, sendAuthor.length());
		sendAuthor.append(nowId);
		
		
		String username = getUsernameFormSelectedOrFromDB(selectedKey,nowId);
		memoBuffer.append(pubInfo.getInfo("Jiaqian_Msg1002","前加签给:|username|")
				.replace("|username|", username));
	}
	
	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}
	
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
	}
	
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
	}
	
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		sendTodo();
		actionBefore(saveMap);
		return saveMap ;
	}
	
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}

}
