package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.api.AgentUtil;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 加签操作实现类
 * 支持单人办理和多人办理节点的加签操作
 * 前台指定的加签人如果与节点本身的办理人重复，则去掉节点本身的办理人，将新的加签人放到本身办理人的后面
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class ActionJiaQian extends BaseAction implements ICustomAction{
	protected StringBuilder sendAuthor = new StringBuilder("");	//发送待办的参与者id
	private String selectUser="";	
	protected String selectedKey;
	protected void setFunnameToRunningdata(){
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_JIAQIAN);
		setActionname("Jiaqian_Msg0001","加签");
	}
	public boolean execute(ITaskNode curTaskNode) {
		setFunnameToRunningdata();
		if(isJiaQian()){
			List<DBWorkAuth> auths = getXAuthList(StaticVarExtend.AUTH_AUTHOR);
			runningdata.putMsgToConsole("[msg]jiaqian operator start.");
			
			List<DBWorkAuth> newAuth = addAuth(auths);
			if(newAuth == null){
				result = StaticVarExtend.F_STATUS_OtherError;
				runningdata.setBackMsg(msg);
				runningdata.setResultCode(result);
				return false;
			}
			runningdata.setCurAuthToMap(newAuth);//增加办理人
			runningdata.putMsgToConsole("[msg]jiaqian operator real author is :"+sendAuthor);
			result = StaticVarExtend.F_STATUS_Success;
			msg = pubInfo.getInfo("Jiaqian_Msg0002","加签成功");
			executeEventSave();//执行操作完成事件
			runningdata.putMsgToConsole("[msg]jiaqian operator is end.");
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	/**
	 * 判断是否有加签权限
	 * @return
	 */
	private boolean isJiaQian(){
		int nodetype = getCurNodeType();
		if(!nodetypeSupportJiaqian(nodetype)){
			runningdata.putMsgToConsole("[msg]jiaqian operator :not support nodetype.nodetype:"+nodetype);
			result = StaticVarExtend.F_STATUS_Not_Operator_Nodetype;
			msg = pubInfo.getInfo("Jiaqian_Msg0003","该节点类型不支持加签操作");
			return false;
		}else if(!getCurAuthName().equals(StaticVarExtend.AUTH_AUTHOR)){
			runningdata.putMsgToConsole("[msg]curUser auth can't jiaqian operator.");
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Jiaqian_Msg0004","当前人的权限不允许加签");
			return false;
		}
		else if(CollectionUtil.isMapEmpty(selectedUsers)){
			runningdata.putMsgToConsole("[msg]jiaqian operator need select author.");
			result = StaticVarExtend.F_STATUS_SelectAuthor;
			msg = pubInfo.getInfo("Jiaqian_Msg0005","请指定加签人");
			return false;
		}
		return true;
	}
	
	/**
	 * 生成加签人
	 * @return
	 */
	private List<DBWorkAuth> addAuth(List<DBWorkAuth> oldAuths) {
		if(CollectionUtil.isMapEmpty(selectedUsers)){
			runningdata.putMsgToConsole("[msg]before jiaqian operator getAuthor is null from selectedUsers.");
			return null;
		}
		selectedKey = getCurNodeid()+StaticVarExtend.MARK_NODE_USER+StaticVarExtend.AUTH_AUTHOR;
		selectUser = selectedUsers.get(selectedKey);
		if(StringUtilExtend.isNull(selectUser)){
			selectedKey = StaticVarExtend.AUTH_AUTHOR;
			selectUser = selectedUsers.get(selectedKey);
		}
		if(StringUtilExtend.isNull(selectUser)){
			msg = pubInfo.getInfo("Jiaqian_Msg0005","请指定加签人");
			return null;
		}
		INodeAuthUser xmluser = getCurFlowNode().getParticipantsUser(StaticVarExtend.AUTH_AUTHOR);
		if(null != xmluser && xmluser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_AgentFlag) != -1){
			selectUser = AgentUtil.getInstance().getAgentUser(selectUser, getWorkid(), getWork().getFlowid(), getIdentifier());								
		}
		List<AuthUserImpl> sList = AuthUserImpl.getAuthUserList(selectUser);
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		DBTrack track = getCurTrack();
		String authname = getCurAuthName();//StaticVarExtend.AUTH_AUTHOR
		
		for(int i=0,n=sList.size();i<n;i++){
			AuthUserImpl newAuth = sList.get(i);
			boolean noHave = true;
			for(int j=0,m=oldAuths.size();j<m;j++){
				DBWorkAuth oldAuth = oldAuths.get(j);
				if(oldAuth.isSameAuth(newAuth)){
					noHave = false;
					break;
				}
			}
			if(noHave){
				sendAuthor.append(StaticVarExtend.UserSplitChar).append(newAuth._getFullNameWithAgent());
				DBWorkAuth nAuth = newAuth.copyToWorkAuth();
				nAuth.setNodeid(track.getNodeid());
				nAuth.setStatus(authname);
				nAuth.setTrackid(track.getId());
				nAuth.setVersion(track.getVersion()+1);
				nAuth.setWorkid(track.getWorkid());
				nAuth.setNodenum(track.getNodenum());
				newAuths.add(nAuth);
			}
		}
		if(sendAuthor.length()>0){
			sendAuthor.deleteCharAt(0);
			return dowithForOrderNode(track,oldAuths,newAuths);
		}
		else{
			msg = pubInfo.getInfo("Jiaqian_Msg0006","指定加签人已存在当前办理人列表中.");
			return null;
		}
	}
	/**
	 * 顺签处理,前加签重写
	 * @param track
	 * @param oldAuths
	 * @param newAuths
	 * @return
	 */
	protected List<DBWorkAuth> dowithForOrderNode(DBTrack track,List<DBWorkAuth> oldAuths,List<DBWorkAuth> newAuths){
		ITrackUserJson tUser = track._getTrackNode().getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
		
		if(getCurNodeType() == NodeTypeEnum.Node_Order){
			if(doWithForOrderNode(tUser,oldAuths)){
				return null;
			}
			String username = getUsernameFormSelectedOrFromDB(selectedKey,sendAuthor.toString());
			memoBuffer.append(pubInfo.getInfo("Jiaqian_Msg0007","加签给:|username|")
					.replace("|username|", username));
			sendAuthor.delete(0, sendAuthor.length());//删除需要发送待办的记录
			return new ArrayList<DBWorkAuth>(); //顺签时不需要往数据库中增加,所以返回空
		}
		else{
			String username = getUsernameFormSelectedOrFromDB(selectedKey,sendAuthor.toString());
			memoBuffer.append(pubInfo.getInfo("Jiaqian_Msg0007","加签给:|username|")
					.replace("|username|", username));
			//在planid中增加
			String tmp = sendAuthor.toString();
			
			sendAuthor.append(StaticVarExtend.UserSplitChar).append(tUser.getPlanId());
			runningdata.setPlanId_ForTrackUser(tUser, sendAuthor.toString());
			
			sendAuthor.delete(0,sendAuthor.length());
			sendAuthor.append(tmp);
			return newAuths;
		}
	}
	
	/**
	 * 处理顺签节点办理人
	 */
	private boolean doWithForOrderNode(ITrackUserJson tUser,List<DBWorkAuth> oldAuths){
		DBWorkAuth oldAuth = oldAuths.get(0);
		String oldPlanId = tUser.getPlanId();
		StringBuilder newPlanId = new StringBuilder();
		List<AuthUserImpl> oList = AuthUserImpl.getAuthUserList(oldPlanId);
		//20161107 liys 对同一个人多次加签进行处理
		List<AuthUserImpl> sList = AuthUserImpl.getAuthUserList(sendAuthor.toString());
		int pos =0;	//用来记录当前人在原来的列表中的位置坐标,从当前人的位置开始往后查找是否有加签的人
		int size = oList.size();
		for(int i=0;i<size;i++){
			//获取当前人的位置
			pos ++ ;
			AuthUserImpl oUser = oList.get(i);
			if(oldAuth.isSameAuth(oUser)){
				break;
			}
		}
		//清空,重新获取可以加签的人
		sendAuthor.delete(0, sendAuthor.length());
		
		for(int k=0,n=sList.size();k<n;k++){
			AuthUserImpl aAuth  = sList.get(k);
			//从指定位置开始查找
			boolean noHave = true;
			for(int i=pos;i<size;i++){
				AuthUserImpl oUser = oList.get(i);
				if(aAuth.isSameAuth(oUser)){
					noHave = false;
					break;
				}
			}
			if(noHave){
				sendAuthor.append(StaticVarExtend.UserSplitChar).append(aAuth._getFullNameWithAgent());
			}
		}
		if(sendAuthor.length() > 0){
			newPlanId.append(oldPlanId);
			newPlanId.append(sendAuthor);
			sendAuthor.deleteCharAt(0);
		}
		else{
			msg = pubInfo.getInfo("Jiaqian_Msg0006","指定加签人已存在当前办理人列表中.");
			return true;
		}
		runningdata.setPlanId_ForTrackUser(tUser, newPlanId.toString());
		return false;
	}
	
	/**
	 * 判断节点类型是否支持加签
	 * @return
	 */
	protected boolean nodetypeSupportJiaqian(int nodetype){
		//默认多人办理时支持加签 StaticVarExtend.Node_Multi_Single ==nodetype 
		if( NodeTypeEnum.Node_Order == nodetype 
				|| NodeTypeEnum.Node_Multi == nodetype){
			return true;
		}
		return false;
	}
	
	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		sendTodo();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
	/**
	 * 继承父类发送待办的方法
	 */
	protected void sendTodo(){
		String todoUserids =sendAuthor.toString();
		if(StringUtilExtend.isNull(todoUserids)){
			return;
		}
		String msgSendType = getSendType(getCurFlowNode(), StaticVarExtend.AUTH_AUTHOR, paraBean);//获取发送消息的方式
		DBTodo todo = makeDefaultDBTodo();
		makeSendInfoForNewAuth(todo,todoUserids,StaticVarExtend.AUTH_AUTHOR,StaticVarExtend.Send_Todo,
								msgSendType,getCurTrack(),getCurFlowNode());
	}
}
