package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.api.AgentUtil;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
/**
 * 会签操作实现类
 * 单人处理,多人处理全部暂停当前人的处理,会签完成后继续处理.
 * 目前只有单人处理,多人单一签核,多人处理,多人顺序可以会签
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class ActionHuiQian extends BaseAction implements ICustomAction{
	private String selectUser="";
	private String selectedKey;
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_HUIQIAN);
		setActionname("Huiqian_Msg0001","会签");
		//获取当前节点类型
		int nodetype = getCurNodeType();
		//20181217 liys 从addAuth中移动到此处,避免前台传入null值但是key存在的情况
		doWithSelectUser();
		//获取会签人
		if(!nodetypeSupportHuiqian(nodetype)){
			runningdata.putMsgToConsole("[msg]huiqian operator :not support nodetype.nodetype:"+nodetype);
			result = StaticVarExtend.F_STATUS_Not_Operator_Nodetype;
			msg = pubInfo.getInfo("Huiqian_Msg0002","该节点类型不支持会签操作");
		}else if(StringUtilExtend.isNull(selectUser)){
			runningdata.putMsgToConsole("[msg]huiqian operator need select author.");
			result = StaticVarExtend.F_STATUS_SelectAuthor;
			msg = pubInfo.getInfo("Huiqian_Msg0003","请指定会签人");
		}else {//判断当前节点类型是否允许会签
			runningdata.putMsgToConsole("[msg]huiqian operator start.");
			getCurTrack().setFlowstatus(StaticVarExtend.FlowStatus_Huiqian);
			List<DBWorkAuth> newAuths = addAuth();
			if(newAuths == null){
				runningdata.putMsgToConsole("[msg]huiqian operator need select author.");
				result = StaticVarExtend.F_STATUS_OtherError;
				msg = pubInfo.getInfo("Huiqian_Msg0004","不能会签给办理人和已经是会签的人,请重新选择会签人.");
			}
			else{
				runningdata.setCurAuthToMap(newAuths);
				runningdata.setUpdateTask(true);
				result = StaticVarExtend.F_STATUS_Success;
				msg = pubInfo.getInfo("Huiqian_Msg0005","会签成功");
				executeEventSave();//执行操作完成事件
				runningdata.putMsgToConsole("[msg]huiqian operator end.");
			}
		}	
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		//isUpdateTodo = false;
		return true;
	}
	
	/**
	 * 判断节点类型是否支持会签
	 * @return
	 */
	private boolean nodetypeSupportHuiqian(int nodetype){
		//默认单人办理和多人办理时支持会签
		if(NodeTypeEnum.Node_Single == nodetype 
				|| NodeTypeEnum.Node_Multi_Single == nodetype
				|| NodeTypeEnum.Node_Order == nodetype 
				|| NodeTypeEnum.Node_Multi == nodetype){
			return true;
		}
		return false;
	}
	
	/**
	 * 生成会签人
	 * @return
	 */
	private List<DBWorkAuth> addAuth() {
		runningdata.putMsgToConsole("[msg]huiqian operator get auth start.");
		DBTrack track = getCurTrack();
		int nodenum = track.getNodenum(), version = track.getVersion();
		
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		
		if(StringUtilExtend.isNotNull(selectUser)){
			INodeAuthUser xmluser = getCurFlowNode().getParticipantsUser(StaticVarExtend.AUTH_AUTHOR);
			if(null != xmluser && xmluser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_AgentFlag) != -1){
				//调用代理
				selectUser = AgentUtil.getInstance().getAgentUser(selectUser, getWorkid(), getWork().getFlowid(), getIdentifier());				
			}
			String status = StaticVarExtend.AUTH_HUIQIAN_AUTHOR;//+curAuthname;
			//增加会签人
			List<AuthUserImpl> authors = AuthUserImpl.getAuthUserList(selectUser);
			
			StringBuilder tmpUser = new StringBuilder(1000);
			IRunUser curUser = getCurUser();
			List<DBWorkAuth> allAuths = null;
			if(CollectionUtil.isListNotEmpty(authors)){
			  //当前路径下的所有办理人(主办,协办,会签人,会签提出人,子流程启动者)
			    allAuths =  runningdata.getListAuthLikeAuthorByTrackid(track.getId());
				int i=1;
				for(int k=0,n=authors.size();k<n;k++){
					AuthUserImpl newAuth = authors.get(k);
				    //所有办理人中包含了当前人,所以屏蔽掉对当前人的判断
//					if(newAuth.equalsRunUser(curUser)){//从指定的会签人中去除当前人
//						continue;
//					}
					if(isHaveAuth(newAuth,allAuths)){
					    //已经存在于当前办理人列表中
//					    selectUser = selectUser.replace(newAuth.getFullNameWithAgent(), "");
					    //清空中文名称
					    selectedUserNames.put(selectedKey, "");
					    continue;
					}
					
					newAuths.add(addNewAuth(newAuth,nodenum,version,i++,status));
					tmpUser.append(newAuth._getFullNameWithAgent()).append(StaticVarExtend.UserSplitChar);
				}
			}
			if(newAuths.isEmpty()){
				return null;
			}
			
			List<DBWorkAuth> auths =  getCurAuthList(getCurAuthName(),allAuths);
			DBWorkAuth startAuth =null;
			int nodetype = getCurFlowNode().getNodetype();
			boolean isMultiNode = NodeTypeEnum.Node_Multi_Single == nodetype;
			if(CollectionUtil.isListNotEmpty(auths)){
				for(int i=0,n=auths.size();i<n;i++){
					DBWorkAuth a = auths.get(i);
					boolean isCurUser = a.equalsRunUser(curUser);
					//多人单一签核，将所有主办权限都更改
					if(isMultiNode && StaticVarExtend.AUTH_AUTHOR.equals(a.getStatus())){
						if(isCurUser){
							a.setStatus(StaticVarExtend.AUTH_START_HUIQIAN_AUTHOR);
							newAuths.add(a);
							startAuth = a;
						}
						else{
							a.setStatus(StaticVarExtend.AUTH_CREADER);
							newAuths.add(a);
						}
						continue;
					}
					
					if(isCurUser){
						a.setStatus(StaticVarExtend.AUTH_START_HUIQIAN_AUTHOR);
						newAuths.add(a);
						startAuth = a;
						break;
					}
					
				}
			}
			
			selectUser = tmpUser.toString();
			//记录会签人和提出人
			runningdata.recordHuiQian(startAuth, selectUser);
			
			runningdata.putMsgToConsole("[msg]huiqian operator auth end.");
			
			String username = getUsernameFormSelectedOrFromDB(selectedKey,selectUser);
			memoBuffer.append(pubInfo.getInfo("Huiqian_Msg0006","会签给:|username|")
					.replace("|username|", username));
			
		selectedUsers.put(StaticVarExtend.AUTH_AUTHOR, selectUser);
		}
    	else{
    	    runningdata.putMsgToConsole("[msg]huiqian operator get author is null from selectedMap.");
    	}
		return newAuths;
	}
	
	private List<DBWorkAuth> getCurAuthList(String authName,List<DBWorkAuth> auths){
	    List<DBWorkAuth> allAuths = new ArrayList<DBWorkAuth>();
	    for(int i=0,n=auths.size();i<n;i++){
			DBWorkAuth auth = auths.get(i);
	        if(authName.equals(auth.getStatus())){
	            allAuths.add(auth);
	        }
	    }
	    return allAuths;
	}
	/**
	 * 关键字和选择人员处理
	 */
	private void doWithSelectUser(){
	    selectedKey = getCurNodeid()+StaticVarExtend.MARK_NODE_USER+StaticVarExtend.AUTH_AUTHOR;
        selectUser= selectedUsers.get(selectedKey);
        if(StringUtilExtend.isNull(selectUser)){
            selectedKey = getCurNodeid()+StaticVarExtend.MARK_NODE_USER+StaticVarExtend.AUTH_HUIQIAN_AUTHOR;
            selectUser = selectedUsers.get(selectedKey);
            if(StringUtilExtend.isNull(selectUser)){
                selectedKey = StaticVarExtend.AUTH_AUTHOR;
                selectUser = selectedUsers.get(selectedKey);
                if(StringUtilExtend.isNull(selectUser)){
                    selectedKey = StaticVarExtend.AUTH_HUIQIAN_AUTHOR;
                    selectUser = selectedUsers.get(selectedKey);
                }
            }
        }
	}
	
	/**
	 * 判断给定的人员是否已经在办理人和会签人中间
	 * 判断给定的人员是否为集合类
	 * @return
	 */
	private boolean isHaveAuth(AuthUserImpl newAuth,List<DBWorkAuth> auths){
		for(int i=0,n=auths.size();i<n;i++){
			DBWorkAuth auth = auths.get(i);
	        if(newAuth.getAuthId().equals(StaticVarExtend.NullStr)){
                return true;
            }
            if(auth.isSameAuth(newAuth)){
               return true;
            }
            
        }
	    return false;
	}
	
	/**
	 * 构造一个新的办理人
	 * @return
	 */
	private DBWorkAuth addNewAuth(AuthUserImpl user,int nodenum, int version, int authno,String authname) {
		DBWorkAuth newAuth = user.copyToWorkAuth();
		
		newAuth.setAuthNo(authno);
		newAuth.setNodeid(getCurNodeid());
		newAuth.setOldStatus("");
		newAuth.setStatus(authname);//状态改为会签
		newAuth.setTrackid(getCurTrackid());
		newAuth.setWorkid(getWorkid());
		newAuth.setNodenum(nodenum);
		newAuth.setVersion(version);
		
		return newAuth;
	}
	
	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
	    Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
	    actionForTask(saveMap);
      
        return saveMap;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		sendTodo();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
	/**
	 * 继承父类发送待办的方法
	 */
	protected void sendTodo(){
		if(StringUtilExtend.isNull(selectUser))return;
		DBTodo todo = makeDefaultDBTodo();
		String msgSendType = getSendType(getCurFlowNode(), StaticVarExtend.AUTH_AUTHOR,paraBean);
		makeSendInfoForNewAuthForHuiQian(todo,selectUser,StaticVarExtend.AUTH_AUTHOR,
				StaticVarExtend.AUTH_HUIQIAN_AUTHOR,
				StaticVarExtend.Send_Todo,msgSendType,getCurTrack(),getCurFlowNode());
	}
}
