package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.entity.db.DBChgTodo;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
/**
 * 抢单
 * 针对节点办理权限的抢占处理,需要考虑个人和集合类的情况,同时包含认领功能
 * 在实例打开时判断如果有抢单操作,则需要屏蔽其他操作
 * @author liys  2016-02-18
 *
 */
public class ActionGrab extends BaseAction implements ICustomAction{
	
	public boolean isOneTimeClaim(){
		return true;
	}
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_GRAB);
		paraBean.setActionname(pubInfo.getInfo("Grab_Msg0001","抢单"));
		IRunUser user = getCurUser();
		//获取所有的Author权限
		List<DBWorkAuth> auths = getXAuthList(StaticVarExtend.AUTH_AUTHOR);
		DBWorkAuth curAuth = null;
		for(int i=0,n=auths.size();i<n;i++){
			DBWorkAuth auth = auths.get(i);
			//获取当前人权限
			if(auth.getAuthId().equals(user.getUserid())){
				if(auth.getSubjectionId().equals(user.getSubjectionid())	// 两者相等
				|| auth.getSubjectionId().equals(StaticVarExtend.NullStr)	// 权限中没有	
				|| user.getSubjectionid().equals(StaticVarExtend.NullStr) 	// 当前人中没有
				){
					curAuth = auth;
					break;
				}
			}
		}
		if(curAuth == null){
			for(int i=0,n=auths.size();i<n;i++){
				DBWorkAuth auth = auths.get(i);
				//代理人身份
				if(auth.getAgentId().equals(user.getUserid())){
					curAuth = auth;
					break;
				}
			}
		}
		if(curAuth == null){
			for(int i=0,n=auths.size();i<n;i++){
				DBWorkAuth auth = auths.get(i);
				//认领
				if(auth.getSubjectionId().equals(user.getSubjectionid()) 
				        && auth.getAuthId().equals(StaticVarExtend.NullStr) ){
					curAuth = auth;
					break;
				}
			}
		}
		if(curAuth == null){
			runningdata.setBackMsg(pubInfo.getInfo("Grab_Msg0002","抢单失败!(其他办理人已抢到此单)"));
			runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
			return false;
		}
		
		doGrab(auths,curAuth);
		
		String msg = pubInfo.getInfo("Grab_Msg0003","抢单成功");
		int result = StaticVarExtend.F_STATUS_Success;
		
		memoBuffer.append(msg);
		
		runningdata.putMsgToConsole("[msg]move operator success.");
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	
	private void doGrab(List<DBWorkAuth> auths,DBWorkAuth curAuth){
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		for(int i=0,n=auths.size();i<n;i++){
			DBWorkAuth auth = auths.get(i);
			if(auth.getId().equals(curAuth.getId())){
				//只有在需要认领的情况下,才需要处理.
				if(auth.getAuthId().equals(StaticVarExtend.NullStr)){
					doClaim(newAuths,curAuth);
				}
			}
			else{
				//修改权限为CReader
				auth.setStatus(StaticVarExtend.AUTH_CREADER);
				auth.setOldStatus(curAuth.getStatus());
				newAuths.add(auth);
				//对应的待办删除
				DBChgTodo todo = new DBChgTodo();
				todo._setStatus(StaticVarExtend.AUTH_CREADER);
				todo.setTrackid(auth.getTrackid());
				todo.setNodeid(auth.getNodeid());
				todo.setAuthId(auth.getAuthId());
				todo.setSubjectionId(auth.getSubjectionId());
				todo.setStatus(auth.getStatus());
				todoLst.add(todo);
			}
		}
		//替换planid
		ITrackUserJson tUser = getCurTrack()._getTrackNode().getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
		runningdata.setPlanId_ForTrackUser(tUser, curAuth._getFullNameWithAgent());
		//删除nowid中的old,saveWork的时候忘nowid中追加
		runningdata.setNowId_ForTrackUser(tUser, "");
		
		runningdata.setCurAuthToMap(newAuths);
	}
	
	/**
	 * 认领,并删除其他办理人
	 */
	private void doClaim(List<DBWorkAuth> newAuths,DBWorkAuth curAuth){
		IRunUser user = getCurUser();
		//待办中增加当前userid
		DBChgTodo todo = new DBChgTodo();
		todo._setAuthId(user.getUserid());
		todo.setTrackid(curAuth.getTrackid());
		todo.setNodeid(curAuth.getNodeid());
		todo.setAuthId(curAuth.getAuthId());
		todo.setSubjectionId(curAuth.getSubjectionId());
		todo.setStatus(curAuth.getStatus());
		todoLst.add(todo);
		
		String oldStr = curAuth._getFullNameWithAgent();
		//删除原来没有authid的数据
		DBWorkAuth oldAuth = new DBWorkAuth(); 
		oldAuth.setTrackid(curAuth.getTrackid());
		oldAuth.setNodenum(curAuth.getNodenum());
		oldAuth.setNodeid(curAuth.getNodeid());
		oldAuth.setStatus("");
		oldAuth.setOldStatus(curAuth.getStatus());
		oldAuth.setAuthId(oldStr);
		oldAuth.setSubjectionId("");
		oldAuth.setIsclaim(curAuth.getIsclaim());
		oldAuth.setId(null);
		newAuths.add(oldAuth);
		
		//插入新数据
		curAuth.setAuthId(user.getUserid()); 
		newAuths.add(curAuth);
	}
	
	public void actionAfterSaveToDB() {
		return;
	}

	public Map<String, List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		
		actionBefore(saveMap);
		return saveMap ;
	}

	public Map<String, List<Object>> actionForTask() {
		return null;
	}

	public void cancelTrackAction(String arg0, List<DBWorkAuth> arg1) {
		return;
	}

	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}

	public Map<String, String> getCancelTrackAuthRuleMap() {
		return null;
	}

	

}
