package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseForTask;
import com.horizon.wf.action.base.IActionForStartSubFlow;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBRelationSubflow;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 跳转操作实现类
 * 跳转后如果操作人为主办则变为已办、如果操作人为管理员，则发送待阅,如果有其他办理人变为读者
 * @author liys
 * @version 1.0
 * @since v7.0
 */
public class ActionGoto extends BaseForTask implements ICustomAction,IActionForStartSubFlow {
	public boolean execute(ITaskNode curTaskNode){
		initNextNodePara();//初始化下一节点信息
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_GOTO);
		setActionname("Goto_Msg0001","跳转");
		if(isnewdoc<2){
			result = StaticVarExtend.F_STATUS_OtherError;
			msg = pubInfo.getInfo("Goto_Msg0002","当前流程处于起草状态，无法跳转!");
		}else if(null == nextNodeList || nextNodeList.isEmpty()){
			runningdata.putMsgToConsole("[msg]goto operator need select node!");
			result = StaticVarExtend.F_STATUS_SelectNode;
			msg = pubInfo.getInfo("Goto_Msg0003","请选择跳转节点");
			resultBean.setNextNodes(getGotoNodes());
		}
		else{
			getCurTrack().setEnd(true);//结束当前节点
			curTaskNode.jumpToOtherNode(nextNodeList, selectedUsers);
			INextNode curNode = curTaskNode.getCurNode();
			result = curNode.getInitResult();
			msg = curNode.getBackMsg();
			List<INextNode>  nextNodes = curTaskNode.getGNextNodes();
			if (result == StaticVarExtend.F_STATUS_Success) {
				doWithNextNodeResult(false);
				if(result == StaticVarExtend.F_STATUS_Success){
					msg = pubInfo.getInfo("Goto_Msg0004","跳转成功");
					dowithCurAuth();//跳转成功后处理当前节点人员
					ac.dowithTimer("cancel", getCurNodeType(), runningdata, getIdentifier());//如果当前节点包含定时任务则撤销定时任务
					//执行操作完成事件
					if(executeEventSave()){
//						selectedUsers = ac.makeAgentUser(selectedUsers, runningdata);
						runningdata.setUpdateTask(true);
						
						memoBuffer.append(pubInfo.getInfo("Goto_Msg0005","跳转到节点"));
						for(int i=0,n=nextNodes.size();i<n;i++){
							doMemoFromSelected(nextNodes.get(i));
						}
					}

					runningdata.putMsgToConsole("[msg]goto operator is success!");
				}
			}else{
				runningdata.putMsgToConsole("[msg]goto operator result:"+result+";backmsg:"+msg);
			}
			resultBean.setNextNodes(nextNodes);
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	
	/**
	 * 跳转成功后处理当前人员权限
	 * 将主办改为流程读者权限(StaticVarExtend.AUTH_CREADER)
	 */
	private void dowithCurAuth() {
		List<DBWorkAuth> workAuthList = runningdata
				.getListAuthLikeAuthorByTrackid(getCurTrack().getId());
		if(!(null == workAuthList || workAuthList.isEmpty())){
			for(int i=0,n= workAuthList.size();i<n;i++){
				DBWorkAuth wa = workAuthList.get(i);
				if(wa.equalsRunUser(getCurUser())){
					//当前人员状态改为已办,其余改为读者
					wa.setStatus(StaticVarExtend.AUTH_DONE);
				}else{
					//改变其余办理人权限
					wa.setStatus(StaticVarExtend.AUTH_CREADER);
				}
			}
		}
		runningdata.setCurAuthToMap(workAuthList);
	}
	
	/**
	 * 获取可以跳转的节点
	 * @return
	 */
	private List<INextNode> getGotoNodes(){
		runningdata.putMsgToConsole("[msg]get goto nodes start.");
		List<IFlowNode> nodes = new ArrayList<IFlowNode>();
		List<IFlowNode> allNodes = runningdata.getInstanceDefinition().getFlowinfo().getAllNodes();
		if(CollectionUtil.isListNotEmpty(allNodes)){
			for(int i=0,n=allNodes.size();i<n;i++){
				IFlowNode node = allNodes.get(i);
				int nodetype = node.getNodetype();
				//去掉当前节点,结束节点,自动节点，事件节点，网关节点,开始节点
				if(getCurNodeid().equals(node.getNodeid()) || nodetype == NodeTypeEnum.Node_Merger
						|| !ac.isNormalNode(nodetype) 
				        ){continue;}
				runningdata.putMsgToConsole("[msg]go to node:"+node.getNodeid());
				nodes.add(node);
			}
		}
		runningdata.putMsgToConsole("[msg]get goto nodes end.");
		return runningdata.chgXmlNodeToNextNode(nodes);
	}
	/**
	 * 给task表添加数据
	 */
	public Map<String,List<Object>>  actionForTask() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		actionForTask(saveMap);
		//下一节点任务创建
		for(int i=0,n=runningdata.getNextTrackList().size();i<n;i++){
			DBTrack tTrack = runningdata.getNextTrackList().get(i);
			createTaskObj(null,tTrack,saveMap);
		}
		return saveMap;
	}
	/**
	 * 取消分支时调用
	 */
	public void cancelTrackAction(String arg0, List<DBWorkAuth> arg1) {
		makeSendInfoByCurAuthList(arg1);
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
		if(isNotSaveToDB){
			return;
		}
		actionStartTodoThread();
		//调用父类中的方法处理taskList
		super.actionAfterSaveToDB();
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		if(!StaticFunExtend.getActionExtraData().doWithNextNodesExtraData(this)){
			return null;
		}
		sendTodo();
		actionBefore(saveMap);
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
	/**
	 * 发送待办
	 */
	protected void sendTodo(){
//		DBTodo todo = makeDefaultDBTodo();
		
		//当前操作者为管理员,发送待阅???为啥要发呢
//		String curNodeAuths = getCurUser().getCurNodeAuths();
//		if(curNodeAuths.indexOf(StaticVarExtend.AUTH_AUTHOR) == -1 && curNodeAuths.indexOf(StaticVarExtend.AUTH_MANAGER) != -1){
//			makeSendInfoForNewAuth(todo,getCurUser().getFullName(),StaticVarExtend.AUTH_READER,StaticVarExtend.Send_Read,
//					null,getCurTrack(),getCurXmlNode());
//		}
		
		sendTodoForSelectedUsers();
	}
	/**
	 * 获取子流程启动实例的运行期对象
	 * @return
	 */
	public List<RunningData> getSubRunningdatas(){
		return null;
	}
	/**
	 * 所有已经启动的子流程实例
	 * @return
	 */
	public List<DBRelationSubflow> getSubflowWorks(){
		return null;
	}
}
