package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.track.json.impl.ITrackNodeJson;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 顺签节点内部拿回
 * 隐含操作,打开实例判断操作权限时根据情况对拿回操作的执行类进行重置
 * @author liys
 * @version v7.2.2
 * @since 
 */
public class ActionGetBackForOrder extends ActionGetBack {
	
	/**
	 * 操作调用的方法
	 */
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_GETBACK);
		setActionname("GetBack_Msg0001","拿回");
		if(isGetBack()){
		    msg = pubInfo.getInfo("GetBack_Msg0002", "拿回成功");
		    ITrackNodeJson curTrackNode = getCurTrack()._getTrackNode();
		    IRunUser curUser = getCurUser();
	        //获取当前节点的权限,并变更
	        List<DBWorkAuth> list = runningdata.getXAuthListForCurNode(StaticVarExtend.AUTH_AUTHOR);
	        for(int i=0,n=list.size();i<n;i++){
	        	DBWorkAuth auth = list.get(i);
	            auth.setStatus(StaticVarExtend.AUTH_CREADER);
	            //找到当前办理人位置
				ITrackUserJson tUser = curTrackNode.getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
	            String planid = tUser.getPlanId();
	            List<AuthUserImpl> planLst = AuthUserImpl.getAuthUserList(planid);
	            for(int j=0,m=planLst.size();j<m;j++){
	                AuthUserImpl planAuth = planLst.get(j);
	                if(planAuth.isSameAuth(auth)){
	                    if(j==0){
	                        //这种情况应该在权限判断时已经拦截,程序应该执行ActionGetBack类
	                        result = StaticVarExtend.F_STATUS_OtherError;
	                        msg = pubInfo.getInfo("GetBack_Msg0010","当前节点主办人为第一个办理人");
	                        runningdata.setBackMsg(msg);
	                        runningdata.setResultCode(result);
	                        return true;
	                    }
	                    planAuth = planLst.get(j-1);
	                    //判断上一办理人是否为当前人
	                    if(!planAuth.containsRunUser(curUser)){
	                        result = StaticVarExtend.F_STATUS_OtherError;
                            msg = pubInfo.getInfo("GetBack_Msg0009","当前人员跟上一个办理人不匹配");
                            runningdata.setBackMsg(msg);
                            runningdata.setResultCode(result);
                            return true;
	                    }
	                    //更新xml中的当前办理人
	                    runningdata.setNowId_ForTrackUser(tUser, planAuth._getFullNameWithAgent());
	                }
	            }
	        }
	        List<DBWorkAuth> doneAuths = runningdata.getXAuthListForGet(StaticVarExtend.AUTH_DONE);
            for(int i=0,n=doneAuths.size();i<n;i++){
            	DBWorkAuth dauth = doneAuths.get(i);
                if(dauth.equalsRunUser(curUser)){
                    dauth.setStatus(StaticVarExtend.AUTH_AUTHOR);
                    list.add(dauth);
                    break;
                }
            }
            //删除xml中的最后一个办理人,避免提交时,位置计算错误
			ITrackUserJson dUser = curTrackNode.getTrackUserImpl(StaticVarExtend.AUTH_DONE,StaticVarExtend.AUTH_AUTHOR);
            String planid = dUser.getPlanId();
            List<AuthUserImpl> planLst = AuthUserImpl.getAuthUserList(planid);
            StringBuilder sb = new StringBuilder(1000);
            for(int i=0,n=planLst.size()-1;i<n;i++){
                AuthUserImpl dAuth = planLst.get(i);
                sb.append(StaticVarExtend.UserSplitChar).append(dAuth._getFullNameWithAgent());
            }
            if(sb.length()>0){
                sb.deleteCharAt(0);
            }
            runningdata.setNowId_ForTrackUser(dUser, sb.toString());
            runningdata.setPlanId_ForTrackUser(dUser, sb.toString());
            memoBuffer.append(msg);
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}


	/**
	 * 判断当前节点类型是否允许拿回
	 * @return true:允许拿回
	 */
	protected boolean isNodeGetBack(){
		int nodetype = getCurNodeType();
		if(nodetype == NodeTypeEnum.Node_Order || nodetype == NodeTypeEnum.Node_Progressively){
			return true;
		}
		return false;
	}
	/**
	 * 判断当前节点是否已经办理
	 * @return
	 */
	protected boolean isDone(){
		return false;
	}

	/**
	 * 给task表添加数据
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}

	/**
	 * 重写父类待办发送方法
	 * 给当前办理人发送待阅
	 */
	protected void sendTodo(){

	}	

}
