package com.horizon.wf.action;

import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBChgTodo;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.global.StaticVarExtend;

/**
 * 合并节点上的拿回操作实现类
 * 隐含操作,打开实例判断操作权限时根据情况对拿回操作的执行类进行重置
 * @author liys
 * @version v7.2.2
 * @since 
 */
public class ActionGetBackForMerger extends ActionGetBack {
	private DBTrack backTrack = null;
	
	/**
	 * 操作调用的方法
	 */
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_GETBACK);
		setActionname("GetBack_Msg0001","拿回");
		if(isGetBack()){
			msg = pubInfo.getInfo("GetBack_Msg0002", "拿回成功");
			//删除合并节点中的上一分支,并激活上一分支
			backTrack = runningdata.doPreTrackForMerger(StaticVarExtend.AUTH_AUTHOR);
			if(backTrack == null){
				result = StaticVarExtend.F_STATUS_OtherError;
				msg = pubInfo.getInfo("GetBack_Msg0011", "无法获取当前人办理时对应的路径信息,无法执行拿回");
			}
			//更新当前合并节点的待办为不激活状态
			memoBuffer.append(msg);
			runningdata.setUpdateTask(true);
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	

	/**
	 * 判断当前节点类型是否允许拿回
	 * @return true:允许拿回
	 */
	protected boolean isNodeGetBack(){
		int nodetype = getCurNodeType();
		if(nodetype == NodeTypeEnum.Node_Merger ){
			return true;
		}
		return false;
	}
	
	/**
	 * 重写父类待办发送方法
	 * 给当前办理人发送待阅
	 */
	protected void sendTodo(){
				
		String todoUser = getCurUser().getFullName();
		DBTodo todo = makeDefaultDBTodo();

		IFlowNode node = runningdata.getInstanceDefinition().getFlowinfo().getNodeById(backTrack.getNodeid());
		makeSendInfoForNewAuth(todo,todoUser,StaticVarExtend.AUTH_AUTHOR,StaticVarExtend.Send_Todo,
				null,backTrack,node);
		//合并节点的待办修改为不激活状态
		DBChgTodo chgTodo = new DBChgTodo();
		chgTodo._setIsactive("0");
		chgTodo._setTrackactive("0");
		chgTodo._setWhere_and_trackid_equals(getCurTrackid());
//		chgTodo._getWhereBuff().append(" TRACKID=? ");
//		chgTodo._getWherePara().add(getCurTrackid());
		 //下面的赋值仅仅为了在拆分库表的情况下能找到对应的库表
        chgTodo.setStatus(StaticVarExtend.AUTH_AUTHOR);
		todoLst.add(chgTodo);
	}	
	
	
}
