package com.horizon.wf.action;

import com.horizon.wf.config.AuthEnum;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.global.StaticVarExtend;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 从分支开始节点上的拿回操作实现类(不包含多人异步的分支)
 * **必须是在所有分支都没有办理的情况下才能拿回,任一分支如果办理了,都不可拿回
 * 隐含操作,打开实例判断操作权限时根据情况对拿回操作的执行类进行重置
 * @author liys
 * @version v7.2.2
 * @since 
 */
public class ActionGetBackForBranch extends ActionGetBack {
	private DBTrack backTrack = new DBTrack();
	
	/**
	 * 操作调用的方法
	 */
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_GETBACK);
		setActionname("GetBack_Msg0001","拿回");
		if(isGetBack()){
			//将本来的主办人都设置为读者
			List<DBWorkAuth> curAuth = runningdata
					.getListAuthLikeAuthorByTrackid(getCurTrack().getId());
//			curAuth.addAll(getXAuthList(StaticVarExtend.AUTH_SECOND_AUTHOR));
			for(int i=0,n=curAuth.size();i<n;i++){
				DBWorkAuth a  = curAuth.get(i);
				//更改其余办理人权限
				a.setStatus(StaticVarExtend.AUTH_CREADER);
			}

			//将处理好的人员列表放回底层
			runningdata.setCurAuthToMap(curAuth);
			//取消所有分支,并激活上之前的分支
			int resultBack = runningdata.doPreTrackForBranch(backTrack,StaticVarExtend.AUTH_AUTHOR,AuthEnum.getStatusNo("DoMax"),"103");
			switch(resultBack){
			case 1:
			    result = StaticVarExtend.F_STATUS_OtherError;
			    msg = pubInfo.getInfo("GetBack_Msg0007","有些分支已经办理,无法拿回");
			    break;
			case 2:
			    result = StaticVarExtend.F_STATUS_OtherError;
	            msg = pubInfo.getInfo("GetBack_Msg0008","有些分支状态不是正常状态,不允许拿回");
	            break;
			case 3:
				runningdata.setUpdateTask(true);
			    msg = pubInfo.getInfo("GetBack_Msg0002", "拿回成功");
			    memoBuffer.append(msg);
			}
		}
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}

	/**
	 * 判断当前节点是否已经办理
	 * @return
	 */
	protected boolean isDone(){
		return false;
	}
	
	/**
	 * 取消分支时调用
	 */
	public void cancelTrackAction(String arg0, List<DBWorkAuth> auths) {
	    if(isNotSaveToDB){
            return;
        }
        makeSendInfoByCurAuthList(auths);
	}

	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
	    Map<String,String> map = new HashMap<String,String>();
        if(!isNotSaveToDB){
            map.put(StaticVarExtend.AUTH_AUTHOR, StaticVarExtend.AUTH_CREADER);
            map.put(StaticVarExtend.AUTH_SECOND_AUTHOR, StaticVarExtend.AUTH_CREADER);
            map.put(StaticVarExtend.AUTH_SUBFLOW_AUTHOR, StaticVarExtend.AUTH_CREADER);
            map.put(StaticVarExtend.AUTH_HUIQIAN_AUTHOR,StaticVarExtend.AUTH_CREADER);
            map.put(StaticVarExtend.AUTH_START_HUIQIAN_AUTHOR,StaticVarExtend.AUTH_CREADER);
        }
        return map;
	}

	/**
	 * 重写父类待办发送方法
	 * 给当前办理人发送待阅
	 */
	protected void sendTodo(){
				
		String todoUser = getCurUser().getFullName();
		DBTodo todo = makeDefaultDBTodo();
		
		IFlowNode node = runningdata.getInstanceDefinition().getFlowinfo().getNodeById(backTrack.getNodeid());
		makeSendInfoForNewAuth(todo,todoUser,StaticVarExtend.AUTH_AUTHOR,StaticVarExtend.Send_Todo,
				null,backTrack,node);
	}	
	
	
}
