package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBChgTodo;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVar;
import com.horizon.wf.global.StaticVarExtend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
/**
 * 认领
 * 20150722 增加认领之后是否允许其他人认领的功能
 * @author liys
 *
 */
public class ActionClaim extends BaseAction implements ICustomAction{
	//是否为单次认领,或者是多次认领的最后认领
	public boolean isOneTimeClaim(){
		return true;
	}
	public boolean execute(ITaskNode curTaskNode) {
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_CLAIM);
		paraBean.setActionname(pubInfo.getInfo("Claim_Msg0001","认领"));
		
		IRunUser user = getCurUser();
		if("".equals(user.getAuthObjId())){
			runningdata.setBackMsg(pubInfo.getInfo("Claim_Msg0002","认领失败"));
			runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
			return false;
		}
		
		DBWorkAuth nowAuth = runningdata.getDBWorkAuthById(user.getAuthObjId());
		if(nowAuth == null){
			runningdata.setBackMsg(pubInfo.getInfo("Claim_Msg0002","认领失败"));
			runningdata.setResultCode(StaticVarExtend.F_STATUS_OtherError);
			return false;
		}
		//区分是一次性认领还是允许后续认领,默认一次性认领
		boolean isOnetimeClaim = isOneTimeClaim();
		
		if(isOnetimeClaim){
			oneTimeClaim(nowAuth);
		}
		else{
			if(curTaskNode.getFlowNode().getNodetype() == NodeTypeEnum.Node_Order){
				oneTimeClaim(nowAuth);
			}
			else{
				repeatedlyClaim(nowAuth);
			}
		}
		
		String msg = pubInfo.getInfo("Claim_Msg0003","认领成功");
		int result = StaticVarExtend.F_STATUS_Success;
		memoBuffer.append(msg);
		runningdata.putMsgToConsole("[msg]move operator success.");
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	/**
	 * 一次认领
	 * @param nowAuth
	 */
	private void oneTimeClaim(DBWorkAuth nowAuth){
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		IRunUser user = getCurUser();
		//待办中增加当前userid
		DBChgTodo todo = new DBChgTodo();
		todo._setAuthId(user.getUserid());
		todo.setTrackid(nowAuth.getTrackid());
		todo.setNodeid(nowAuth.getNodeid());
		todo.setAuthId(nowAuth.getAuthId());
		todo.setSubjectionId(nowAuth.getSubjectionId());
		todo.setStatus(nowAuth.getStatus());
		todoLst.add(todo);
		
		String oldStr = nowAuth._getFullNameWithAgent();
		//添加删除原来没有authid的数据
		DBWorkAuth oldAuth = new DBWorkAuth(); 
		oldAuth.setTrackid(nowAuth.getTrackid());
		oldAuth.setNodenum(nowAuth.getNodenum());
		oldAuth.setNodeid(nowAuth.getNodeid());
		oldAuth.setStatus("");
		oldAuth.setOldStatus(nowAuth.getStatus());
		oldAuth.setAuthId(oldStr);
		oldAuth.setSubjectionId("");
		oldAuth.setIsclaim(nowAuth.getIsclaim());
		oldAuth.setId(null);
		newAuths.add(oldAuth);
		
		//插入新数据
		nowAuth.setAuthId(user.getUserid());
		newAuths.add(nowAuth);
		
		//替换planid
		ITrackUserJson tUser = getCurTrack()._getTrackNode().getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
		String planid = tUser.getPlanId();
		String newPlanStr = replaceStr(planid,oldStr,nowAuth._getFullNameWithAgent());
		runningdata.setPlanId_ForTrackUser(tUser, newPlanStr);
		//删除nowid中的old,saveWork的时候忘nowid中追加
		String nowid = tUser.getNowId();
		String newNowStr = replaceStr(nowid,oldStr,"");
		runningdata.setNowId_ForTrackUser(tUser, newNowStr);
		
		runningdata.setCurAuthToMap(newAuths);
	}
	/**
	 * 替换planid字符串中的oldStr为newStr
	 * @param planid
	 * @param oldStr
	 * @param newStr
	 * @return
	 */
	private String replaceStr(String planid,String oldStr,String newStr){
		List<AuthUserImpl> oldAuths = AuthUserImpl.getAuthUserList(planid);
		StringBuilder newAuths = new StringBuilder(1000);
		for(int i=0,n=oldAuths.size();i<n;i++){
			AuthUserImpl old = oldAuths.get(i);
			String auth = old._getFullNameWithAgent();
			if(oldStr.equals(auth) && newStr.length()>0){
				newAuths.append(StaticVar.UserSplitChar).append(newStr);
			}
			else{
				newAuths.append(StaticVar.UserSplitChar).append(auth);
			}
		}
		if(newAuths.length()>0){
			newAuths.deleteCharAt(0);
		}
		return newAuths.toString();
	}
	
	private void repeatedlyClaim(DBWorkAuth nowAuth){
		List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
		IRunUser user = getCurUser();
		//新建一条待办数据
		DBTodo paraTodo = new DBTodo();
		paraTodo.setTrackid(nowAuth.getTrackid());
		paraTodo.setNodeid(nowAuth.getNodeid());
		paraTodo.setAuthId(nowAuth.getAuthId());
		paraTodo.setSubjectionId(nowAuth.getSubjectionId());
		paraTodo.setStatus(nowAuth.getStatus());
		paraTodo._setIdentifier(getIdentifier());
		//获取认领的待办,并给authid赋值
		DBTodo newTodo = paraTodo._getFromDBTodo();
		
		newTodo.setAuthId(user.getUserid());
		
		todoLst.add(newTodo);
		
//		String oldStr = nowAuth.getFullNameWithAgent();
		//新建插入数据
		nowAuth.setAuthId(user.getUserid()); 
		
		newAuths.add(nowAuth);
		
		//增加planid
		ITrackUserJson tUser = getCurTrack()._getTrackNode().getTrackUserImpl(StaticVarExtend.AUTH_AUTHOR);
		String planid = tUser.getPlanId();
		String newPlanStr = planid + StaticVar.UserSplitChar + nowAuth._getFullNameWithAgent();
		runningdata.setPlanId_ForTrackUser(tUser, newPlanStr);
		
		runningdata.setCurAuthToMap(newAuths);
	}
	
	
	
	public void actionAfterSaveToDB() {
		return;
	}

	public Map<String, List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		
		actionBefore(saveMap);
		return saveMap ;
	}

	public Map<String, List<Object>> actionForTask() {
		return null;
	}

	public void cancelTrackAction(String arg0, List<DBWorkAuth> arg1) {
		return;
	}

	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}

	public Map<String, String> getCancelTrackAuthRuleMap() {
		return null;
	}

	

}
