package com.horizon.wf.action;

import com.horizon.db.Access;
import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.entity.db.DBChgTodo;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.tools.DateUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 撤办流程
 * 1)获取所有未结束的路径信息<br/>
 * 1)判断当前路径是否为撤销状态
 * 2)撤销状态则恢复,待办激活状态active由-1变更为trackactive
 * 3)执行撤销,待办激活状态active标记为-1,同时发送一条待阅
 * @author liys
 *
 */
public class ActionCancel extends BaseAction implements ICustomAction {
	private boolean isCancel = false;
	private List<DBTrack> tracklst;
	public boolean execute(ITaskNode curTaskNode) {
		//1.获取所有未结束的路径
		tracklst = runningdata.getAllTrackBeforeEndByWorkid(getWorkid());
		//2.获取路径的状态是否为撤销
		isCancel = checkTrackIsCancel();
		
		if(isCancel){
			restore();
		}else {
			cancel();
		}
		memoBuffer.append(msg);
		runningdata.setBackMsg(msg);
		runningdata.setResultCode(result);
		return true;
	}
	/**
	 * 判断路径是否为撤销状态,只有有一个是,则返回true,否则返回false
	 * @return
	 */
	private boolean checkTrackIsCancel(){
		for(int i=0,n=tracklst.size();i<n;i++){
			DBTrack track = tracklst.get(i);
			if(track.getFlowstatus() == StaticVarExtend.FlowStatus_Cancel){
				return true;
			}
		}
		return false;
	}
	
	private void cancel(){
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_CANCEL);
		setActionname("Cancel_Msg0001","撤办");
		result = StaticVarExtend.F_STATUS_Success;
		msg = pubInfo.getInfo("Cancel_Msg0002","撤办流程成功");
		
		//修改track状态
		IFlowInfo flowInfo = runningdata.getInstanceDefinition().getFlowinfo();
		for(int i=0,n=tracklst.size();i<n;i++){
			DBTrack track = tracklst.get(i);
			runningdata.setOldStatus(track.getId(), StaticVarExtend.FlowStatus_Cancel,track.getFlowstatus());
			track.setFlowstatus(StaticVarExtend.FlowStatus_Cancel);
			if(getCurTrack().getId().equals(track.getId())){
				getCurTrack().setFlowstatus(track.getFlowstatus());
			}
			else{
				track.setFunname(StaticVarExtend.OPERATOR_FUNNAME_CANCEL);
			}
			String nodeid = track.getNodeid();
			IFlowNode xmlNode = flowInfo.getNodeById(nodeid);
			ac.dowithTimer("cancel", xmlNode.getNodetype(),nodeid,track.getId(), runningdata, getIdentifier());
		}
		//获取当前实例的所有办理人
		List<DBWorkAuth> auths = runningdata.getListAuthLikeAuthorByWorkid(getWorkid());
		List<DBWorkAuth> dAuths = new ArrayList<DBWorkAuth>();
		for(int i=0,n=auths.size();i<n;i++){
			DBWorkAuth auth = auths.get(i);
			auth.setId("LIYS");//id不为空时不进行拆分,会重新赋值
			auth.setStatus(StaticVarExtend.AUTH_READER);
			auth.setOldStatus("");

			//KFPT-776
			//如果当前办理人已经有待阅数据,则在待办已办拆表的时候会出现相同的查询条件被执行两次
			//所以在撤办时先删除掉原来的待阅数据(因为不确定是否有待阅,所以先执行删除)
			DBWorkAuth dAuth = new DBWorkAuth();
			dAuth.setId("LIYS");
			dAuth.setStatus("");
			dAuth.setOldStatus(StaticVarExtend.AUTH_READER);
			dAuth.setAuthId(auth.getAuthId());
			dAuth.setAgentId(auth.getAgentId());
			dAuth.setSubjectionId(auth.getSubjectionId());
			dAuth.setTrackid(auth.getTrackid());
			dAuth.setNodeid(auth.getNodeid());
			dAuth.setNodenum(auth.getNodenum());
			dAuth.setIsclaim(auth.getIsclaim());
			dAuths.add(dAuth);
		}
		//必须放在前面,避免删除SQL在插入SQL后面的情况发生
		auths.addAll(0,dAuths);
		runningdata.setCurAuthToMap(auths);
		
		//待办数据处理
		List<DBTodo> list = getListTodo();
		if(!(list == null || list.isEmpty())){
			for(int i=0,n=list.size();i<n;i++){
				DBTodo a = list.get(i);
				DBChgTodo todo = new DBChgTodo();
				todo.setTrackid(a.getTrackid());
				todo.setNodeid(a.getNodeid());
				todo.setStatus(a.getStatus());
				todo.setAuthId(a.getAuthId());
				todo.setSubjectionId(a.getSubjectionId());
				
				todo._setIsactive("-1");
				todo._setDotime(DateUtil.getNow());
				todoLst.add(todo);
				
				//KFPT-776
				//如果当前办理人已经有待阅数据,则在待办已办拆表的时候会出现相同的查询条件被执行两次
				//所以在发送撤办通知时先删除掉原来的待阅数据
				DBChgTodo dTodo = new DBChgTodo();
				dTodo.setTrackid(a.getTrackid());
				dTodo.setNodeid(a.getNodeid());
				dTodo.setStatus(StaticVarExtend.AUTH_READER);
				dTodo.setAuthId(a.getAuthId());
				dTodo.setSubjectionId(a.getSubjectionId());
				todoLst.add(dTodo);
				
				//给办理人发个待阅通知
				a.setTitle(pubInfo.getInfo("Cancel_Msg0003","[撤办通知]")+a.getTitle());
				a.setStatus(StaticVarExtend.AUTH_READER);
				a.setId(Access.getUUID());
				todoLst.add(a);
			}
		}
	}
	
	
	/**
	 * 恢复撤办的处理
	 */
	private void restore(){
		paraBean.setActionname(pubInfo.getInfo("Action_Msg0010","恢复"));
		runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_RESTORE);
		result = StaticVarExtend.F_STATUS_Success;
		msg = pubInfo.getInfo("Cancel_Msg0004","恢复流程成功");
		//修改track状态
		IFlowInfo flowInfo = runningdata.getInstanceDefinition().getFlowinfo();
		for(int i=0,n=tracklst.size();i<n;i++){
			DBTrack track = tracklst.get(i);
			track.setFlowstatus(runningdata.getTrackOldStatusForCancelRestore(track.getId(),track.getFlowstatus()));
			if(getCurTrack().getId().equals(track.getId())){
				getCurTrack().setFlowstatus(track.getFlowstatus());
			}
			else{
				track.setFunname(StaticVarExtend.OPERATOR_FUNNAME_RESTORE);
			}
			String nodeid = track.getNodeid();
			IFlowNode xmlNode = flowInfo.getNodeById(nodeid);
			ac.dowithTimer("restore", xmlNode.getNodetype(),nodeid,track.getId(), runningdata, getIdentifier());
		}
		runningdata.setCurAuthToMap(null);
//		待办的恢复在restoreTodo中,放在actionBeforeSaveToDB中执行
	}
	
	private void restoreTodo(Map<String, List<Object>> saveMap){
		//修改待办状态
		DBTodo.updateTodoForCancel(saveMap,runningdata.getResultJson(),getWorkid());
	}
	/**
	 * 用于操作完成时,更新所有路径信息时获取所有需要更新的路径对象
	 * 默认为null,由后台自动去库表中获取,
	 * 但在撤办/结束/暂停操作中由于需要对所有路径进行处理,所以此处需要返回处理后的路径列表信息
	 * @return
	 */
	public List<DBTrack> getAllOldTrack(){
		return tracklst;
	}
	
	/**
	 * 获取实例下所有办理人的工作列表
	 * @return
	 */
	private List<DBTodo> getListTodo(){
		String workid = getWorkid();
		List<DBTodo> list = DBTodo
				.getTodoListByWorkid(runningdata.getResultJson(),workid, getIdentifier());
		return list;
	}
	/**
	 * 给task表添加数据，用于超期判断等
	 */
	public Map<String,List<Object>>  actionForTask() {
		return null;
	}
	/**
	 * 取消分支时调用,在需要调用的操作中重写该类
	 * @param trackids 要取消的分支id，多个用“；”隔开
	 */
	public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
		return;
	}
	/**
	 * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
	 * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
	 * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
	 * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
	 * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
	 */
	public Map<String,String> getCancelTrackAuthRuleMap(){
		return null;
	}
	/**
	 * 保存之后的接口方法.例如:消息数据的更新
	 */
	public void actionAfterSaveToDB() {
	}
	/**
	 * 保存数据之前的接口方法.例如:消息数据的处理
	 * key=sql,value=parameter
	 */
	public Map<String,List<Object>> actionBeforeSaveToDB() {
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		if(isCancel){
			restoreTodo(saveMap);
		}
		actionBefore(saveMap);
		
		return saveMap ;
	}
	/**
	 * 当前节点权限处理(由操作再次干预参与者的接口)<br>
	 * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表
	 * 对应的消息是否需要处理,可以在这个方法中写
	 */
	public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
		if(CollectionUtil.isListNotEmpty(auths)){
			makeSendInfoByCurAuthList(auths);			
		}
		return true;
	}
	
	
}
