package com.horizon.wf.action;

import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.entity.db.DBChgTodo;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 协办操作实现类
 * 
 * @author lis
 * @version 1.0
 * @since v8.1
 */
public class ActionAddSecondAuthor extends BaseAction implements ICustomAction {
    private String selectSecondAuthor = "";
    private String selectedKey;

    public boolean execute(ITaskNode curTaskNode) {
        runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_ADD_SECONDAUTHOR);
        setActionname("AddSecondAuthor_Msg0001", "协办");
        if (isnewdoc < 2) {
            result = StaticVarExtend.F_STATUS_OtherError;
            msg = pubInfo.getInfo("AddSecondAuthor_Msg0002", "当前流程处于起草状态，无法协办");
        } 
        else if (CollectionUtil.isMapEmpty(selectedUsers)) {
            runningdata.putMsgToConsole("[msg]addsecondauthor operator need select author.");
            result = StaticVarExtend.F_STATUS_SelectAuthor;
            msg = pubInfo.getInfo("AddSecondAuthor_Msg0003", "请指定协办");
        } 
        else {
            String preFix =  getCurNodeid() + StaticVarExtend.MARK_NODE_USER ;
            selectedKey = preFix +  StaticVarExtend.AUTH_SECOND_AUTHOR;
            selectSecondAuthor = selectedUsers.get(selectedKey );
            if (StringUtilExtend.isNull(selectSecondAuthor)) {
                selectedKey = StaticVarExtend.AUTH_AUTHOR;
                selectSecondAuthor = selectedUsers.get(selectedKey);
            }
            if (StringUtilExtend.isNull(selectSecondAuthor)) {
                selectedKey = preFix +  StaticVarExtend.AUTH_AUTHOR;
                selectSecondAuthor = selectedUsers.get(selectedKey);
            }

            if (StringUtilExtend.isNotNull(selectSecondAuthor)) {
                runningdata.putMsgToConsole("[msg]addsecondauthor operator author is :" + selectSecondAuthor);
                List<DBWorkAuth> newAuths = makeAuth(selectSecondAuthor, StaticVarExtend.AUTH_SECOND_AUTHOR);// 添加协办,权限为协办，不可更改
                runningdata.setCurAuthToMap(newAuths);
                result = StaticVarExtend.F_STATUS_Success;
                msg = pubInfo.getInfo("AddSecondAuthor_Msg0004", "添加协办成功");

                String username = getUsernameFormSelectedOrFromDB(selectedKey, selectSecondAuthor);
                memoBuffer.append(pubInfo.getInfo("AddSecondAuthor_Msg0005", "添加协办:|username|").replace("|username|",
                        username));

                executeEventSave();// 执行操作完成事件
                runningdata.putMsgToConsole("[msg]addsecondauthor operator success.");
            } 
            else {
                runningdata.putMsgToConsole("[msg]addsecondauthor operator need select author.");
                result = StaticVarExtend.F_STATUS_SelectAuthor;
                msg = pubInfo.getInfo("AddSecondAuthor_Msg0003", "请指定协办");
            }
        }
        runningdata.setBackMsg(msg);
        runningdata.setResultCode(result);
        return true;
    }

    /**
     * 生成读者，并且添加到auths
     * @param selectedAuthor    选定的读者id
     * @param authname          权限名称
     * @return 权限列表
     */
    private List<DBWorkAuth> makeAuth(String selectedAuthor, String authname) {
        List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
        runningdata.putMsgToConsole("[msg]addreader operator make reader auth start.");
        String nodeid = getCurNodeid();
        String trackid = getCurTrackid();
        String workid = getWorkid();
        int nodenum = getCurTrack().getNodenum();

        List<AuthUserImpl> selectSecondAuthorLst = AuthUserImpl.getAuthUserList(selectedAuthor);
        List<DBWorkAuth> rdyAuthor = runningdata.getAllAuthListByStatus(StaticVarExtend.AUTH_SECOND_AUTHOR);
        for (AuthUserImpl newAuth : selectSecondAuthorLst) {
            boolean noHave = true;
            for (DBWorkAuth oldAuth : rdyAuthor) {
                if (newAuth.isSameAuth(oldAuth)) {
                    noHave = false;
                    break;
                }
            }
            if (noHave) {
                DBWorkAuth auth = newAuth.copyToWorkAuth();
                auth.setNodeid(nodeid);
                auth.setStatus(authname);
                auth.setTrackid(trackid);
                auth.setWorkid(workid);
                auth.setNodenum(nodenum);
                newAuths.add(auth);
            }


        }
        //重新获取需要增加待阅的信息
        StringBuilder sb = new StringBuilder(1000);
        for(int i=0,n=newAuths.size();i<n;i++){
        	DBWorkAuth auth = newAuths.get(i);
            sb.append(StaticVarExtend.UserSplitChar).append(auth._getFullNameNoAgent());
        }
        if(sb.length()>0){
            sb.deleteCharAt(0);
        }
        selectSecondAuthor = sb.toString();
        return newAuths;
    }

    /**
     * 给task表添加数据，用于超期判断等
     */
    public Map<String, List<Object>> actionForTask() {
        return null;
    }

    /**
     * 取消分支时调用,在需要调用的操作中重写该类
     * 
     * @param trackids
     *            要取消的分支id，多个用“；”隔开
     * @param auths 权限列表
     */
    public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
        return;
    }

    /**
     * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
     * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
     * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
     * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
     * 
     * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
     */
    public Map<String, String> getCancelTrackAuthRuleMap() {
        return null;
    }

    /**
     * 保存之后的接口方法.例如:消息数据的更新
     */
    public void actionAfterSaveToDB() {
        if (isNotSaveToDB) {
            return;
        }
        actionStartTodoThread();
    }

    /**
     * 保存数据之前的接口方法.例如:消息数据的处理 key=sql,value=parameter
     */
    public Map<String, List<Object>> actionBeforeSaveToDB() {
        Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
        sendTodo();
        actionBefore(saveMap);
        return saveMap;
    }

    /**
     * 当前节点权限处理(由操作再次干预参与者的接口)<br>
     * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表 对应的消息是否需要处理,可以在这个方法中写
     */
    public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
        if (CollectionUtil.isListNotEmpty(auths)) {
            makeSendInfoByCurAuthList(auths);
        }
        return true;
    }

    /**
     * 继承父类发送待办的方法
     */
    protected void sendTodo() {
        String msgSendType = paraBean.getMsgSendFlagMap().get(StaticVarExtend.AUTH_AUTHOR); // 获取发送消息的方式
        if (StringUtilExtend.isNull(msgSendType)) {
            msgSendType = getSendType(getCurFlowNode(), StaticVarExtend.AUTH_AUTHOR, paraBean);
        }
        if("".equals(selectSecondAuthor)){
            return;
        }
        DBTodo todo = makeDefaultDBTodo();
        makeSendInfoForNewAuth(todo, selectSecondAuthor, StaticVarExtend.AUTH_SECOND_AUTHOR, StaticVarExtend.Send_Todo, msgSendType,
                getCurTrack(), getCurFlowNode());
    }
}
