package com.horizon.wf.action;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.db.Access;
import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.work.ICustomAction;
import com.horizon.wf.entity.db.DBChgTodo;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.tools.StringUtil;

/**
 * 添加读者操作实现类
 * 
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class ActionAddReader extends BaseAction implements ICustomAction {
    private String selectReader = "";
    private String selectedKey;

    public boolean execute(ITaskNode curTaskNode) {
        runningdata.setFunname(StaticVarExtend.OPERATOR_FUNNAME_ADD_READER);
        setActionname("AddReader_Msg0001", "阅知");
        if (isnewdoc < 2) {
            result = StaticVarExtend.F_STATUS_OtherError;
            msg = pubInfo.getInfo("AddReader_Msg0002", "当前流程处于起草状态，无法阅知");
        } 
        else if (CollectionUtil.isMapEmpty(selectedUsers)) {
            runningdata.putMsgToConsole("[msg]addreader operator need select reader.");
            result = StaticVarExtend.F_STATUS_SelectAuthor;
            msg = pubInfo.getInfo("AddReader_Msg0003", "请指定读者");
        } 
        else {
            selectedKey =getCurNodeid() + StaticVarExtend.MARK_NODE_USER +  StaticVarExtend.AUTH_READER;
            selectReader = selectedUsers.get(selectedKey);
            if (StringUtilExtend.isNull(selectReader)) {
                selectedKey = StaticVarExtend.AUTH_READER;
                selectReader = selectedUsers.get(selectedKey);
            }
            if (StringUtilExtend.isNotNull(selectReader)) {
                runningdata.putMsgToConsole("[msg]addreader operator reader is :" + selectReader);
                List<DBWorkAuth> newAuths = makeAuth(selectReader, StaticVarExtend.AUTH_READER);// 添加读者,权限为读者，不可更改
                if(null!=newAuths && !newAuths.isEmpty()){
                    runningdata.setCurAuthToMap(newAuths);
                }
                result = StaticVarExtend.F_STATUS_Success;
                msg = pubInfo.getInfo("AddReader_Msg0004", "添加读者成功");

                String username = getUsernameFormSelectedOrFromDB(selectedKey, selectReader);
                memoBuffer.append(pubInfo.getInfo("AddReader_Msg0005", "添加读者:|username|").replace("|username|",
                        username));

                executeEventSave();// 执行操作完成事件
                runningdata.putMsgToConsole("[msg]addreader operator success.");
            } 
            else {
                runningdata.putMsgToConsole("[msg]addreader operator need select reader.");
                result = StaticVarExtend.F_STATUS_SelectAuthor;
                msg = pubInfo.getInfo("AddReader_Msg0003", "请指定读者");
            }
        }
        runningdata.setBackMsg(msg);
        runningdata.setResultCode(result);
        return true;
    }

    /**
     * 生成读者，并且添加到auths
     * @param selectedReader    选定的读者id
     * @param authname          权限名称
     * @return 权限列表
     */
    private List<DBWorkAuth> makeAuth(String selectedReader, String authname) {
        List<DBWorkAuth> newAuths = new ArrayList<DBWorkAuth>();
        runningdata.putMsgToConsole("[msg]addreader operator make reader auth start.");
        String nodeid = getCurNodeid();
        String trackid = getCurTrackid();
        String workid = getWorkid();
        int nodenum = getCurTrack().getNodenum();

        List<AuthUserImpl> selectReaderLst = AuthUserImpl.getAuthUserList(selectedReader);
        List<DBWorkAuth> rdyReader = runningdata.getAllAuthListByStatus(StaticVarExtend.AUTH_READER);
        // rdyReader.addAll(getXAuthList(StaticVarExtend.AUTH_CREADER));
        for (AuthUserImpl newAuth : selectReaderLst) {
            boolean noHave = true;
            for (DBWorkAuth oldAuth : rdyReader) {
                if (newAuth.isSameAuth(oldAuth)) {
                    noHave = false;
                    break;
                }
            }
            if (noHave) {
                DBWorkAuth auth = newAuth.copyToWorkAuth();
                auth.setNodeid(nodeid);
                auth.setStatus(authname);
                auth.setTrackid(trackid);
                auth.setWorkid(workid);
                auth.setNodenum(nodenum);
                newAuths.add(auth);
            }

            // 删除集合类的已阅
            if(newAuth.getAuthId().equals(StaticVarExtend.NullStr)){
                DBChgTodo tTodo = new DBChgTodo();

                tTodo._setWhere_and_status_equals(StaticVarExtend.AUTH_READED);
                tTodo._setWhere_and_subjectionId_equals(newAuth.getSubjectionId());
                tTodo._setWhere_and_workid_equals(workid);

//                tTodo._getWhereBuff().append(" SUBJECTION_ID=?  AND STATUS=? AND WORKID=?");
//                tTodo._getWherePara().add(newAuth.getSubjectionId());
//                tTodo._getWherePara().add(StaticVarExtend.AUTH_READED);
//                tTodo._getWherePara().add(workid);
                
                //下面的赋值仅仅为了在拆分库表的情况下能找到对应的库表
                tTodo.setStatus(StaticVarExtend.AUTH_READED);
                tTodo.setId(Access.getUUID());
                todoLst.add(tTodo);
                
                //删除对应的权限
                DBWorkAuth auth = new DBWorkAuth();
                auth.setSubjectionId(newAuth.getSubjectionId());
                auth.setWorkid(workid);
                auth.setOldStatus(StaticVarExtend.AUTH_READED);
                
                runningdata.delReadedAuth(auth);
            }
        }
        //重新获取需要增加待阅的信息
        StringBuilder sb = new StringBuilder(1000);
        for(int i=0,n=newAuths.size();i<n;i++){
        	DBWorkAuth auth = newAuths.get(i);
            sb.append(StaticVarExtend.UserSplitChar).append(auth._getFullNameNoAgent());
        }
        if(sb.length()>0){
            sb.deleteCharAt(0);
        }
        if(StringUtil.hasValue(sb.toString())){
            selectReader = sb.toString();
            return newAuths;
        }

        return newAuths;
    }

    /**
     * 给task表添加数据，用于超期判断等
     */
    public Map<String, List<Object>> actionForTask() {
        return null;
    }

    /**
     * 取消分支时调用,在需要调用的操作中重写该类
     * 
     * @param trackids
     *            要取消的分支id，多个用“；”隔开
     * @param auths 权限列表
     */
    public void cancelTrackAction(String trackids, List<DBWorkAuth> auths) {
        return;
    }

    /**
     * 当取消某个路径的激活状态时,对应的权限变化规则设定<br>
     * (比如把待办的状态改为只读,或者是删除,或者忽略)<br>
     * 如果不指定,则忽略权限变更(比如Reader不需要处理)<br>
     * 主要用于合并节点提交时,如果有其他分支未到达时,对未到达的分支的参与者进行处理<br>
     * 
     * @return key=修改前的权限名称(比如:办理人Author),value=修改后的权限名称(比如:只读权限CReader)
     */
    public Map<String, String> getCancelTrackAuthRuleMap() {
        return null;
    }

    /**
     * 保存之后的接口方法.例如:消息数据的更新
     */
    public void actionAfterSaveToDB() {
        if (isNotSaveToDB) {
            return;
        }
        actionStartTodoThread();
    }

    /**
     * 保存数据之前的接口方法.例如:消息数据的处理 key=sql,value=parameter
     */
    public Map<String, List<Object>> actionBeforeSaveToDB() {
        Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
        sendTodo();
        actionBefore(saveMap);
        return saveMap;
    }

    /**
     * 当前节点权限处理(由操作再次干预参与者的接口)<br>
     * auths列表中为系统节点默认处理完毕后的当前节点的参与者列表 对应的消息是否需要处理,可以在这个方法中写
     */
    public boolean chgCurNodeAuth(List<DBWorkAuth> auths) {
        if (CollectionUtil.isListNotEmpty(auths)) {
            makeSendInfoByCurAuthList(auths);
        }
        return true;
    }

    /**
     * 继承父类发送待办的方法
     */
    protected void sendTodo() {
        String msgSendType = paraBean.getMsgSendFlagMap().get(StaticVarExtend.AUTH_AUTHOR); // 获取发送消息的方式
        if (StringUtilExtend.isNull(msgSendType)) {
            msgSendType = getSendType(getCurFlowNode(), StaticVarExtend.AUTH_READER, paraBean);
        }
        if("".equals(selectReader)){
            return;
        }
        DBTodo todo = makeDefaultDBTodo();
        makeSendInfoForNewAuth(todo, selectReader, StaticVarExtend.AUTH_READER, StaticVarExtend.Send_Todo, msgSendType,
                getCurTrack(), getCurFlowNode());
    }
}
