package com.horizon.wf;

import com.horizon.wf.core.factory.InterfaceFactory;

public class WorkflowFactory {
	private static IWorkflowOperator operator;
	private static IWorkflowManager manager;
	private WorkflowFactory(){}
	/**
	 * 获得流程操作的接口类
	 * 
	 * @return
	 */
	public static IWorkflowOperator getWorkflowOperator() {
		if (operator == null) {
			String operatorClassName = "com.horizon.wf.api.WorkflowOperator";// bundle.getString("operatorClass");
			operator = InterfaceFactory.getNewInterface(operatorClassName);
		}
		return operator;
	}

	/**
	 * @deprecated
	 * @return
	 */
	public static IWorkflowOperator getWorkFlowOperator() {
		return getWorkflowOperator();
	}

	/**
	 * 获得流程管理的接口类
	 * 
	 * @return
	 */
	public static IWorkflowManager getWorkflowManager() {
		if (manager == null) {
			String managerClassName = "com.horizon.wf.api.WorkflowManager";// bundle.getString("managerClass");
			manager = InterfaceFactory.getNewInterface(managerClassName);
		}
		return manager;
	}

}
