package com.horizon.wf;

import java.util.List;

import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.entity.db.DBLog;

/**
 * 流程操作接口
 * 
 * @author liangjw
 * @version 1.0
 * @since horizon-workflow-pub v7.2
 *
 */
public interface IWorkflowOperator {
	/**
	 * 创建流程实例
	 * 
	 * @param workParaBean
	 *            创建实例所需参数对象
	 * @return 实例相关数据
	 */
	public IWorkResult create(WorkParaBean workParaBean);
	/**
	 * 批量创建实例
	 * @param workParaBeans 操作实例所需参数对象集合
	 * @return 
	 */
	public boolean createTransactionalConsistency(List<WorkParaBean> workParaBeans);
	/**
	 * 关闭实例
	 * 
	 * @param workid
	 *            实例id
	 * @param trackid
	 *            路径id
	 * @param userid
	 *            用户id
	 */
	public void close(String workid, String trackid, String userid);
	public void close(String workid, String trackid, String userid,String tenantid);
	/**
	 * 打开流程实例(执行打开事件)
	 * API正常调用时使用
	 * @param workParaBean
	 *            打开实例所需参数对象
	 * @return 实例相关数据
	 */
	public IWorkResult open(WorkParaBean workParaBean);
	/**
	 * 打开流程实例(不执行打开事件)
	 * 用于异常执行时打开实例
	 * @param workParaBean
	 *            打开实例所需参数对象
	 * @param isExeEvent
	 *            是否执行打开事件
	 * @return 实例相关数据
	 */
	public IWorkResult openNotExeOpenEvent(WorkParaBean workParaBean);

	/**
	 * 操作流程实例
	 * 
	 * @param workParaBean
	 *            操作实例所需参数对象
	 * @return 实例相关数据
	 */
	public IWorkResult operator(WorkParaBean workParaBean);

	/**
	 * 批量操作（同一事物）
	 * 
	 * @param workParaBeans
	 *            操作实例所需参数对象集合
	 * @return 操作是否成功
	 */
	public boolean operatorsTransactionalConsistency(
			List<WorkParaBean> workParaBeans);

	/**
	 * 批量操作（不在同一事物）
	 * 
	 * @param workParaBeans
	 *            操作实例所需参数对象集合
	 * @return 操作是否成功
	 */
	public List<IWorkResult> operators(List<WorkParaBean> workParaBeans);

	/**
	 * 获取历史记录
	 * 
	 * @param workid
	 *            实例id
	 * @param identifier
	 *            数据源标识符
	 * @return 实例日志
	 */
	public List<DBLog> getHistory(String workid, String identifier);
}
