package com.horizon.wf;

import java.util.List;
import java.util.Map;

import com.horizon.wf.api.bean.TodoPara;
import com.horizon.wf.entity.db.DBHandover;
import com.horizon.wf.entity.db.DBTask;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBWork;

/**
 * 流程管理接口
 * 
 * @author liangjw
 * @version 1.0
 * @since horizon-workflow-pub v7.2
 *
 */
public interface IWorkflowManager {

	/**
	 * 工作移交(此方法只做移交标记,并不实际修改权限,实际权限更改在接收人接收后执行)
	 * 
	 * @param list
	 *            需要进行移交的工作列表 key = workid 实例id key = trackid 路径id key =
	 *            olduserid 转移人员id key = oldusername 转移人员名称 key = newuserid
	 *            接收人员id key = newusername 接收人员名称
	 * @param preservePermissions 
	 *            是否保留权限false=不保留,true=保留权限
	 * @param tenantid
	 *            租户id
	 * @return boolean 移交是否成功
	 */
	public boolean handoverWork(List<? extends Map<String, String>> list,
			boolean preservePermissions, String tenantid);

	/**
	 * 工作移交(此方法只做移交标记,并不实际修改权限,实际权限更改在接收人接收后执行)
	 * 
	 * @param list
	 *            需要进行移交的工作列表 key = workid 实例id key = trackid 路径id key =
	 *            olduserid 转移人员id key = oldusername 转移人员名称 key = newuserid
	 *            接收人员id key = newusername 接收人员名称
	 * @param preservePermissions
	 *            是否保留权限false=不保留,true=保留权限
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据源标识
	 * @return boolean 移交是否成功
	 */
	public boolean handoverWork(List<? extends Map<String, String>> list,
			boolean preservePermissions, String tenantid, String identifier);

	/**
	 * 接收工作移交
	 * 
	 * @param list
	 *            DBHandover列表
	 * @param tenantid
	 *            租户id
	 * @return
	 */
	public Map<DBHandover, String> receiveHandoverWork(List<DBHandover> list,
			String tenantid);

	/**
	 * 接收工作移交
	 * 
	 * @param list
	 *            DBHandover列表
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据源标识
	 * @return
	 */
	public Map<DBHandover, String> receiveHandoverWork(List<DBHandover> list,
			String tenantid, String identifier);

	/**
	 * 激活流程
	 * 
	 * @param workid
	 *            实例id
	 * @param trackid
	 *            路径id
	 * @param interfaceClass
	 *            激活时要执行的类
	 * @param tenantid
	 *            租户id
	 * @return 激活是否成功
	 * @throws Exception
	 */
//	public boolean activeTrack(String workid, String trackid,
//			String interfaceClass, String tenantid) throws Exception;

	/**
	 * 激活流程
	 * 
	 * @param workid
	 *            实例id
	 * @param trackid
	 *            路径id
	 * @param interfaceClass
	 *            激活时要执行的类
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据库标识
	 * @return 激活是否成功
	 * @throws Exception
	 */
	public boolean activeTrack(String workid, String trackid,String actionname,
			String interfaceClass, String tenantid, String identifier)
			throws Exception;

	/**
	 * 恢复实例数据
	 * 
	 * @param workid
	 *            实例id
	 * @param version
	 *            版本号
	 * @param tenantid
	 *            租户id
	 * @return 恢复实例数据是否成功
	 */
	public boolean replaceWork(String workid, int version, String tenantid);

	/**
	 * 恢复实例数据
	 * 
	 * @param workid
	 *            实例id
	 * @param version
	 *           版本号
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据库标识
	 * @return 恢复实例数据是否成功
	 */
	public boolean replaceWork(String workid, int version, String tenantid,
			String identifier);

	/**
	 * 获取实例存在的版本列表
	 * @param workid
	 * @param tenantid
	 * @param identifier
	 * @return
	 */
	public List<Integer> getInstanceVers(String workid,String tenantid,String identifier);
	public List<Integer> getInstanceVers(String workid,String tenantid);
	/**
	 * 获取当前实例的最大版本号
	 * 
	 * @param workid
	 *            实例id
	 * @param tenantid
	 *            租户id
	 * @return 当前实例的最大版本号
	 */
	public int getWorkMaxVersion(String workid, String tenantid);

	/**
	 * 获取当前实例的最大版本号
	 * 
	 * @param workid
	 *            实例id
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据库标识
	 * @return 当前实例的最大版本号
	 */
	public int getWorkMaxVersion(String workid, String tenantid,
			String identifier);

	/**
	 * 暂停指定workid的流程实例
	 * 
	 * @param workid
	 *            实例id
	 * @param trackid
	 *            路径id
	 * @param tenantid
	 *            租户id
	 * @return 暂停流程实例是否成功
	 */
	public boolean pauseWork(String workid, String trackid, String tenantid);

	/**
	 * 暂停指定workid的流程实例
	 * 
	 * @param workid
	 *            实例id
	 * @param trackid
	 *            路径id
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据源标识
	 * @return 暂停流程实例是否成功
	 */
	public boolean pauseWork(String workid, String trackid, String tenantid,
			String identifier);

	/**
	 * 批量暂停流程实例
	 * 
	 * @param workids
	 *            实例id
	 * @param tenantid
	 *            租户id
	 * @return 暂停流程实例是否成功
	 */
	public String pauseWork(String[] workids, String[] trackids,
			String tenantid);

	/**
	 * 批量暂停流程实例
	 * 
	 * @param workids
	 *            实例id
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据源标识
	 * @return 暂停流程实例是否成功
	 */
	public String pauseWork(String[] workids, String[] trackids,
			String tenantid, String identifier);

	/**
	 * 结束实例
	 * 
	 * @param workid
	 *            实例id
	 * @param trackid
	 *            路径id
	 * @param tenantid
	 *            租户id
	 * @return 结束实例是否成功
	 */
	public boolean stopWork(String workid, String trackid, String tenantid);

	/**
	 * 结束实例
	 * 
	 * @param workid
	 *            实例id
	 * @param trackid
	 *            路径id
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据库标识
	 * @return 结束实例是否成功
	 */
	public boolean stopWork(String workid, String trackid, String tenantid,
			String identifier);

	/**
	 * 批量结束实例(同一事物)
	 * 
	 * @param workids
	 *            实例id
	 * @param trackids
	 *            路径id
	 * @param tenantid
	 *            租户id
	 * @return 返回不成功的workid
	 */
	public String stopWork(String[] workids, String[] trackids, String tenantid);

	/**
	 * 批量结束实例(同一事物)
	 * 
	 * @param workids
	 *            实例id
	 * @param trackids
	 *            路径id
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据库标识
	 * @return 返回不成功的workid
	 */
	public String stopWork(String[] workids, String[] trackids,
			String tenantid, String identifier);

	/**
	 * 获取当前节点选择参与者的类型
	 * 
	 * @param workid
	 *            实例id
	 * @param trackid
	 *            路径id
	 * @param tenantid
	 *            租户id
	 * @return 0:异常 1：单选 2：多选
	 */
	public int getSelectType(String workid, String trackid, String tenantid);

	/**
	 * 获取当前节点选择参与者的类型
	 * 
	 * @param workid
	 *            实例id
	 * @param trackid
	 *            路径id
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据库标识
	 * @return 0:异常 1：单选 2：多选
	 */
	public int getSelectType(String workid, String trackid, String tenantid,
			String identifier);

	/**
	 * 替换处理人
	 * 
	 * @param workid
	 *            实例id
	 * @param trackid
	 *            路径id
	 * @param userids
	 *            要替换的参与者
	 * @param tenantid
	 *            租户id
	 * @return 替换处理人是否成功
	 */
	public boolean replaceAuthor(String workid, String trackid, String userids,
			String tenantid);

	/**
	 * 替换处理人
	 * 
	 * @param workid
	 *            实例id
	 * @param trackid
	 *            路径id
	 * @param userids
	 *            要替换的参与者
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据库标识
	 * @return 替换处理人是否成功
	 */
	public boolean replaceAuthor(String workid, String trackid, String userids,
			String tenantid, String identifier);

	/**
	 * 批量删除流程实例（同一事物）
	 * 
	 * @param workids
	 *            实例id
	 * @param tenantid
	 *            租户id
	 * @return 删除实例是否成功
	 */
	public boolean deleteWork(String[] workids, String tenantid);

	/**
	 * 批量删除流程实例（同一事物）
	 * 
	 * @param workids
	 *            实例id
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据库标识
	 * @return 删除实例是否成功
	 */
	public boolean deleteWork(String[] workids, String tenantid,
			String identifier);

	/**
	 * 删除单个实例
	 * 
	 * @param workid
	 *            实例id
	 * @param tenantid
	 *            租户id
	 * @return 删除实例是否成功
	 */
	public boolean deleteWork(String workid, String tenantid);

	/**
	 * 删除单个实例
	 * 
	 * @param workid
	 *            实例id
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据库标识
	 * @return 删除实例是否成功
	 */
	public boolean deleteWork(String workid, String tenantid, String identifier);

	/**
	 * 更新指定实例的xml
	 * 
	 * @param workid
	 *            实例id
	 * @param tenantid
	 *            租户id
	 * @return 更新指定实例的xml是否成功
	 */
	public boolean updateWork(String workid, String tenantid);

	/**
	 * 更新指定实例的xml
	 * 
	 * @param workid
	 *            实例id
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据库标识
	 * @return 更新指定实例的xml是否成功
	 */
	public boolean updateWork(String workid, String tenantid, String identifier);

	/**
	 * 批量更新实例
	 * 
	 * @param workids
	 *            实例id
	 * @param tenantid
	 *            租户id
	 * @return 批量更新实例是否成功
	 */
	public Map<String, Boolean> updateWork(String[] workids, String tenantid);

	/**
	 * 批量更新实例
	 * 
	 * @param workids
	 *            实例id
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据库标识
	 * @return 批量更新实例是否成功
	 */
	public Map<String, Boolean> updateWork(String[] workids, String tenantid,
			String identifier);

	// ========================================================================
	/**
	 * 待办查询
	 * @param todoPara
	 * @return
	 */
	public List<DBTodo> getTodoList(TodoPara todoPara);
	/**
	 * 待办数量查询
	 * @param todoPara
	 * @return
	 */
	public int getTodoCount(TodoPara todoPara);
	
	/**
	 * 已办查询
	 * @param todoPara
	 * @return
	 */
	public List<DBTodo> getHasTodoList(TodoPara todoPara);
	/**
	 * 已办数量查询
	 * @param todoPara
	 * @return
	 */
	public int getHasTodoCount(TodoPara todoPara);
	/**
	 * 已阅查询
	 * @param todoPara
	 * @return
	 */
	public List<DBTodo> getHaveReadList(TodoPara todoPara);
	/**
	 * 已阅数量查询
	 * @param todoPara
	 * @return
	 */
	public int getHaveReadCount(TodoPara todoPara);
	/**
	 * 可阅查询
	 * @param todoPara
	 * @return
	 */
	public List<DBTodo> getCReaderList(TodoPara todoPara);
	/**
	 * 可阅数量查询
	 * @param todoPara
	 * @return
	 */
	public int getCReaderCount(TodoPara todoPara);

	/**
	 * 已经结束的实例(转移到xxx_End表中的数据)
	 * @param todoPara
	 * @return
	 */
	public List<DBTodo> getAllEndList(TodoPara todoPara);

	/**
	 *已经结束的实例数量(转移到xxx_End表中的数据)
	 * @param todoPara
	 * @return
	 */
	public int getAllEndCount(TodoPara todoPara);
	/**
	 * 某人启动的实例查询
	 * @param todoPara
	 * @return
	 */
	public List<DBWork> getMyStartList(TodoPara todoPara);
	/**
	 * 启动的实例数量查询
	 * @param todoPara
	 * @return
	 */
	public int getMyStartCount(TodoPara todoPara);

	/**
	 * 查找所有正在运行中的实例
	 * @param todoPara
	 * @return
	 */
	public List<DBWork> getAllRunningInstanceList(TodoPara todoPara);

	/**
	 * 所有正在运行中的实例数量
	 * @param todoPara
	 * @return
	 */
	public int getAllRunningInstanceCount(TodoPara todoPara);
	/**
	 * 查找所有运行结束的实例
	 * @param todoPara
	 * @return
	 */
	public List<DBWork> getAllEndInstanceList(TodoPara todoPara);

	/**
	 * 所有运行结束的实例数量
	 * @param todoPara
	 * @return
	 */
	public int getAllEndInstanceCount(TodoPara todoPara);
	/**
	 * 某人启动的草稿
	 * @param todoPara
	 * @return
	 */
//	public List<DBWork> getMyDraftList(TodoPara todoPara);
	/**
	 * 某人的草稿数量
	 * @param todoPara
	 * @return
	 */
//	public int getMyDraftCount(TodoPara todoPara);
	/**
	 * 认领查询
	 * @param todoPara
	 * @return
	 */
	public List<DBTodo> getClaimList(TodoPara todoPara);
	/**
	 * 认领数量查询
	 * @param todoPara
	 * @return
	 */
	public int getClaimCount(TodoPara todoPara) ;
	/**
	 * 待阅查询
	 * @param todoPara
	 * @return
	 */
	public List<DBTodo> getToBeReadList(TodoPara todoPara) ;
	/**
	 * 待阅数量查询
	 * @param todoPara
	 * @return
	 */
	public int getToBeReadCount(TodoPara todoPara) ;
	// ========================================================================
	/**
	 * 代办设置
	 * 
	 * @param hashMap
	 *            :参数组成的map
	 * @param tenantid
	 *            :租户id
	 * @return 设置是否成功
	 */
	public boolean agentUserSet(Map<String, String> hashMap,
			String tenantid);

	/**
	 * 代办设置
	 * 
	 * @param hashMap
	 *            :参数组成的map
	 * @param tenantid
	 *            :租户标识
	 * @param dbIdentifier
	 *            :数据库标识
	 * @return
	 */
	public boolean agentUserSet(Map<String, String> hashMap,
			String tenantid, String dbIdentifier);

	/**
	 * 查询允许催办的记录
	 * @param where 查询条件
	 * @param para 查询对应的参数           
	 * @param tenantid
	 *            租户id
	 * @return 允许催办的任务记录
	 */
	public List<DBTask> getTask(String where,List<? extends Object> para,String tenantid);

	/**
	 * 查询允许催办的记录
	 * @param where 查询条件
	 * @param para 查询对应的参数
	 * @param tenantid
	 *            租户id
	 * @param identifier
	 *            数据源标示符
	 * @return 允许催办的任务记录
	 */
	public List<DBTask> getTask(String where,List<? extends Object> para,String tenantid, String identifier);

	/**
	 * 为实例添加仅可查看权限
	 * @param workId 实例id
	 * @param users 目标用户 U_userid 用户 || D_deptid 部门 || P_posid 岗位 || G_groutid 群组
	 * @param tenantId 租户标识
	 * @param identifier 数据源标识
	 * @return
	 */
	public String addCReader(String workId,List<String> users,String tenantId,String identifier);

}
