package com.horizon.wf;

import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeSubflow;
import com.horizon.wf.definition.pub.node.control.INodeButton;
import com.horizon.wf.definition.xml.IXMLSubFlowInfo;
import com.horizon.wf.definition.xml.IXmlButton;
import com.horizon.wf.definition.xml.IXmlFlowInfo;
import com.horizon.wf.definition.xml.IXmlNode;
import com.horizon.wf.entity.db.DBRelation;
import com.horizon.wf.entity.db.DBRelationSubflow;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.entity.user.IRunUser;

import java.util.List;
import java.util.Map;

/**
 * 获取实例操作后返回值的信息
 * 
 * @author liys
 * @version 1.0
 * @since horizon-workflow-pub v7.2.3
 * 
 */
public interface IWorkResult {
	/**
	 * 实例id
	 * @return
	 */
	public String getWorkid();
	/**
	 * 结果返回信息
	 * @return
	 */
	public String getBackMsg();
	
	/**
	 * 当前节点的定义信息对象
	 * 保留此方法仅为了兼容之前的版本
	 * 请使用getCurFlowNode方法返回IFlowNode接口
	 * IFlowNode getCurFlowNode()
	 * @deprecated
	 * @return
	 */
	public IXmlNode getCurNode();
	/**
	 * 获取当前节点定义信息的xml对象
	 */
	public IFlowNode getCurFlowNode();

	/**
	 * 返回结果标号
	 * @return
	 */
	public int getResult();
	
	/**
	 * 当前用户对象
	 * @return
	 */
	public IRunUser getCurUser();
	/**
	 * 当前实例对象
	 * @return
	 */
	public DBWork getWork();
	/**
	 * 下一节点列表
	 * @return
	 */
	public List<INextNode> getNextNodes();
	/**
	 * 下一节点字符串,用于选择节点后重新传入后台的值
	 * @return
	 */
	public String getNextNodeids();
	/**
	 * 根据formid获取对应的业务数据id
	 * @param formid
	 * @return
	 */
	public String getDataidByFormid(String formid);
	/**
	 * 根据流程状态标号获取前台显示的名称
	 * @param flowStatus
	 * @return
	 */
	public String getFlowStatusName(int flowStatus);
	/**
	 * 当前路径对象
	 * @return
	 */
	public DBTrack getCurTrackInfo();
	/**
	 * 下一节点对应的路径对象列表
	 * @return
	 */
	public List<DBTrack> getNextTrackInfos();
	
	/**
	 * 前台传入数据存放的map
	 * @return
	 */
	public Map<String, Object> getHashMap();
	/**
	 * 当前流程信息对象
	 * @return
	 */
	public IFlowInfo getFlowinfo();


	/**
	 * 此接口保留仅为了兼容之前的版本
	 * 请使用getFlowinfo返回IFlowInfo接口
	 * IFlowInfo getFlowinfo()
	 * @deprecated
	 * @return
	 */
	public IXmlFlowInfo getFlowInfo();

	/**
	 * 执行前传入的对象
	 * @return
	 */
	public WorkParaBean getWorkParaBean();
	/**
	 * 是否当前用户锁定文档
	 * @return
	 */
	public boolean isNowUserLock();
	/**
	 * 获取当前锁定文档的用户名称
	 * @return
	 */
	public String getLockUser();
	/**
	 * 获取主流程和子流程的关联数据对象列表
	 * @return
	 */
	public List<DBRelationSubflow> getSubflowWorks() ;
	/**
	 * 获取当前节点下的子流程定义数据列表
	 * List<INodeSubflow> getNodeSubflows()
	 * @deprecated
	 */
	public List<IXMLSubFlowInfo> getSubflows();
	/**
	 * 获取当前节点下的子流程定义数据列表
	 * @return
	 */
	public List<INodeSubflow> getNodeSubflows();
	/**
	 * 获取当前的流程变量
	 * @return
	 */
	public Map<String, String> getFlowVarMap();
	
	/**
	 * 根据workid获取关联关系数据
	 * @param workid
	 * @return List<DBRelation>
	 */
	public List<DBRelation> getRelationsByWorkid(String workid);	
	/**
	 * 判断指定的dataid是否为新创建的数据
	 * @param dataid
	 * @return
	 */
	public boolean checkDataidIsNewCreate(String dataid);
	
	/**
	 * 根据nodeid获取节点选择人员的方式
	 * @param nodeid
	 * @return 1:单选(默认)   2:多选
	 */
	public int getNextSelectTypeByNodeid(String nodeid);
	/**
	 * 根据nodeid从下一节点列表中获取对应的trackid
	 * @param nodeid
	 * @return
	 */
	public String getNxtTrackidByNodeid(String nodeid);
	/**
	 * 获取临时人员信息对象
	 * @return
	 */
	public Map<String, String> getTmpAuthorMap() ;
	
	/**
	 * 子流程启动成功后返回的对象
	 * @return
	 */
	public IWorkResult getSubflowWorkResult() ;
	
	/**
	 * 通过当前人所有权限获取当前可用的按钮
	 * List<INodeButton> getCurNodeButton
	 * @deprecated
	 */
	public List<IXmlButton> getCurButton();
	/**
	 * 通过当前人所有权限获取当前可用的按钮
	 * @return 当前可用按钮组成的列表
	 */
	public List<INodeButton> getCurNodeButton();
	/**
	 * 获取节点初始化时xml中的人员信息
	 * @return
	 */
	public Map<String, String> getInitAuthorMap();
	/**
	 * 前台传入的选择人员信息,在操作处理中也会被修改
	 * @return
	 */
	public Map<String, String> getSelectAuthorMap();
	
	/**
	 * 获取当前节点的主办人
	 * @return 多个以";"割开
	 */
	public String getCurNodeAuthor();
	/**
     * 获取运行期的环境对象
     * 
     * @return
     */
    public RunningData getRunningdata();
	
	/**
	 * webservice返回结果的xml格式
	 * @return
	 */
	public String forServiceString();
}
