package com.horizon.workflow.support.web;

import com.horizon.common.base.Function;
import com.horizon.common.base.Joiner;
import com.horizon.common.base.Objects;
import com.horizon.common.collect.Collections2;
import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.core.HorizonCore;
import com.horizon.core.common.controller.SuperController;
import com.horizon.language.Hi18n;
import com.horizon.language.Hi18nContext;
import com.horizon.utils.HorizonPorps;
import com.horizon.utils.StringUtil;
import com.horizon.utils.json.JsonUtil;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.core.mem.MemCacheUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.workflow.form.entity.SimpleForm;
import com.horizon.workflow.form.entity.SimpleFormField;
import com.horizon.workflow.form.service.ISimpleFormService;
import com.horizon.workflow.support.model.FlowAction;
import com.horizon.workflow.support.model.FlowForm;
import com.horizon.workflow.support.model.FlowResult;
import com.horizon.workflow.support.service.IFlowOtherOperateService;
import com.horizon.workflow.support.service.IFlowSupportService;
import com.horizon.workflow.tenant.service.ITenantGrantService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import static com.horizon.core.HorizonCore.*;

/**
 * 流程运行框架Controller
 *
 * @author mwr
 * @update pengys
 *
 */
@Controller
@RequestMapping("${url.prefix}/support")
public class FlowSupportController extends SuperController {

    /**
     * 流程基本操作
     */
    @Autowired
    protected IFlowSupportService flowSupportService;
    /**
     * 流程其它操作
     */
    @Autowired(required=false)
    protected IFlowOtherOperateService[] flowOtherOperateService;

    /**
     * 自定义表单service
     */
    @Autowired
    protected ISimpleFormService simpleFormService;

    @Autowired
    protected ITenantGrantService tenantGrantService;
    /**
     * 打开流程
     *
     * @return
     */
    @RequestMapping("/open${url.suffix}")
    public String open(Model model, @ModelAttribute WorkParaBean workParaBean, HttpServletRequest request) {

        String accessToken = request.getParameter("accessToken");
        String workId = workParaBean.getWorkId();
        workParaBean.setUserId(USER_ID.value());
        workParaBean.setUserName(USER_NAME.value());
        workParaBean.setDeptName(DEPT_NAME.value());
        workParaBean.setFlowIdentifier(TENANT_IDENTIFIER.value());
        workParaBean.setDataIdentifier(TENANT_IDENTIFIER.value());
        workParaBean.setTenantCode(TENANT_CODE.value());
        if (accessToken != null) {
            model.addAttribute("accessToken", accessToken);
        }
        FlowResult flowResult = null;
        boolean check = true;
        if("true".equals(HorizonPorps.getConfig("isValidateOfTenant"))) {
            List<String> activeInstanceIds = this.findActiveInstanceIds();
            if (!activeInstanceIds.contains(workId)){
                check = tenantGrantService.checkTenantWork(TENANT_CODE.value(), activeInstanceIds.size());
                if (!check){
                    flowResult = new FlowResult();
                    flowResult.setFlowMsg(Hi18n.getVal("tenant-grant", "checkWork"));
                }
            }
        }
        if(check) {
            if (StringUtil.hasValue(workId)) {
                flowResult = flowSupportService.open(workParaBean);
            } else {
                workParaBean.setSubjection("D_" + DEPT_ID.value());
                flowResult = flowSupportService.create(workParaBean);
            }
            if (flowOtherOperateService != null) {
                String dataId = request.getParameter("dataId");
                model.addAttribute("dataId", dataId);
                for (IFlowOtherOperateService OtherOperate : flowOtherOperateService) {
                    OtherOperate.afterOpenExecute(request, model, flowResult);
                }
            }
            if(Objects.equal(flowResult.getHasForm(),"true")){
                this.executeSimpleForm(model,flowResult);
            }
        }
        String ctx = HorizonCore.CONTEXT_PATH.value();
        model.addAttribute("unValidate",HorizonPorps.getConfig("workflow.unValidate"));
        model.addAttribute("fixedModal",HorizonPorps.getConfig("workflow.fixedModal"));
        model.addAttribute("freeSubmit",HorizonPorps.getConfig("workflow.freesubmit.axis"));
        model.addAttribute("messageType",HorizonPorps.getConfig("workflow.messageType"));
        model.addAttribute("i18n",  Hi18nContext.newInstance().getLanguage("workflow"));
        model.addAttribute("LANG",  Hi18n.getDefLocaleKey().replaceAll("_", "-"));
        model.addAttribute("contextPath", ctx);
        model.addAttribute("assetsPath", ctx+HorizonPorps.getAssertPath());
        model.addAttribute("frontPath", ctx+HorizonPorps.getFrontPath());
        model.addAttribute("workFlow", flowResult);
        model.addAttribute("workFlowImport", HorizonPorps.getConfig("workflow.import"));
        return "/module/workflow/index";
    }

    /**
     * 提交流程
     *
     * @return
     */
    @RequestMapping(value = "/action${url.suffix}")
    @ResponseBody
    public String action(@ModelAttribute WorkParaBean workParaBean,HttpServletRequest request) {

        String data = "";
        String actionData = request.getParameter("actionData");
        FlowAction flowAction = getFlowAction(actionData,request);
        if (flowAction != null) {
            if (!Objects.equal("close", flowAction.getOperate())) {
                if (flowOtherOperateService != null) {
                    for (IFlowOtherOperateService OtherOperate : flowOtherOperateService) {
                        if (!OtherOperate.beforeActionExecute(req, flowAction, workParaBean)) {
                            return flowAction.toString();
                        }
                    }
                }
                workParaBean.setUserId(USER_ID.value());
                workParaBean.setFlowIdentifier(TENANT_IDENTIFIER.value());
                workParaBean.setDataIdentifier(TENANT_IDENTIFIER.value());
                workParaBean.setTenantCode(TENANT_CODE.value());
                setMessageType(workParaBean, flowAction.getMessageType());
                setFormData(workParaBean,request);
                if (flowOtherOperateService != null) {
                    for (IFlowOtherOperateService OtherOperate : flowOtherOperateService) {
                        if(!OtherOperate.beforeSubmitFormExecute(req,workParaBean)){
                            return flowAction.toString();
                        }
                    }
                }
                data = flowSupportService.operate(workParaBean, flowAction);
            } else if (Objects.equal(flowAction.getReOpen(), "false")) {
                flowSupportService.close(flowAction.getWorkId(), flowAction.getTrackId(), HorizonCore.USER_ID.value());
                flowAction.setOperateStatus("success");
                return flowAction.toString();
            }
        }
        return data;
    }

    /**
     * 由前端设置消息发送类型
     *
     * @param workParaBean
     *            流程操作参数
     * @param messageType
     *            消息类型
     */
    private void setMessageType(WorkParaBean workParaBean, String messageType) {

        if (StringUtil.hasValue(messageType)) {
            workParaBean.putMsgSendFlagMap(StaticVarExtend.AUTH_AUTHOR, messageType);
            workParaBean.putMsgSendFlagMap(StaticVarExtend.AUTH_SECOND_AUTHOR, messageType);
            workParaBean.putMsgSendFlagMap(StaticVarExtend.AUTH_READER, messageType);
        }

    }

    /**
     * 流程列表
     *
     * @return
     */
    @RequestMapping(value = "/history${url.suffix}")
    @ResponseBody
    public String history(HttpServletRequest request) {

        String workId = request.getParameter("workId");
        return flowSupportService.getHistory(workId);
    }

    protected void executeSimpleForm(Model model, FlowResult flowResult) {
        List<FlowForm> forms = flowResult.getFlowForms();
        Map<String, SimpleFormField> fieldsMap = Maps.newHashMap();
        if (forms != null && !forms.isEmpty()) {
            for (FlowForm flowForm : forms) {
                String formType = flowForm.getFormType();
                String formId = flowForm.getFormId();
                String authId = flowForm.getFormAuthId();
                if(Objects.equal("CUSTOM",formType)){
                    SimpleForm form = simpleFormService.getId(flowForm.getFormId());
                    flowForm.setFormBody(form.getFormUrl());
                    Map<String, SimpleFormField> formFields = simpleFormService.getFormFields(formId, authId);
                    fieldsMap.putAll(formFields);
                }
            }
        }
        model.addAttribute("fields", fieldsMap);
        Map<String, String> dataMap = simpleFormService.getFormData(flowResult.getWorkId());
        model.addAttribute("datas", dataMap);
    }

    private void setFormData(WorkParaBean workParaBean,HttpServletRequest request) {
        Map<String, Object> dataMap = request.getParameterMap();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            String[] values = (String[]) entry.getValue();
            String value = Joiner.on(";").join(values);
            workParaBean.putOtherPara(entry.getKey(), value);
        }
    }

    private FlowAction getFlowAction(String actionData,HttpServletRequest request) {

        String authorKey = request.getParameter("authorKey");
        String workId = request.getParameter("workId");
        String trackId = request.getParameter("trackId");
        String nodeId = request.getParameter("nodeId");
        String nodeName = request.getParameter("nodeName");
        FlowAction flowAction = JsonUtil.fromJson(actionData, FlowAction.class);
        flowAction.setAuthorKey(authorKey);
        flowAction.setWorkId(workId);
        flowAction.setTrackId(trackId);
        flowAction.setNodeId(nodeId);
        flowAction.setNodeName(nodeName);
        if (!StringUtil.hasValue(flowAction.getOperateFlag())) {
            flowAction.setOperateFlag("1");
        }
        return flowAction;
    }
    /**
     * 获取内存中活动的流程实例
     *
     * @return 流程实例List
     */
    private List<String> findActiveInstanceIds() {

        List<Map<String, Object>> instanceLst = MemCacheUtil.getInstanceLstFromMemory(HorizonCore.TENANT_CODE.value());
        if (instanceLst == null && instanceLst.isEmpty()){
            return Lists.newArrayList();
        }
        Collection<String> instanceIds = Collections2.transform(instanceLst, new Function<Map<String, Object>, String>() {
            @Override
            public String apply(Map<String, Object> instance) {
                return (String) instance.get("workid");
            }
        });
        return Lists.newArrayList(instanceIds.iterator());
    }
}
