package com.horizon.workflow.support.web;

import com.horizon.common.base.Joiner;
import com.horizon.common.base.Objects;
import com.horizon.core.HorizonCore;
import com.horizon.core.common.controller.SuperController;
import com.horizon.utils.StringUtil;
import com.horizon.utils.json.JsonUtil;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.workflow.support.model.FlowAction;
import com.horizon.workflow.support.service.IFlowOtherOperateService;
import com.horizon.workflow.support.service.IFlowSupportService;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

import static com.horizon.core.HorizonCore.TENANT_IDENTIFIER;
import static com.horizon.core.HorizonCore.USER_ID;

/**
 * @author LIYS
 * 2018-12-25
 */
public class FlowSupportBase extends SuperController {
    public String actionBase(WorkParaBean workParaBean, HttpServletRequest request
                            ,IFlowOtherOperateService[] flowOtherOperateService
                            ,IFlowSupportService flowSupportService) {

        String data = "";
        String actionData = request.getParameter("actionData");
        FlowAction flowAction = getFlowAction(actionData,request);
        if (flowAction != null) {
            if (!Objects.equal("close", flowAction.getOperate())) {
                if (flowOtherOperateService != null) {
                    for (IFlowOtherOperateService OtherOperate : flowOtherOperateService) {
                        if (!OtherOperate.beforeActionExecute(req, flowAction, workParaBean)) {
                            return flowAction.toString();
                        }
                    }
                }
                //把userid的赋值抽出来是为了在简易测试时,能从前台接收办理人
                //默认还是从session中获取办理人(流转框架中使用)
                setUserid(workParaBean);
                workParaBean.setFlowIdentifier(TENANT_IDENTIFIER.value());
                workParaBean.setDataIdentifier(TENANT_IDENTIFIER.value());
                setMessageType(workParaBean, flowAction.getMessageType());
                setFormData(workParaBean,request);
                if (flowOtherOperateService != null) {
                    for (IFlowOtherOperateService OtherOperate : flowOtherOperateService) {
                        if(!OtherOperate.beforeSubmitFormExecute(req,workParaBean)){
                            return flowAction.toString();
                        }
                    }
                }
                data = flowSupportService.operate(workParaBean, flowAction);
            } else if (Objects.equal(flowAction.getReOpen(), "false")) {
                flowSupportService.close(flowAction.getWorkId(), flowAction.getTrackId(), HorizonCore.USER_ID.value());
                flowAction.setOperateStatus("success");
                return flowAction.toString();
            }
        }
        return data;
    }

    protected void setUserid(WorkParaBean workParaBean){
        workParaBean.setUserId(USER_ID.value());
    }

    /**
     * 由前端设置消息发送类型
     *
     * @param workParaBean
     *            流程操作参数
     * @param messageType
     *            消息类型
     */
    private void setMessageType(WorkParaBean workParaBean, String messageType) {

        if (StringUtil.hasValue(messageType)) {
            workParaBean.putMsgSendFlagMap(StaticVarExtend.AUTH_AUTHOR, messageType);
            workParaBean.putMsgSendFlagMap(StaticVarExtend.AUTH_SECOND_AUTHOR, messageType);
            workParaBean.putMsgSendFlagMap(StaticVarExtend.AUTH_READER, messageType);
        }

    }

    private void setFormData(WorkParaBean workParaBean,HttpServletRequest request) {

        Map<String, Object> dataMap = request.getParameterMap();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            String[] values = (String[]) entry.getValue();
            String value = Joiner.on(";").join(values);
            workParaBean.putOtherPara(entry.getKey(), value);
        }
    }

    private FlowAction getFlowAction(String actionData,HttpServletRequest request) {

        String authorKey = request.getParameter("authorKey");
        String workId = request.getParameter("workId");
        String trackId = request.getParameter("trackId");
        String nodeId = request.getParameter("nodeId");
        String nodeName = request.getParameter("nodeName");
        FlowAction flowAction = JsonUtil.fromJson(actionData, FlowAction.class);
        flowAction.setAuthorKey(authorKey);
        flowAction.setWorkId(workId);
        flowAction.setTrackId(trackId);
        flowAction.setNodeId(nodeId);
        flowAction.setNodeName(nodeName);
        if (!StringUtil.hasValue(flowAction.getOperateFlag())) {
            flowAction.setOperateFlag("1");
        }
        return flowAction;
    }


}
