package com.horizon.workflow.support.util;

import java.util.List;
import java.util.Map;

import com.horizon.common.base.Joiner;
import com.horizon.common.base.Objects;
import com.horizon.common.base.Splitter;
import com.horizon.common.collect.ArrayListMultimap;
import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.common.collect.Multimap;
import com.horizon.core.HorizonCore;
import com.horizon.third.Organization;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.utils.StringUtil;

/**
 * 流程操作的帮助类
 * 
 * @author mwr
 *
 */
public final class ActionUtil {

    public static String relaceSubjectId(String authorId){
        List<String> result = Lists.newArrayList();
        List<String> authors = Splitter.on(";").omitEmptyStrings().splitToList(authorId);
        for(String author : authors){
            List<String > list = Splitter.on("/").omitEmptyStrings().splitToList(author);
            result.add(list.get(0));
        }
        return Joiner.on(";").join(result.iterator());
    }

    /**
     * 删除组织机构ID前缀
     * 
     * @param id
     * @return
     */
    public static String replaceId(String id) {

        if (id.indexOf('_') == -1) {
            return id;
        }
        return id.substring(id.indexOf('_') + 1, id.length());
    }

    /**
     * 根据ID获取组织机构类型
     * 
     * @param id
     * @return
     */
    public static String getType(String id) {

        if (id.indexOf('_') == -1) {
            return "";
        }
        return id.substring(0, id.indexOf('_'));
    }

    /**
     * 去掉部门，群组，岗位前的“/”，人员选择框的回显
     * 
     * @param authId
     * @return
     */
    public static String replacePrefix(String authId) {

        String tempId = replaceClaim(authId);
        if (StringUtil.hasValue(tempId)) {
            List<String> result = Lists.newArrayList();
            List<String> authorIds = Splitter.on(";").omitEmptyStrings().trimResults().splitToList(tempId);
            for (String id : authorIds) {
                List<String> l = Splitter.on("/").trimResults().omitEmptyStrings().splitToList(id);
                if (l.size() == 1) {
                    String str = l.get(0);
                    StringBuilder st = new StringBuilder("U_");
                    if (str.indexOf('_') == -1) {
                        str = st.append(str).toString();
                    }
                    result.add(str);
                } else {
                    result.add(id);
                }
            }
            tempId = Joiner.on(";").join(result.iterator());
        }
        return tempId;
    }

    /**
     * 清楚认领标记 “[]”
     * 
     * @param id
     *            办理人ID
     * @return
     */
    private static String replaceClaim(String id) {

        if (!StringUtil.hasValue(id)) {
            return id;
        }
        if (id.indexOf('[') != -1 || id.indexOf(']') != -1) {
            id = id.replaceAll("\\[", "");
            id = id.replaceAll("\\]", "");
        }
        return id;
    }

    /**
     * 只允许选择人员时，转换办理人的数据
     * 
     * @param authorIds
     * @param isOnlyUser
     * @return
     */
    public static Map<String, List<Map<String, String>>> getAuthorMultimap(String authorIds, boolean isOnlyUser) {

        if (!StringUtil.hasValue(authorIds)) {
            return null;
        }
        Multimap<String, Map<String, String>> multimap = ArrayListMultimap.create();
        List<String> list = Splitter.on(";").splitToList(authorIds);
        for (String authorId : list) {

            userJson(multimap, authorId);
            deptJson(multimap, isOnlyUser, authorId);
        }
        Map<String, List<Map<String, String>>> dataMap = Maps.newHashMap();
        for (String key : multimap.keys()) {
            dataMap.put(key, Lists.newArrayList(multimap.get(key)));
        }

        return dataMap;
    }

    /**
     * 创建部门列表（人员选择框）
     * 
     * @param dataMap
     * @param orgId
     */
    private static void deptJson(Multimap<String, Map<String, String>> dataMap, boolean isOnlyUser, String orgId) {

        String type = getType(orgId);
        String pid = "";
        String key = "others";
        if (Objects.equal(type, "D") || Objects.equal(type, "S")) {
            pid = "defineDept";
            key = (isOnlyUser) ? "depts" : key;
            dataMap.put(key, orgMap(orgId, type, pid));
            return;
        }

        if (Objects.equal(type, "G")) {
            pid = "defineGroup";
            key = (isOnlyUser) ? "groups" : key;
            dataMap.put(key, orgMap(orgId, type, pid));
            return;
        }
        if (Objects.equal(type, "P")) {
            pid = "definePosition";
            key = (isOnlyUser) ? "positions" : key;
            dataMap.put(key, orgMap(orgId, type, pid));
            return;
        }
        if (Objects.equal(type, "R")) {
            pid = "defineRole";
            key = (isOnlyUser) ? "roles" : key;
            dataMap.put(key, orgMap(orgId, type, pid));
            return;
        }
    }

    /**
     * 
     * @param orgId
     *            组织机构ID
     * @param orgType
     *            类型：D:部门;G=群组;P=岗位;R=角色
     * @param pid
     * @return
     */
    private static Map<String, String> orgMap(String orgId, String orgType, String pid) {

        String deptId = replaceId(orgId);
        Organization organization = ThirdAdapterFactory.instanse(HorizonCore.TENANT_CODE.value()).getOrganizationInstance();
        String name = organization.getNameByIds(orgId, null);
        Map<String, String> map = Maps.newHashMap();
        map.put("id", deptId);
        map.put("name", name);
        map.put("title", name);
        map.put("iconSkin", orgType);
        map.put("pid", pid);
        return map;
    }

    /**
     * 创建用户列表（人员选择框）
     * 
     * @param dataMap
     * @param authorId
     *        用户ID
     */
    private static void userJson(Multimap<String, Map<String, String>> dataMap, String authorId) {

        String userId = null;
        String orgType = "D";
        String orgId = null;
        String orgName = null;
        Organization organization = ThirdAdapterFactory.instanse(HorizonCore.TENANT_CODE.value()).getOrganizationInstance();
        String type = getType(authorId);
        if (Objects.equal(type, "U") || !StringUtil.hasValue(type)) {
            List<String> list = Splitter.on("/").omitEmptyStrings().splitToList(authorId);
            if (list.size() == 1) {
                userId = replaceId(list.get(0));
            } else {
                userId = replaceId(list.get(0));
                orgId = replaceId(list.get(1));
                orgType = getType(list.get(1));
                orgName = organization.getNameByIds(list.get(1), HorizonCore.TENANT_CODE.value());
            }
            String userName = organization.getNameByIds(userId, HorizonCore.TENANT_CODE.value());

            Map<String, String> map = Maps.newHashMap();
            map.put("id", userId);
            map.put("name", userName);
            map.put("title", userName);
            map.put("iconSkin", "U");
            map.put("userFromIconSkin", orgType);
            map.put("userFromId", orgId);
            map.put("userFromName", orgName);
            dataMap.put("others", map);
        }
    }

}
