package com.horizon.workflow.support.service;

import java.util.List;

import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.entity.db.DBLog;
import com.horizon.workflow.support.model.FlowAction;
import com.horizon.workflow.support.model.FlowResult;

/**
 * 流程操作接口
 * 
 * @author mwr
 * 
 */
public interface IFlowSupportService {

    /**
     * 创建流程
     * 
     * @param workParaBean
     *            流程参数实体类
     * @return
     */
    public FlowResult create(WorkParaBean workParaBean);

    /**
     * 打开流程
     * 
     * @param workParaBean
     *            流程参数实体类
     * @return
     */
    public FlowResult open(WorkParaBean workParaBean);

    /**
     * 流程操作
     * 
     * @param workParaBean
     *            流程参数
     * @param action
     *            操作交换参数
     * @return
     */
    public String operate(WorkParaBean workParaBean, FlowAction action);

    /**
     * 
     * 关闭流程
     * 
     * @param workId
     *            流程的workId
     * 
     * @param trackId
     *            流程的路径trackId
     * @param userId
     *            当前用户ID
     */
    public void close(String workId, String trackId, String userId);

    /**
     * 获取流程跟踪信息
     * 
     * @param workId
     *            流程实例ID
     * 
     * @return
     */
    public String getHistory(String workId);

}
