package com.horizon.workflow.support.service;

import com.horizon.wf.bean.WorkParaBean;
import com.horizon.workflow.support.model.FlowAction;
import com.horizon.workflow.support.model.FlowResult;
import org.springframework.ui.Model;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 流程其它操作接口
 *
 * @author zhangjf 2018/01/04
 *
 */
public interface IFlowOtherOperateService {

    /**
     * 在操作之前执行
     *
     * @param request
     *            Request对象
     * @param flowAction
     *            节点操作交互的数据对象
     * @param workParaBean
     *            流程流转参数
     * @return
     */
     boolean beforeActionExecute(HttpServletRequest request, FlowAction flowAction, WorkParaBean workParaBean);

    /**
     *
     * 在打开之后执行
     * @param model
     *
     * @param flowResult 流程执行基本信息
     * @return
     */
     boolean afterOpenExecute(HttpServletRequest request, Model model, FlowResult flowResult);

    /**
     *
     * 在打开之后执行
     * @param map
     *
     * @param flowResult 流程执行基本信息
     * @return
     */
     boolean afterOpenExecute(Map<String,Object> map, FlowResult flowResult);


    /**
     * 在提交之前执行
     * @param request Request对象
     * @param workParaBean 流程流转参数
     * @return
     */
     boolean beforeSubmitFormExecute(HttpServletRequest request,WorkParaBean workParaBean);
}
