package com.horizon.workflow.support.result;

import static com.horizon.wf.global.StaticVar.F_STATUS_NoFound;
import static com.horizon.wf.global.StaticVar.F_STATUS_OtherError;
import static com.horizon.wf.global.StaticVar.Init_Cluster;
import static com.horizon.wf.global.StaticVar.Init_Failed;
import static com.horizon.wf.global.StaticVar.Init_License;
import static com.horizon.wf.global.StaticVar.Init_Locked;
import static com.horizon.wf.global.StaticVar.Init_NoRole;
import static com.horizon.wf.global.StaticVar.Init_SelectNode;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import com.horizon.common.base.Joiner;
import com.horizon.common.base.Objects;
import com.horizon.common.base.Splitter;
import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.third.Organization;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.utils.StringUtil;
import com.horizon.wf.IWorkResult;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.info.IFlowForm;
import com.horizon.wf.definition.pub.node.INodeControl;
import com.horizon.wf.definition.pub.node.INodeForm;
import com.horizon.wf.definition.pub.node.INodePara;
import com.horizon.wf.definition.pub.node.control.INodeButton;
import com.horizon.wf.definition.xml.*;
import com.horizon.workflow.support.init.WorkflowOperateInit;
import com.horizon.workflow.support.model.FlowButton;
import com.horizon.workflow.support.model.FlowForm;
import com.horizon.workflow.support.model.FlowNode;
import com.horizon.workflow.support.model.FlowResult;
import com.horizon.workflow.support.model.FlowUser;

/**
 * 流程打开操作结果，用于返回页面数据
 *
 * @author mwr
 */
public class OpenResult extends FlowBuilder {

    /**
     * 流程结果对象
     */
    private FlowResult flowResult;

    /**
     * 流程操作返回的数据对象
     */
    private IWorkResult workResult;

    /**
     * 成功打开后，是否需要加载表单信息
     */
    private boolean open_success = true;

    public OpenResult(IWorkResult workResult) {

        flowResult = new FlowResult();
        this.workResult = workResult;
    }

    /*
     * (non-Javadoc)
     *
     * @see com.horizon.workflow.support.result.FlowBuilder#baseInfo()
     */
    @Override
    public OpenResult baseInfo() {

        int init = workResult.getResult();
        switch (init) {
            case Init_License:// 200：license验证失败
            case Init_NoRole: // 210：无权限
            case Init_Failed: // 290：其他失败
                open_success = false;
                String flowMsg = workResult.getBackMsg();
                flowResult.setFlowMsg(flowMsg);
                break;
            case Init_SelectNode:// 140：当前人处于多个活动节点时
                open_success = false;
                List<FlowNode> selectNodes = getSelectNodes();
                flowResult.setSelectNodes(selectNodes);
                flowResult.setWorkId(workResult.getWorkParaBean().getWorkId());
                flowResult.setOpenType(String.valueOf(open_success));
                break;
            case Init_Locked: // 120：被他人锁定
            case Init_Cluster:// 130：实例正在其他引擎中流转
                init("false");
                break;
            case F_STATUS_NoFound: // 开始节点和任务节点之间设置永远为false的路由条件
                open_success = false;
                flowResult.setFlowMsg(workResult.getBackMsg());
                break;
            case F_STATUS_OtherError: // 参数错误
                open_success = false;
                flowResult.setFlowMsg(workResult.getBackMsg());
                break;
            default:
                init("true");
                break;
        }
        return this;
    }

    /*
     * (non-Javadoc)
     *
     * @see com.horizon.workflow.support.result.FlowBuilder#button()
     */
    @Override
    public OpenResult button() {
        List<INodeButton> curNodeButton = workResult.getCurNodeButton();
        List<FlowButton> flowButtons = Lists.newLinkedList();
        if (null == curNodeButton || curNodeButton.isEmpty()) {
            return this;
        }
        for (INodeButton nodeButton : curNodeButton) {
            String buttonId = nodeButton.getButtonId();
            String buttonName = nodeButton.getBtnShowName();
            String implClass = nodeButton.getImplClass();
            FlowButton flowButton = new FlowButton();
            flowButton.setButtonId(buttonId);
            flowButton.setButtonName(buttonName);
            flowButton.setButtonClass(implClass);
            flowButtons.add(flowButton);
        }
//        List<IXmlButton> xmlButtons = workResult.getCurButton();
//        if (null == xmlButtons || xmlButtons.isEmpty()) {
//            return this;
//        }
//        List<FlowButton> flowButtons = Lists.newLinkedList();
//        for (IXmlButton xmlButton : xmlButtons) {
//            String buttonId = xmlButton.getButtonId();
//            String buttonName = xmlButton.getBtnShowName();
//
//            FlowButton flowButton = new FlowButton();
//            flowButton.setButtonId(buttonId);
//            flowButton.setButtonName(buttonName);
//            flowButton.setButtonClass(xmlButton.getImplClass());
//            flowButtons.add(flowButton);
//        }
        flowResult.setFlowButtons(flowButtons);
        return this;
    }

    /*
     * (non-Javadoc)
     *
     * @see com.horizon.workflow.support.result.FlowBuilder#form()
     */
    @Override
    public OpenResult form() {

        if (open_success) {
            String controlNodeName = workResult.getCurUser().getControlNodeName();
            IFlowNode curFlowNode = workResult.getCurFlowNode();
            INodeControl nodeControl = curFlowNode.getParticipantsControl(controlNodeName);
            List<INodeForm> nodeForms = nodeControl.getAllNodeForms();
            if (nodeForms == null || nodeForms.isEmpty()) {
                return this;
            }
            String defaultFormId = nodeControl.getDefaultShowFormID();
            List<FlowForm> flowForms = getFlowForms(nodeForms, defaultFormId);
            String hasForm = "true";
            if (flowForms.size() == 1) {
                FlowForm form = flowForms.get(0);
                hasForm = (Objects.equal(form.getFormId(), "FlowTrack")) ? "false" : hasForm;
            }
            flowResult.setHasForm(hasForm);
            flowResult.setFlowForms(flowForms);
//            IXmlNode curNode = workResult.getCurNode();
//            IXmlControl iXmlControl = curNode.getParticipantsControl(controlNodeName);
//            List<IXmlNodeForm> nodeForms = iXmlControl.getAllNodeForms();
//            if (nodeForms == null || nodeForms.isEmpty()) {
//                return this;
//            }
//            String defaultFormId = iXmlControl.getDefaultShowFormID();
//            List<FlowForm> flowForms = getFlowForms(nodeForms, defaultFormId);
//            String hasForm = "true";
//            if (flowForms.size() == 1) {
//                FlowForm form = flowForms.get(0);
//                hasForm = (Objects.equal(form.getFormId(), "FlowTrack")) ? "false" : hasForm;
//            }
//            flowResult.setHasForm(hasForm);
//            flowResult.setFlowForms(flowForms);
        }
        return this;
    }

    private List<FlowForm> getFlowForms(List<?extends IXmlNodeForm> nodeForms, String defaultFormId) {
       ;
        List<FlowForm> flowForms = Lists.newArrayList();
        //通过流程表单sort字段进行升序排列
        Collections.sort(nodeForms, new Comparator<IXmlNodeForm>() {
            @Override
            public int compare(IXmlNodeForm o1, IXmlNodeForm o2) {
                return o1.getSort()-o2.getSort();
            }
        });
        for (IXmlNodeForm form : nodeForms) {
            String formId = form.getFormid();
            IFlowForm flowForm_ = workResult.getFlowinfo().getFlowForm(formId);
            String isDefault  = defaultFormId.equals(formId) ? "true" : null;
            String dataId = getFormDataId(formId);
            FlowForm flowForm = new FlowForm();
            flowForm.setFormId(formId);
            flowForm.setFormName(flowForm_.getFormname());
            flowForm.setIsDef(isDefault);
            flowForm.setFormButton(form.getFormButton());
            flowForm.setFormBody(flowForm_.getFormdata());
            flowForm.setFormType(flowForm_.getFormtype());
            flowForm.setFormAuthId(form.getRealFormid());
            flowForm.setFormDataId(dataId);
            flowForm.setIsNewData(String.valueOf(workResult.checkDataidIsNewCreate(dataId)));
            flowForms.add(flowForm);
//            IXmlFlowForm xmlFlowForm = workResult.getFlowInfo().getFlowForm(formId);
//            isDefault = (defaultFormId.equals(formId)) ? "true" : null;
//            String dataId = getFormDataId(formId);
//            FlowForm flowForm = new FlowForm();
//            //定制表单增加版本号
//			/*
//            if (!formId.equals("FlowTrack")) {
//            	String version = xmlFlowForm.getVersion();
//            	flowForm.setFormId(formId + "_" + version);
//            }else{
//            	flowForm.setFormId(formId);
//            }*/
//            flowForm.setFormId(formId);
//            flowForm.setFormName(xmlFlowForm.getFormname());
//            flowForm.setIsDef(isDefault);
//            flowForm.setFormButton(form.getFormButton());
//            flowForm.setFormBody(xmlFlowForm.getFormdata());
//            flowForm.setFormType(xmlFlowForm.getFormtype());
//            flowForm.setFormAuthId(form.getRealFormid());
//            flowForm.setFormDataId(dataId);
//            flowForm.setIsNewData(String.valueOf(workResult.checkDataidIsNewCreate(dataId)));
//            flowForms.add(flowForm);
        }
        return flowForms;
    }
//    private List<FlowForm> getFlowForms(List<IXmlNodeForm> nodeForms, String defaultFormId) {
//
//        String isDefault = null;
//        List<FlowForm> flowForms = Lists.newArrayList();
//        for (IXmlNodeForm form : nodeForms) {
//            String formId = form.getFormid();
//            workResult.getFlowinfo().getFlowForm(formId);
//            IXmlFlowForm xmlFlowForm = workResult.getFlowInfo().getFlowForm(formId);
//            isDefault = (defaultFormId.equals(formId)) ? "true" : null;
//            String dataId = getFormDataId(formId);
//            FlowForm flowForm = new FlowForm();
//            //定制表单增加版本号
//			/*
//            if (!formId.equals("FlowTrack")) {
//            	String version = xmlFlowForm.getVersion();
//            	flowForm.setFormId(formId + "_" + version);
//            }else{
//            	flowForm.setFormId(formId);
//            }*/
//            flowForm.setFormId(formId);
//            flowForm.setFormName(xmlFlowForm.getFormname());
//            flowForm.setIsDef(isDefault);
//            flowForm.setFormButton(form.getFormButton());
//            flowForm.setFormBody(xmlFlowForm.getFormdata());
//            flowForm.setFormType(xmlFlowForm.getFormtype());
//            flowForm.setFormAuthId(form.getRealFormid());
//            flowForm.setFormDataId(dataId);
//            flowForm.setIsNewData(String.valueOf(workResult.checkDataidIsNewCreate(dataId)));
//            flowForms.add(flowForm);
//        }
//        return flowForms;
//    }

    /**
     * 根据formId获取表单业务数据ID，如果是流程跟踪表单FlowTrack
     *
     * @param formId 表单ID
     * @return
     */
    private String getFormDataId(String formId) {

        String dataId = "FlowTrack";
        if (!Objects.equal("FlowTrack", formId)) {
            dataId = workResult.getDataidByFormid(formId);
        }

        return dataId;
    }

    /*
     * (non-Javadoc)
     *
     * @see com.horizon.workflow.support.result.FlowBuilder#node()
     */
    @Override
    public OpenResult node() {

        if (open_success) {
            IFlowNode curFlowNode = workResult.getCurFlowNode();
            FlowNode flowNode = new FlowNode();
            flowNode.setNodeId(curFlowNode.getNodeid());
            flowNode.setNodeName(curFlowNode.getNodename());
            flowNode.setTrackId(workResult.getCurTrackInfo().getId());
            setFlowNodeVars(flowNode);
            flowNode.setMemo(curFlowNode.getNodeMemo());
//            IXmlNode xmlNode = workResult.getCurNode();
//            FlowNode flowNode = new FlowNode();
//            flowNode.setNodeId(xmlNode.getNodeid());
//            flowNode.setNodeName(xmlNode.getNodename());
//            flowNode.setTrackId(workResult.getCurTrackInfo().getId());
//            setFlowNodeVars(flowNode);
//            flowNode.setMemo(xmlNode.getNodeMemo());
            flowResult.setFlowNode(flowNode);
        }
        return this;
    }

    /**
     * 设置节点参数，返回至前台
     *
     * @param flowNode 当前节点数据对象
     */
    private void setFlowNodeVars(FlowNode flowNode) {
        List<INodePara> allNodePara = workResult.getCurFlowNode().getAllNodePara();
        if (allNodePara!= null && !allNodePara.isEmpty()){
            Map<String, String> nodeVars = Maps.newLinkedHashMap();
            for (INodePara nodePara : allNodePara) {
                nodeVars.put(nodePara.getParaId(), nodePara.getInitialValue());
            }
            flowNode.setNodeVars(nodeVars);
        }
//        List<IXmlNodePara> xmlNodeParas = workResult.getCurNode().getAllNodePara();
//        if (xmlNodeParas != null && !xmlNodeParas.isEmpty()) {
//            Map<String, String> nodeVars = Maps.newLinkedHashMap();
//            for (IXmlNodePara xmlNodePara : xmlNodeParas) {
//                nodeVars.put(xmlNodePara.getParaId(), xmlNodePara.getInitialValue());
//            }
//            flowNode.setNodeVars(nodeVars);
//        }
    }

    /*
     * (non-Javadoc)
     *
     * @see com.horizon.workflow.support.result.FlowBuilder#user()
     */
    @Override
    public OpenResult user() {

        if (open_success) {
            String tenantCode = workResult.getWorkParaBean().getTenantCode();
            Organization organization = ThirdAdapterFactory.instanse(tenantCode).getOrganizationInstance();
            String deptId = organization.getDeptIdByUserid(workResult.getCurUser().getUserid(),
                    workResult.getWorkParaBean().getDataIdentifier());
            String author = workResult.getCurUser().getCurNodeAuths();
            String transactorId = workResult.getCurNodeAuthor();
            String authorName = getAuthorsName(author);
            String transactorName = transName(transactorId);
            FlowUser flowUser = new FlowUser();
            flowUser.setUserId(workResult.getCurUser().getUserid());
            flowUser.setUserName(getUserName());
            flowUser.setDeptId(deptId);
            flowUser.setDeptName(workResult.getCurUser().getUserdeptname());
            flowUser.setAuthor(author);
            flowUser.setAuthorName(authorName);
            flowUser.setTransactor(transactorId);
            flowUser.setTransactorName(transactorName);
            flowResult.setFlowUser(flowUser);
        }
        return this;
    }

    private String getUserName() {
        String userName = workResult.getCurUser().getUsername();
        String subjection = workResult.getCurUser().getSubjectionid();
        if (!"-null-".equals(subjection)){
            subjection = workResult.getCurUser().getSubjectiontype() + "_" + subjection;
            String tenantCode = workResult.getWorkParaBean().getTenantCode();
            Organization organization = ThirdAdapterFactory.instanse(tenantCode).getOrganizationInstance();
            String name = organization.getNameByIds(subjection, null);
            if (StringUtil.hasValue(name)) {
                userName = userName + "(" + name + ")";
            }
        }
        return userName;
    }

    /*
     * (non-Javadoc)
     *
     * @see com.horizon.workflow.support.result.FlowBuilder#status()
     */
    @Override
    public OpenResult status() {

        if (open_success) {
            int status = workResult.getCurTrackInfo().getFlowstatus();
            String statusName = workResult.getFlowStatusName(status);
            flowResult.setFlowStatus(String.valueOf(status));
            flowResult.setFlowStatusName(statusName);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     *
     * @see com.horizon.workflow.support.result.FlowBuilder#getResult()
     */
    @Override
    public FlowResult getResult() {

        return this.flowResult;
    }

    private void init(String openType) {

        flowResult.setFlowId(workResult.getWork().getFlowid());
        flowResult.setFlowName(workResult.getWork().getFlowname());
        flowResult.setWorkId(workResult.getWorkid());
        flowResult.setFlowMsg(workResult.getBackMsg());
        flowResult.setAuthorKey(workResult.getCurUser().getAuthName());
        flowResult.setOpenType(openType);
        flowResult.setSubjectionId(workResult.getWorkParaBean().getSubjection());
        flowResult.setFlowVars(workResult.getFlowVarMap());
    }

    /**
     * 根据用户身份ID，获得身份名称
     *
     * @param author 用户身份ID
     * @return
     */
    private String getAuthorsName(String author) {

        List<String> currAuthors = Splitter.on(";").trimResults().omitEmptyStrings().splitToList(author);
        List<String> authName = Lists.newArrayList();
        for (String auth : currAuthors) {
            authName.add(WorkflowOperateInit.getAuhorName(auth));
        }
        return Joiner.on(";").join(authName.iterator());
    }

    /**
     * 将当前办理人ID，转换为显示名称
     *
     * @param id
     * @return
     */
    private String transName(String id) {

        String userName = null;
        if (!StringUtil.hasValue(id)) {
            return userName;
        }
        id = id.replaceAll("\\[", "");
        id = id.replaceAll("\\]", "");

        String tenantId = workResult.getWorkParaBean().getTenantCode();
        String identifier = workResult.getWorkParaBean().getDataIdentifier();
        Organization org = ThirdAdapterFactory.instanse(tenantId).getOrganizationInstance();
        userName = org.getNameByIds(id, identifier);
        return userName;

    }

    /**
     * 从返回信息中拆分节点信息
     *
     * @return
     */
    private List<FlowNode> getSelectNodes() {

        String msg = workResult.getBackMsg();
        List<String> selNodes = Splitter.on(";").omitEmptyStrings().trimResults().splitToList(msg);
        List<FlowNode> flowNodes = Lists.newArrayList();
        if (selNodes != null && !selNodes.isEmpty()) {
            for (String node : selNodes) {
                String[] tmp = node.split("=");
                FlowNode flowNode = new FlowNode();
                flowNode.setNodeId(tmp[1]);
                flowNode.setNodeName(transNodeName(tmp[0]));
                flowNodes.add(flowNode);
            }
        }

        return flowNodes;
    }

    /**
     * 办理人处于多活动节点时，办理人ID转换为中文
     *
     * @param nodeName 节点名称
     * @return
     */
    private String transNodeName(String nodeName) {

        int start = nodeName.indexOf("[");
        if (start == -1) {
            return nodeName;
        }
        int end = nodeName.lastIndexOf("]");
        String name = nodeName.substring(0, start);
        String author = nodeName.substring(start + 1, end);
        List<String> authors = Splitter.on("/").omitEmptyStrings().trimResults().splitToList(author);
        StringBuilder builder = new StringBuilder();
        builder.append(name).append("[");
        for (String auth : authors) {
            builder.append(WorkflowOperateInit.getAuhorName(auth)).append(";");
        }
        builder.deleteCharAt(builder.lastIndexOf(";"));
        builder.append("]");
        return builder.toString();
    }

}
