package com.horizon.workflow.support.result;

import com.horizon.workflow.support.model.FlowResult;

/**
 * 流程操作结果构建器
 * 
 * @author mawr
 *
 */
public abstract class FlowBuilder {

    /**
     * 基本信息
     */
    public abstract FlowBuilder baseInfo();

    /**
     * 流程操作
     * 
     */
    public abstract FlowBuilder button();

    /**
     * 表单
     * 
     */
    public abstract FlowBuilder form();

    /**
     * 当前节点
     * 
     */
    public abstract FlowBuilder node();

    /**
     * 当前用户
     * 
     */
    public abstract FlowBuilder user();

    /**
     * 流程当前状态
     * 
     */
    public abstract FlowBuilder status();

    /**
     * 返回结果集
     * 
     * @return {@link FlowResult}
     */
    public abstract FlowResult getResult();
}
