package com.horizon.workflow.support.model;

import java.io.Serializable;
import java.util.Map;

import com.horizon.common.base.Objects;

/**
 * 子流程数据对象
 * 
 * @author mwr
 *
 */
public class SubFlow implements Serializable {

    private static final long serialVersionUID = -4316082952420927070L;

    /**
     * 流程ID
     */
    private String subFlowId;

    /**
     * 流程名称
     */
    private String subFlowName;

    /**
     * 是否已启动
     */
    private String isStarted;

    /**
     * 子流程实例列表
     */
    private Map<String, String> subWorks;

    /**
     * 流程办理人
     */
    private FlowAuthor authors;

    /**
     * 是否已选择
     */
    private String isSelect;

    private String selectType;

    public String getSubFlowId() {

        return subFlowId;
    }

    public void setSubFlowId(String subFlowId) {

        this.subFlowId = subFlowId;
    }

    public String getSubFlowName() {

        return subFlowName;
    }

    public void setSubFlowName(String subFlowName) {

        this.subFlowName = subFlowName;
    }

    public String getIsStarted() {

        return isStarted;
    }

    public void setIsStarted(String isStarted) {

        this.isStarted = isStarted;
    }

    public String getIsSelect() {

        return isSelect;
    }

    public void setIsSelect(String isSelect) {

        this.isSelect = isSelect;
    }

    public Map<String, String> getSubWorks() {

        return subWorks;
    }

    public void setSubWorks(Map<String, String> subWorks) {

        this.subWorks = subWorks;
    }

    public FlowAuthor getAuthors() {

        return authors;
    }

    public void setAuthors(FlowAuthor authors) {

        this.authors = authors;
    }

    public String getSelectType() {

        return selectType;
    }

    public void setSelectType(String selectType) {

        this.selectType = selectType;
    }

    public boolean equals(Object obj) {

        if (null == obj) {
            return false;
        } else if (obj instanceof SubFlow) {
            SubFlow subFlow = (SubFlow) obj;
            if (subFlow.getSubFlowId().equals(this.subFlowId)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {

        int result = 17;
        result = 37 * result + Objects.hashCode(this.subFlowId);
        return result;
    }
}
