package com.horizon.workflow.support.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 流程执行基本信息
 *
 * @author mwr
 */
public class FlowResult implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 流程ID
     */
    private String flowId;

    /**
     * 流程名称
     */
    private String flowName;

    /**
     * 流程执行的当前用户
     */
    private FlowUser flowUser;

    /**
     * 流程状态
     */
    private String flowStatus;

    /**
     * 流程状态显示名称
     */
    private String flowStatusName;

    /**
     * 流程表单
     */
    private List<FlowForm> flowForms;

    /**
     * 流程操作按钮
     */
    private List<FlowButton> flowButtons;

    /**
     * 流程当前节点信息
     */
    private FlowNode flowNode;

    /**
     * 当前人处于多个活动节点时，需要选择节点打开实例
     */
    private List<FlowNode> selectNodes;

    /**
     * 流程实例ID
     */
    private String workId;

    /**
     * 办理人所属范围
     */
    private String subjectionId;

    /**
     * 流程返回信息
     */
    private String flowMsg;

    /**
     * 流程打开状态
     */
    private String openType;

    /**
     * 当前办理人身份
     */
    private String authorKey;

    /**
     * 是否含有业务表单
     */
    private String hasForm;

    /**
     * 流程变量
     */
    private Map<String, String> flowVars;

    public String getFlowId() {

        return flowId;
    }

    public void setFlowId(String flowId) {

        this.flowId = flowId;
    }

    public String getWorkId() {

        return workId;
    }

    public void setWorkId(String workId) {

        this.workId = workId;
    }

    public String getSubjectionId() {

        return subjectionId;
    }

    public void setSubjectionId(String subjectionId) {

        this.subjectionId = subjectionId;
    }

    public FlowUser getFlowUser() {

        return flowUser;
    }

    public void setFlowUser(FlowUser flowUser) {

        this.flowUser = flowUser;
    }

    public List<FlowForm> getFlowForms() {

        return flowForms;
    }

    public void setFlowForms(List<FlowForm> flowForms) {

        this.flowForms = flowForms;
    }

    public List<FlowButton> getFlowButtons() {

        return flowButtons;
    }

    public void setFlowButtons(List<FlowButton> flowButtons) {

        this.flowButtons = flowButtons;
    }

    public FlowNode getFlowNode() {

        return flowNode;
    }

    public void setFlowNode(FlowNode flowNode) {

        this.flowNode = flowNode;
    }

    public List<FlowNode> getSelectNodes() {

        return selectNodes;
    }

    public void setSelectNodes(List<FlowNode> selectNodes) {

        this.selectNodes = selectNodes;
    }

    public String getFlowMsg() {

        return flowMsg;
    }

    public void setFlowMsg(String flowMsg) {

        this.flowMsg = flowMsg;
    }

    public String getFlowName() {

        return flowName;
    }

    public void setFlowName(String flowName) {

        this.flowName = flowName;
    }

    public String getFlowStatus() {

        return flowStatus;
    }

    public void setFlowStatus(String flowStatus) {

        this.flowStatus = flowStatus;
    }

    public String getFlowStatusName() {

        return flowStatusName;
    }

    public void setFlowStatusName(String flowStatusName) {

        this.flowStatusName = flowStatusName;
    }

    public String getAuthorKey() {

        return authorKey;
    }

    public void setAuthorKey(String authorKey) {

        this.authorKey = authorKey;
    }

    public String getOpenType() {

        return openType;
    }

    public void setOpenType(String openType) {

        this.openType = openType;
    }

    public String getHasForm() {

        return hasForm;
    }

    public void setHasForm(String hasForm) {

        this.hasForm = hasForm;
    }

    public Map<String, String> getFlowVars() {
        return flowVars;
    }

    public void setFlowVars(Map<String, String> flowVars) {
        this.flowVars = flowVars;
    }
}
