package com.horizon.workflow.support.model;

import java.io.Serializable;
import java.util.Map;

/**
 * 流程运行的当前节点
 *
 * @author mwr
 *
 */
public class FlowNode implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 节点ID
     */
    private String nodeId;

    /**
     * 节点名称
     */
    private String nodeName;

    /**
     * 流转路径
     */
    private String trackId;

    /**
     * 当前节点参数,只在当前节点有效
     */
    private Map<String, String> nodeVars;

    /**
     * 节点描述
     */
    private String memo;

    public String getTrackId() {

        return trackId;
    }

    public void setTrackId(String trackId) {

        this.trackId = trackId;
    }

    public String getNodeId() {

        return nodeId;
    }

    public void setNodeId(String nodeId) {

        this.nodeId = nodeId;
    }

    public String getNodeName() {

        return nodeName;
    }

    public void setNodeName(String nodeName) {

        this.nodeName = nodeName;
    }

    /**
     * 流程创建/打开时，获取节点参数
     * @return
     */
    public Map<String, String> getNodeVars() {
        return nodeVars;
    }

    public void setNodeVars(Map<String, String> nodeVars) {
        this.nodeVars = nodeVars;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
