package com.horizon.workflow.support.model;

import java.util.Map;

/**
 * 下一节点信息
 * 
 * @author mwr
 *
 */
public class FlowNextNode extends FlowNode {

    private static final long serialVersionUID = 1L;

    /**
     * 节点主键
     */
    private String nodeKey;

    /**
     * 需要选择的节点ID
     */

    private String selectId;

    /**
     * 需要选择的节点名称
     */
    private String selectName;

    /**
     * 是否已选择
     */
    private String isSelect;

    /**
     * 是否已经走过
     */
    private String isDone;

    /**
     * 单选节点分组
     */
    private String nodeGroup;

    /**
     * 是否显示办理人页签，主要用于运行页面办理人显示，不参与业务处理
     */
    private String isShowTabs;

    /**
     * 节点办理时限
     */
    private String timeLimit;

    /**
     * 办理时限类型
     */
    private String timeLimitType;

    /**
     * 节点状态
     */
    private String nodeStatus;

    /**
     * 下一节点办理人
     */
    private Map<String, FlowAuthor> authors;

    public String getNodeKey() {

        return nodeKey;
    }

    public void setNodeKey(String nodeKey) {

        this.nodeKey = nodeKey;
    }

    public String getSelectId() {

        return selectId;
    }

    public void setSelectId(String selectId) {

        this.selectId = selectId;
    }

    public String getSelectName() {

        return selectName;
    }

    public void setSelectName(String selectName) {

        this.selectName = selectName;
    }

    public String getIsSelect() {

        return isSelect;
    }

    public void setIsSelect(String isSelect) {

        this.isSelect = isSelect;
    }

    public String getIsDone() {

        return isDone;
    }

    public void setIsDone(String isDone) {

        this.isDone = isDone;
    }

    public String getNodeGroup() {

        return nodeGroup;
    }

    public void setNodeGroup(String nodeGroup) {

        this.nodeGroup = nodeGroup;
    }

    public Map<String, FlowAuthor> getAuthors() {

        return authors;
    }

    public void setAuthors(Map<String, FlowAuthor> authors) {

        this.authors = authors;
    }

    public String getIsShowTabs() {

        return isShowTabs;
    }

    public void setIsShowTabs(String isShowTabs) {

        this.isShowTabs = isShowTabs;
    }

    public String getTimeLimit() {

        return timeLimit;
    }

    public void setTimeLimit(String timeLimit) {

        this.timeLimit = timeLimit;
    }

    public String getTimeLimitType() {

        return timeLimitType;
    }

    public void setTimeLimitType(String timeLimitType) {

        this.timeLimitType = timeLimitType;
    }

    public String getNodeStatus() {

        return nodeStatus;
    }

    public void setNodeStatus(String nodeStatus) {

        this.nodeStatus = nodeStatus;
    }

}
