package com.horizon.workflow.support.model;

import com.horizon.workflow.form.entity.FieldAuth;
import com.horizon.workflow.form.entity.SimpleFormField;

import java.io.Serializable;
import java.util.Map;

/**
 * 流程运行的表单
 *
 * @author mwr
 *
 */
public class FlowForm implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 表单ID
	 */
	private String formId;

	/**
	 * 表单名称
	 */
	private String formName;

	/**
	 * 表单内容
	 */
	private String formBody;

	/**
	 * 表单按钮
	 */
	private String formButton;

	/**
	 * 是否为默认表单
	 */
	private String isDef;

	/**
	 * 表单类型：外部表单，定制表单
	 */
	private String formType;

	/**
	 * 表单数据ID
	 */
	private String formDataId;

	/**
	 * 字段权限ID
	 */
	private String formAuthId;

	/**
	 * 是否为的表单数据
	 */
	private String isNewData;

	/**
	 * 表单字段
	 */
	private Map<String,SimpleFormField> formFields;

	/**
	 * 表单数据
	 */
	private Map<String,String> formDatas;

	/**
	 * 表单字段字段权限信息
	 */
	private FieldAuth formFieldAuth;

	public Map<String, SimpleFormField> getFormFields() {
		return formFields;
	}

	public void setFormFields(Map<String, SimpleFormField> formFields) {
		this.formFields = formFields;
	}

	public Map<String, String> getFormDatas() {
		return formDatas;
	}

	public void setFormDatas(Map<String, String> formDatas) {
		this.formDatas = formDatas;
	}

	public String getFormId() {

		return formId;
	}

	public void setFormId(String formId) {

		this.formId = formId;
	}

	public String getFormName() {

		return formName;
	}

	public void setFormName(String formName) {

		this.formName = formName;
	}

	public String getFormButton() {
		return formButton;
	}

	public void setFormButton(String formButton) {
		this.formButton = formButton;
	}

	public String getFormBody() {

		return formBody;
	}

	public void setFormBody(String formBody) {

		this.formBody = formBody;
	}

	public String getIsDef() {

		return isDef;
	}

	public void setIsDef(String isDef) {

		this.isDef = isDef;
	}

	public String getFormType() {

		return formType;
	}

	public void setFormType(String formType) {

		this.formType = formType;
	}

	public String getFormAuthId() {

		return formAuthId;
	}

	public void setFormAuthId(String formAuthId) {

		this.formAuthId = formAuthId;
	}

	public String getFormDataId() {

		return formDataId;
	}

	public void setFormDataId(String formDataId) {

		this.formDataId = formDataId;
	}

	public String getIsNewData() {

		return isNewData;
	}

	public void setIsNewData(String isNewData) {

		this.isNewData = isNewData;
	}

	public FieldAuth getFormFieldAuth() {
		return formFieldAuth;
	}

	public void setFormFieldAuth(FieldAuth formFieldAuth) {
		this.formFieldAuth = formFieldAuth;
	}
}
