package com.horizon.workflow.support.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 下一节点办理人
 * 
 * @author mwr
 *
 */
public class FlowAuthor implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 办理人ID
     */
    private String authorId;

    /**
     * 办理人名称：主办，协办，读者
     */
    private String authorName;

    /**
     * 人员选择类型，1单选，2多选
     */
    private String selectType;

    /**
     * 是否自由选择
     */
    private String isFree;

    /**
     * 自由选择时的范围
     */
    private String freeArea;

    /**
     * 是否只选择人员
     */
    private String isUser;

    /**
     * 流程定义列表中选择
     */
    private String isDefUser;

    /**
     * 是否允许选择办理人
     */
    private String isSelect;

    /**
     * 节点已选择办理人ID
     */
    private String selectAuthor;

    /**
     * 节点已选择办理人名称
     */
    private String selectAuthorName;

    /**
     * 办理人必填标识,为true时必填
     */
    private String required;

    private String authorFlowVar;

    /**
     * 节点初始化办理人ID
     */
    private Map<String, List<Map<String, String>>> initAuthor;

    public String getAuthorId() {

        return authorId;
    }

    public void setAuthorId(String authorId) {

        this.authorId = authorId;
    }

    public String getAuthorName() {

        return authorName;
    }

    public void setAuthorName(String authorName) {

        this.authorName = authorName;
    }

    public String getSelectType() {

        return selectType;
    }

    public void setSelectType(String selectType) {

        this.selectType = selectType;
    }

    public String getSelectAuthor() {

        return selectAuthor;
    }

    public void setSelectAuthor(String selectAuthor) {

        this.selectAuthor = selectAuthor;
    }

    public String getSelectAuthorName() {

        return selectAuthorName;
    }

    public void setSelectAuthorName(String selectAuthorName) {

        this.selectAuthorName = selectAuthorName;

    }

    public Map<String, List<Map<String, String>>> getInitAuthor() {

        return initAuthor;
    }

    public void setInitAuthor(Map<String, List<Map<String, String>>> initAuthor) {

        this.initAuthor = initAuthor;
    }

    public String getIsFree() {

        return isFree;
    }

    public void setIsFree(String isFree) {

        this.isFree = isFree;
    }

    public String getFreeArea() {
        return freeArea;
    }

    public void setFreeArea(String freeArea) {
        this.freeArea = freeArea;
    }

    public String getIsUser() {

        return isUser;
    }

    public void setIsUser(String isUser) {

        this.isUser = isUser;
    }

    public String getIsDefUser() {

        return isDefUser;
    }

    public void setIsDefUser(String isDefUser) {

        this.isDefUser = isDefUser;
    }

    public String getIsSelect() {

        return isSelect;
    }

    public void setIsSelect(String isSelect) {

        this.isSelect = isSelect;
    }

    public String getRequired() {

        return required;
    }

    public void setRequired(String required) {

        this.required = required;
    }

    public String getAuthorFlowVar() {
        return authorFlowVar;
    }

    public void setAuthorFlowVar(String authorFlowVar) {
        this.authorFlowVar = authorFlowVar;
    }
}
