package com.horizon.workflow.support.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.horizon.common.base.Joiner;
import com.horizon.common.collect.Lists;
import com.horizon.utils.json.JsonUtil;

/**
 * 节点操作交互的数据对象
 *
 * @author mwr
 */
public class FlowAction implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 流程操作
     */
    private String operate;

    /**
     * 操作具体实现类
     */
    private String operateClazz;

    /**
     * 操作的显示名称
     */
    private String operateText;

    /**
     * 操作标记：-1 显示关闭，0，1正常提交
     */
    private String operateFlag;

    /**
     * 返回操作信息
     */
    private String operateMsg;

    /**
     * 是否重新打开
     */
    private String reOpen;

    /**
     * 重新打开时的流程参数
     */
    private String workId;

    /**
     * 重新打开时的流程参数
     */
    private String trackId;

    /**
     * 当前节点ID
     */
    private String nodeId;

    /**
     * 当前节点名称
     */
    private String nodeName;

    /**
     * 身份标识
     */
    private String subjection;

    /**
     * 参与者ID
     */
    private String authorKey;

    /**
     * 流程操作结果状态 success,subsccess,error,selectsubflow
     */
    private String operateStatus;

    /**
     * 流程操作状态
     */
    private int status;

    /**
     * 是否弹出操作成功信息
     */
    private String alert;

    /**
     * 消息发送类型
     */
    private String messageType;

    /**
     * 需要选择的节点列表
     */
    private List<FlowNextNode> nextNodes;

    /**
     * 自由提交节点信息
     */
    private FreeNextNode freeNode;


    /**
     * 流程变量
     */
    private Map<String, String> flowVars;


    /**
     * 子流程列表
     */
    private List<SubFlow> subFlows;

    public String getOperate() {

        return operate;
    }

    public void setOperate(String operate) {

        this.operate = operate;
    }

    public String getOperateClazz() {

        return operateClazz;
    }

    public void setOperateClazz(String operateClazz) {

        this.operateClazz = operateClazz;
    }

    public String getOperateText() {

        return operateText;
    }

    public void setOperateText(String operateText) {

        this.operateText = operateText;
    }

    public String getOperateFlag() {

        return operateFlag;
    }

    public void setOperateFlag(String operateFlag) {

        this.operateFlag = operateFlag;
    }

    public String getOperateMsg() {

        return operateMsg;
    }

    public void setOperateMsg(String operateMsg) {

        this.operateMsg = operateMsg;
    }

    public String getOperateStatus() {

        return operateStatus;
    }

    public void setOperateStatus(String operateStatus) {

        this.operateStatus = operateStatus;
    }

    public List<FlowNextNode> getNextNodes() {
        return nextNodes == null? null:Collections.unmodifiableList(nextNodes);
    }

    public void setNextNodes(List<FlowNextNode> nextNodes) {

        this.nextNodes = nextNodes;
    }

    public String getNextNodeId() {

        if (null == nextNodes || nextNodes.isEmpty()) {
            return null;
        }
        List<String> nextNodeId = Lists.newArrayList();
        for (FlowNextNode nextNode : nextNodes) {
            String isSelect = nextNode.getIsSelect();
            if (Boolean.parseBoolean(isSelect)) {
                nextNodeId.add(nextNode.getSelectId());
            }
        }
        return Joiner.on("&").join(nextNodeId.iterator());
    }

    public List<SubFlow> getSubFlows() {

        return subFlows;
    }

    public void setSubFlows(List<SubFlow> subFlows) {

        this.subFlows = subFlows;
    }

    public String getReOpen() {

        return reOpen;
    }

    public void setReOpen(String reOpen) {

        this.reOpen = reOpen;
    }

    public String getTrackId() {

        return trackId;
    }

    public void setTrackId(String trackId) {

        this.trackId = trackId;
    }

    public String getWorkId() {

        return workId;
    }

    public void setWorkId(String workId) {

        this.workId = workId;
    }

    public String getNodeId() {

        return nodeId;
    }

    public void setNodeId(String nodeId) {

        this.nodeId = nodeId;
    }

    public String getNodeName() {

        return nodeName;
    }

    public void setNodeName(String nodeName) {

        this.nodeName = nodeName;
    }

    public String getAuthorKey() {

        return authorKey;
    }

    public void setAuthorKey(String authorKey) {

        this.authorKey = authorKey;
    }

    public String getAlert() {

        return alert;
    }

    public void setAlert(String alert) {

        this.alert = alert;
    }

    public String getMessageType() {

        return messageType;
    }

    public void setMessageType(String messageType) {

        this.messageType = messageType;
    }

    public String getSubjection() {

        return subjection;
    }

    public void setSubjection(String subjection) {

        this.subjection = subjection;
    }

    public void setFlowVars(Map<String, String> flowVars) {

        this.flowVars = flowVars;
    }

    public Map<String, String> getFlowVars() {

        return flowVars;
    }

    public FreeNextNode getFreeNode() {
        return freeNode;
    }

    public void setFreeNode(FreeNextNode freeNode) {
        this.freeNode = freeNode;
    }

    public String toString() {

        return JsonUtil.toJson(this);
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}
