package com.horizon.workflow.support.init;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;

import com.horizon.core.common.service.SpringContextHolder;

/**
 * 初始化流程运行框架参数
 * 
 * @author mwr
 *
 */

public class WorkflowOperateFactory {

    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowOperateFactory.class);

    /**
     * 流程结果处理策略
     */
    private Map<String, String> action;

    private Map<String, String> strategy;

    private Map<String, String> author;

    public Map<String, String> getAction() {

        return action;
    }

    public void setAction(Map<String, String> action) {

        this.action = action;
    }

    public Map<String, String> getStrategy() {

        return strategy;
    }

    public void setStrategy(Map<String, String> strategy) {

        this.strategy = strategy;
    }

    public Map<String, String> getAuthor() {

        return author;
    }

    public void setAuthor(Map<String, String> author) {

        this.author = author;
    }


    /**
     * 获取配置类
     * 
     */
    public static WorkflowOperateFactory newInstance() {

        try {
            ApplicationContext context = SpringContextHolder.getApplicationContext();
            return context.getBean(WorkflowOperateFactory.class);
        } catch (NoUniqueBeanDefinitionException e) {
            LOGGER.error("存在多个WorkflowOperateFactory", e);
            throw e;
        } catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }
}
