package com.horizon.workflow.support.data;

import com.horizon.common.base.Objects;
import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.db.Access;
import com.horizon.language.Hi18n;
import com.horizon.utils.HorizonPorps;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.workflow.form.service.ISimpleFormService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

/**
 * 处理流程业务数据
 * 
 * @author mwr
 *
 */
public class BusinessDataOperate extends BaseRuleImpl implements IBaseRule {

    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessDataOperate.class);
    /**
     * 多语言文件名常量
     */
    private static final String WORKFLOW = "workflow";
    /**
     * 外部表单服务类
     */
    private ISimpleFormService simpleForm;

    @Override
    public boolean executeRule() {

        boolean execute = true;
        int flowActive = getRunningdata().getInstanceDefinition().getFlowinfo().getActive();
        String commit = HorizonPorps.getConfig("workflow.unCommitData");
        if (flowActive == 2 && Objects.equal(commit, "true")) {
            LOGGER.info(Hi18n.getVal(WORKFLOW, "businessDataSave"));
            return execute;
        }

        String identifier = getRunningdata().getInitData().getDataIdentifier();
        Map<String, Object> dataMap = getRunningdata().getInitData().getHashMap();
        Map<String, Map<String, List<Object>>> innerFormMap = (Map<String, Map<String, List<Object>>>) dataMap.get("innerForm");
        if (innerFormMap != null && !innerFormMap.isEmpty()) {
            for (Map.Entry<String, Map<String, List<Object>>> entry : innerFormMap.entrySet()) {
                String dataSource = entry.getKey();
                Map<String, List<Object>> insertSql = entry.getValue();
                if (Objects.equal(dataSource, identifier)){
                    getRunningdata().putSQLToDataMap(insertSql);
                }else {
                    execute = Access.executeMultiUpdate(insertSql, dataSource);
                    if (!execute) {
                        break;
                    }
                }
            }
        }
        if (execute) {
           // Map<String, List<Object>> sqlAndData = simpleForm.getFormSqlAndData(dataMap);
            //getRunningdata().putSQLToDataMap(sqlAndData);
            Map<String, Map<String, List<Object>>> simpleFormSqlData = simpleForm.getFormSqlData(dataMap);
            if (simpleFormSqlData != null && !simpleFormSqlData.isEmpty()) {
                for (Map.Entry<String, Map<String, List<Object>>> entry : simpleFormSqlData.entrySet()) {
                    String dataSource = entry.getKey();
                    Map<String, List<Object>> insertSql = entry.getValue();
                    if (Objects.equal(dataSource, identifier)){
                        getRunningdata().putSQLToDataMap(insertSql);
                    }else {
                        execute = Access.executeMultiUpdate(insertSql, dataSource);
                        if (!execute) {
                            break;
                        }
                    }
                }
            }
        }
        setSubFlowsFormData();
        return execute;
    }

    private void setSubFlowsFormData(){
        Map<String, Object> dataMap = getRunningdata().getInitData().getHashMap();
        WorkParaBean paraBean = (WorkParaBean) getRunningdata().getHmiParaObject();

        String pageId = (String) dataMap.get("PAGEID");
        String formId = (String) dataMap.get("FORMID");
        String dataId = (String) dataMap.get(pageId+"_WORKFLOW_DATA");
        List<String> subFlows = (List<String>) paraBean.getOtherPara().get("subworks");
        if(subFlows != null && !subFlows.isEmpty()){
            List<String> list;
            List<Object> data = Lists.newArrayList();
            String sql = " INSERT INTO TWR_HZ_INSTANCE(ID,WORKID,DATAID,FORMID) VALUES(?,?,?,?)";
            Map<String, List<Object>> sqlAndData = Maps.newHashMap();
            for(String subWorkId : subFlows){
                String id = Access.getUUID();
                list= Lists.newArrayList(id,subWorkId);
                list.add(dataId);
                list.add(formId);
                data.add(list);
            }
            sqlAndData.put(sql, data);
            getRunningdata().putSQLToDataMap(sqlAndData);
        }
    }

    public ISimpleFormService getSimpleForm() {

        return simpleForm;
    }

    public void setSimpleForm(ISimpleFormService simpleForm) {

        this.simpleForm = simpleForm;
    }

}
