package com.horizon.workflow.support.action;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.horizon.common.base.Objects;
import com.horizon.common.base.Predicate;
import com.horizon.common.collect.Collections2;
import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.wf.definition.pub.node.INodeSubflow;
import com.horizon.wf.definition.xml.IXMLSubFlowInfo;
import com.horizon.wf.entity.db.DBRelationSubflow;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.workflow.support.model.FlowAction;
import com.horizon.workflow.support.model.FlowAuthor;
import com.horizon.workflow.support.model.SubFlow;

/**
 * 子流程提交操作（不需要选择节点，及设置办理人操作）
 * 
 * @author mwr
 *
 */
public class SubflowSubmitAction extends ActionBaseStrategy {

    @Override
    public FlowAction actionDo() {

        int status = operator();
        switch (status) {
            case StaticVarExtend.F_STATUS_IsHaveSubFlow:
                action.setOperateStatus("showSubflow");
                action.setOperateMsg(message());
                action.setSubFlows(subflows());
                break;
            case StaticVarExtend.F_STATUS_NeedSelSubFlow:
                action.setOperateStatus("selectSubflow");
                action.setOperateFlag(StaticVarExtend.Submit_Flag_Commit);
                action.setOperateMsg(message());
                action.setSubFlows(subflows());
                break;
            case StaticVarExtend.F_STATUS_Success:
                action.setOperateMsg(message());
                action.setOperateStatus("success");
                action.setAlert("true");
                action.setReOpen(String.valueOf(autoOpen()));
                setWorkId();
                break;
            default:
                action.setOperateMsg(message());
                action.setOperateStatus("error");
                break;
        }

        return action;
    }
    @Override
    protected boolean autoOpen() {

        return true;
    }

    private void setWorkId() {

        DBRelationSubflow subflow = workResult.getSubflowWorks().get(0);
        action.setWorkId(subflow.getSubworkid());
    }

    /**
     * 设置子流程ID
     */
    @Override
    protected String getSubFlowId() {

        String subFlowId = null;
        List<SubFlow> subFlows = action.getSubFlows();
        if (subFlows == null || subFlows.isEmpty()) {
            return subFlowId;
        }

        for (SubFlow subFlow : subFlows) {
            if (Boolean.parseBoolean(subFlow.getIsSelect())) {
                subFlowId = subFlow.getSubFlowId();
                break;
            }
        }
        return subFlowId;
    }

    /**
     * 获取启动子流程列表
     *
     */
    protected List<SubFlow> subflows() {

        List<SubFlow> subFlows = Lists.newArrayList();
        //List<IXMLSubFlowInfo> subFlowInfos = workResult.getSubflows();
        List<INodeSubflow> subFlowInfos = workResult.getNodeSubflows();
        if (subFlowInfos != null && !subFlowInfos.isEmpty()) {
            for (IXMLSubFlowInfo subFlowInfo : subFlowInfos) {
                SubFlow subFlow = new SubFlow();
                subFlow.setSubFlowId(subFlowInfo.getSubFlowId());
                subFlow.setSubFlowName(subFlowInfo.getSubFlowName());
                subFlow.setIsStarted("false");
                subFlow.setIsSelect("false");
                subFlow.setAuthors(getFlowAuthor());
                startedSubflows(subFlow);
                subFlows.add(subFlow);
            }
        }
        return subFlows;
    }

    protected FlowAuthor getFlowAuthor() {

        return null;
    }

    /**
     * 获取已启动子流程实例列表
     * 
     * @param subFlow
     */
    protected void startedSubflows(final SubFlow subFlow) {

        final Map<String, String> subWorks = Maps.newHashMap();
        List<DBRelationSubflow> relationSubflows = workResult.getSubflowWorks();
        Collection<DBRelationSubflow> filterList = Collections2.filter(relationSubflows,
                new Predicate<DBRelationSubflow>() {

                    @Override
                    public boolean apply(DBRelationSubflow relationSubflow) {

                        if (Objects.equal(subFlow.getSubFlowId(), relationSubflow.getSubflowid())) {
                            subWorks.put(relationSubflow.getSubworkid(), relationSubflow.getTitle());
                            subFlow.setIsStarted("true");
                            return true;
                        }
                        return false;
                    }
                });
        if (!filterList.isEmpty()) {
            subFlow.setSubWorks(subWorks);
        }
    }
}
