package com.horizon.workflow.support.action;

import java.util.List;
import java.util.Map;

import com.horizon.common.base.Joiner;
import com.horizon.common.base.Objects;
import com.horizon.common.collect.Lists;
import com.horizon.core.HorizonCore;
import com.horizon.utils.StringUtil;
import com.horizon.wf.definition.pub.node.INodeSubflow;
import com.horizon.wf.definition.xml.IXMLSubFlowInfo;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.workflow.support.model.FlowAuthor;
import com.horizon.workflow.support.model.SubFlow;

/**
 * 子流程提交操作（选择节点，及设置办理人操作）
 * 
 * @author mwr
 *
 */
public class SubflowAuthorsSubmitAction extends SubflowSubmitAction {

    /**
     * 设置子流程节点办理人
     * 
     */
    @Override
    protected void setSelectAuthor() {

        List<SubFlow> subFlows = action.getSubFlows();
        if (subFlows == null || subFlows.isEmpty()) {
            return;
        }
        List<String> subflowIds = Lists.newArrayList();
        for (SubFlow subFlow : subFlows) {
            if (Objects.equal(subFlow.getIsSelect(), "true")) {
                FlowAuthor flowAuthor = subFlow.getAuthors();
                Map<String, String> authorMap = workParaBean.getSelectAuthorMap();
                Map<String, String> authorNameMap = workParaBean.getSelectAuthorNameMap();
                authorMap.put(subFlow.getSubFlowId(), flowAuthor.getSelectAuthor());
                authorNameMap.put(subFlow.getSubFlowId(), flowAuthor.getSelectAuthorName());
                subflowIds.add(subFlow.getSubFlowId());
            }
        }
        workParaBean.setSelectSubFlowid(Joiner.on(";").join(subflowIds));
    }

    /**
     * 获取启动子流程列表
     *
     */
    @Override
    protected List<SubFlow> subflows() {

        List<SubFlow> subFlows = Lists.newArrayList();
       // List<IXMLSubFlowInfo> subFlowInfos = workResult.getSubflows();
        List<INodeSubflow> subFlowInfos = workResult.getNodeSubflows();
        if (subFlowInfos != null && !subFlowInfos.isEmpty()) {
            for (IXMLSubFlowInfo subFlowInfo : subFlowInfos) {
                SubFlow subFlow = new SubFlow();
                subFlow.setSubFlowId(subFlowInfo.getSubFlowId());
                subFlow.setSubFlowName(subFlowInfo.getSubFlowName());
                subFlow.setIsStarted("false");
                subFlow.setIsSelect("false");
                subFlow.setSelectType(getSelectType());
                subFlow.setAuthors(getFlowAuthor());
                startedSubflows(subFlow);
                subFlows.add(subFlow);
            }
        }
        return subFlows;
    }
    @Override
    protected FlowAuthor getFlowAuthor() {

        FlowAuthor flowAuthor = new FlowAuthor();
        flowAuthor.setAuthorId(StaticVarExtend.AUTH_AUTHOR);
        flowAuthor.setAuthorName(getAuhorName(StaticVarExtend.AUTH_AUTHOR));
        flowAuthor.setSelectType(getSelectType());
        flowAuthor.setIsUser("false");
        flowAuthor.setIsFree("true");
        flowAuthor.setIsDefUser("false");
        flowAuthor.setIsSelect("true");
        return flowAuthor;
    }

    private String getSelectType() {

       // boolean isMuiltSubFlow = workResult.getCurNode().getSubFlowMuilt();
        boolean isMuiltSubFlow = workResult.getCurFlowNode().getSubFlowMuilt();
        return (isMuiltSubFlow) ? "checkbox" : "radio";
    }
    @Override
    protected boolean autoOpen() {
        boolean reOpen=false;
        String subFlowIds=workParaBean.getSelectSubFlowid();
        if(StringUtil.hasValue(subFlowIds)){
            String[] subFlowIdArr=subFlowIds.split(";");
            for (String subFlowId:subFlowIdArr) {
                if(!StringUtil.hasValue(subFlowId))continue;
                Map<String,String> authorMap= workParaBean.getSelectAuthorMap();
                String authId=authorMap.get(subFlowId);
                if(!StringUtil.hasValue(authId) || authId.indexOf(HorizonCore.USER_ID.value())>=0){
                    reOpen=true;
                    break;
                }
            }
        }
        return reOpen;
    }
}
