package com.horizon.workflow.support.action;

import java.util.List;
import java.util.Map;

import com.horizon.common.base.Objects;
import com.horizon.common.collect.Maps;
import com.horizon.language.Hi18n;
import com.horizon.utils.HorizonPorps;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.xml.IXmlUser;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.workflow.support.model.FlowAction;
import com.horizon.workflow.support.model.FlowAuthor;
import com.horizon.workflow.support.model.FlowNextNode;
import com.horizon.workflow.support.util.ActionUtil;

/**
 * 退回操作可以选择办理人
 * 
 * @author mwr
 *
 */
public class RejectSubmitAction extends ActionBaseStrategy {

    public FlowAction actionDo() {

        openRejectSelectAuthor();
        int status = operator();
        switch (status) {
            case StaticVarExtend.F_STATUS_SelectAuthor:
                action.setNextNodes(getNextNodes());
                action.setOperateMsg(message());
                action.setOperateFlag(StaticVarExtend.Submit_Flag_Commit);
                break;
            case StaticVarExtend.F_STATUS_SelectNode:
                setSelectNode();
                break;
            case StaticVarExtend.F_STATUS_Success:
                action.setAlert("true");
                action.setOperateStatus("success");
                action.setOperateMsg(message());
                break;
            default:
                action.setOperateMsg(message());
                action.setOperateStatus("error");

                break;
        }
        action.setTrackId(trackId());
        action.setWorkId(workId());
        return action;
    }

    /**
     * 启用退回操作时，选择办理人
     */
    protected void openRejectSelectAuthor() {

        String isTrue = HorizonPorps.getConfig("workflow.reject.selectAuthor");
        if (Objects.equal(isTrue, "true")) {
            workParaBean.setSelAuthorForReject(Boolean.parseBoolean(isTrue));
        }
        workParaBean.setSubmitflag(StaticVarExtend.Submit_Flag_Commit);
    }

    /*
     * 重写父类方法，设置下一节点办理人，只设置主办人（Author）
     * 
     * @see
     * com.horizon.workflow.support.action.ActionBaseStrategy#getNextAuthors(com
     * .horizon.wf.core.node.INextNode)
     */
    @Override
    protected Map<String, FlowAuthor> getNextNodeAuthors(FlowNextNode flowNextNode) {

        Map<String, FlowAuthor> authors = Maps.newHashMap();
        //List<IXmlUser> xmlUsers = getIXmlUsers(flowNextNode);
        List<INodeAuthUser> xmlUsers = getNodeAuthUsers(flowNextNode);
        FlowAuthor flowAuthor = null;
        if (xmlUsers != null) {
            for (IXmlUser xmlUser : xmlUsers) {
                String authorId = xmlUser.getAuthName();
                if (Objects.equal(authorId, StaticVarExtend.AUTH_AUTHOR)) {
                    flowAuthor = newFlowAuthor(xmlUser, flowNextNode);
                    authors.put(authorId, flowAuthor);
                }
            }
            flowNextNode.setIsShowTabs("false");
        }
        return authors;
    }
    @Override
    protected void setSelectAuthors(FlowAuthor flowAuthor, String authorKey) {
        String authorId = getAuthorIds(authorKey);
        String selectType = "radio";
        if (Objects.equal("checkbox", flowAuthor.getSelectType())) {
            selectType = "checkbox";
            flowAuthor.setSelectAuthor(authorId);
            flowAuthor.setSelectAuthorName(getAuthorName(authorId));
        }
        flowAuthor.setIsFree("true");
        flowAuthor.setIsSelect("true");
        flowAuthor.setSelectType(selectType);
        flowAuthor.setIsDefUser("true");
        flowAuthor.setInitAuthor(ActionUtil.getAuthorMultimap(authorId, false));
    }
    @Override
    protected String concatKey(String nodeId, String authorId) {

        return nodeId + "-Author";// + workResult.getCurUser().getAuthName();
    }

    /**
     * 选择节点
     */
    protected void setSelectNode() {

        // 设置节点
        List<FlowNextNode> nextNodes = getNextNodes();
        if (nextNodes == null || nextNodes.isEmpty()) {
            action.setOperateMsg(Hi18n.getVal(LANGUAGE_WORKFLOW,"notGetFlowNodeList"));
            action.setOperateStatus("error");
        } else {
            action.setNextNodes(getNextNodes());
            action.setOperateMsg(message());
        }
    }

    private String getAuthorIds(String authorKey) {

        String authorId = getInitAuthor(authorKey);
        return ActionUtil.replacePrefix(authorId);
    }
}
