package com.horizon.workflow.support.action;

import java.util.List;
import java.util.Map;

import com.horizon.common.base.Objects;
import com.horizon.common.collect.Maps;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.xml.IXmlUser;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.workflow.support.model.FlowAction;
import com.horizon.workflow.support.model.FlowAuthor;
import com.horizon.workflow.support.model.FlowNextNode;
import com.horizon.workflow.support.util.ActionUtil;

/**
 * 减签操作
 * 
 * @author mwr
 *
 */
public class ReduceSubmitAction extends ActionBaseStrategy {

    @Override
    public FlowAction actionDo() {

        int status = operator();
        switch (status) {
            case StaticVarExtend.F_STATUS_SelectAuthor:
                action.setNextNodes(getNextNodes());
                action.setOperateMsg(message());
                action.setOperateFlag(StaticVarExtend.Submit_Flag_Commit);
                break;
            case StaticVarExtend.F_STATUS_Success:
                action.setOperateStatus("success");
                action.setOperateMsg(message());
                break;
            default:
                action.setOperateMsg(message());
                action.setOperateStatus("error");

                break;
        }
        action.setTrackId(trackId());
        action.setWorkId(workId());
        return action;
    }

    /*
     * 重写父类方法，设置下一节点办理人，只设置主办人（Author）
     * 
     * @see
     * com.horizon.workflow.support.action.ActionBaseStrategy#getNextAuthors(com
     * .horizon.wf.core.node.INextNode)
     */
    @Override
    protected Map<String, FlowAuthor> getNextNodeAuthors(FlowNextNode flowNextNode) {

        Map<String, FlowAuthor> authors = Maps.newHashMap();
        //List<IXmlUser> xmlUsers = getIXmlUsers(flowNextNode);
        List<INodeAuthUser> xmlUsers = getNodeAuthUsers(flowNextNode);
        FlowAuthor flowAuthor = null;
        for (IXmlUser xmlUser : xmlUsers) {
            String authorId = xmlUser.getAuthName();
            if (Objects.equal(authorId, StaticVarExtend.AUTH_AUTHOR)) {
                flowAuthor = newFlowAuthor(xmlUser, flowNextNode);
                authors.put(authorId, flowAuthor);
            }
        }
        return authors;
    }
    @Override
    protected void setSelectAuthors(FlowAuthor flowAuthor, String authorKey) {

        String authorId = getAuthorIds();
        flowAuthor.setIsFree("false");
        flowAuthor.setIsSelect("true");
        flowAuthor.setSelectType("checkbox");
        flowAuthor.setSelectAuthor(authorId);
        flowAuthor.setIsDefUser("true");
        flowAuthor.setInitAuthor(ActionUtil.getAuthorMultimap(authorId, false));
        flowAuthor.setSelectAuthorName(getAuthorName(authorId));
    }

    /**
     * 父类方法作用：获得节点的办理时限 重写父类方法，减签操作没有办理时限
     * 
     * @param nextNode
     *            节点数据对象
     * @return
     */
    @Override
    protected int[] getNextLimit(INextNode nextNode) {

        return null;
    }

    private String getAuthorIds() {

        String tmpKey = workResult.getCurUser().getAuthName();
        Map<String, String> tempAuthors = workResult.getTmpAuthorMap();
        String authorId = tempAuthors.get(tmpKey);
        authorId = ActionUtil.replacePrefix(authorId);
        return authorId;
    }
    @Override
    protected String concatKey(String nodeId, String authorId) {

        return nodeId + "-" + action.getAuthorKey();
    }
}
