package com.horizon.workflow.support.action;

import java.util.List;
import java.util.Map;

import com.horizon.common.base.Objects;
import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.language.Hi18n;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.workflow.support.model.FlowAction;
import com.horizon.workflow.support.model.FlowAuthor;
import com.horizon.workflow.support.model.FlowNextNode;

/**
 * 提交操作(内部循环)
 * 
 * @author mwr
 *
 */
public class InnerSubmitAction extends ActionBaseStrategy {

    @Override
    public FlowAction actionDo() {

        if (Objects.equal(action.getOperateFlag(), StaticVarExtend.Submit_Flag)) {
            action.setNextNodes(getNextNodes());
            action.setOperateMsg(Hi18n.getVal(LANGUAGE_WORKFLOW,"notSelectUser"));
            action.setOperateFlag(StaticVarExtend.Submit_Flag_Commit);
        } else {
            operateCommit();
        }
        return action;
    }

    private void operateCommit() {

        int status = operator();
        if(status==StaticVarExtend.F_STATUS_Success){
            action.setOperateMsg(message());
            action.setOperateStatus("success");
        } else {
            action.setOperateMsg(message());
            action.setOperateStatus("error");
        }
        action.setTrackId(trackId());
        action.setWorkId(workId());
    }
    @Override
    protected List<FlowNextNode> getNextNodes() {
        String selectName = action.getOperateText() + " (" + action.getNodeName() + ")";
        FlowNextNode flowNextNode = new FlowNextNode();
        flowNextNode.setNodeId(action.getNodeId());
        flowNextNode.setNodeName(action.getNodeName());
        flowNextNode.setNodeKey(action.getNodeId());
        flowNextNode.setSelectId(action.getNodeId());
        flowNextNode.setSelectName(selectName);
        flowNextNode.setIsSelect("true");
        flowNextNode.setIsDone("false");
        flowNextNode.setNodeGroup("");
        flowNextNode.setIsShowTabs("false");
        flowNextNode.setAuthors(getNextNodeAuthors(flowNextNode));
        return  Lists.newArrayList(flowNextNode);
    }

    /*
     * 重写父类方法，设置下一节点办理人，只设置主办人（Author）
     * 
     * @see
     * com.horizon.workflow.support.action.ActionBaseStrategy#getNextAuthors(com
     * .horizon.wf.core.node.INextNode)
     */
    @Override
    protected Map<String, FlowAuthor> getNextNodeAuthors(FlowNextNode flowNextNode) {

        Map<String, FlowAuthor> authors = Maps.newHashMap();

        FlowAuthor flowAuthor = new FlowAuthor();
        flowAuthor.setAuthorId(StaticVarExtend.AUTH_AUTHOR);
        flowAuthor.setAuthorName(getAuhorName(StaticVarExtend.AUTH_AUTHOR));
        flowAuthor.setSelectType("radio");
        flowAuthor.setIsUser("false");
        flowAuthor.setIsFree("true");
        flowAuthor.setFreeArea(workResult==null?"":workResult.getCurFlowNode()
                .getParticipantsUser(StaticVarExtend.AUTH_AUTHOR).getFreeSelectArea());
        flowAuthor.setIsDefUser("false");
        flowAuthor.setIsSelect("true");
        authors.put(StaticVarExtend.AUTH_AUTHOR, flowAuthor);
        return authors;
    }

}
