package com.horizon.workflow.support.action;

import com.horizon.common.base.Objects;
import com.horizon.common.collect.Maps;
import com.horizon.utils.StringUtil;
import com.horizon.workflow.support.model.FlowAction;
import com.horizon.workflow.support.model.FlowAuthor;
import com.horizon.workflow.support.model.FlowNextNode;
import com.horizon.workflow.support.model.FreeNextNode;
import java.util.Map;

/**
 * 流程自由提交操作（submit）
 *
 * @author mwr
 */
public class FreeSubmitAction extends DefaultSubmitAction {

    @Override
    public FlowAction actionDo() {

        FreeNextNode freeNextNode = action.getFreeNode();
        if (freeNextNode != null && action.getNextNodes() == null) {
            workParaBean.setNextNodeName(freeNextNode.getNodeName());
            String axisTypeX = freeNextNode.getAxisTypeX();
            String strAxisX = freeNextNode.getAxisX();
            strAxisX = (StringUtil.hasValue(strAxisX)) ? strAxisX : "0";
            int iAxisX = Integer.parseInt(strAxisX);
            setAxisX(axisTypeX, iAxisX);

            String axisTypeY = freeNextNode.getAxisTypeY();
            String strAxisY = freeNextNode.getAxisY();
            strAxisY = (StringUtil.hasValue(strAxisY)) ? strAxisY : "0";
            int iAxisY = Integer.parseInt(strAxisY);
            setAxisY(axisTypeY, iAxisY);
        }
        // 调用父类的方法执行正常的提交操作
        // 操作完成之后清空自由节点信息
        action = super.actionDo();
        Map<String, FlowAuthor> authors = Maps.newHashMap();
        action.getFreeNode().setAuthors(authors);
        return action;
    }
    @Override
    protected void setSelectAuthor() {

        if (action.getFreeNode() != null && action.getNextNodes() == null) {
            FreeNextNode freeNextNode = action.getFreeNode();
            Map<String, FlowAuthor> authors = freeNextNode.getAuthors();
            Map<String, String> authorMap = workParaBean.getSelectAuthorMap();
            Map<String, String> authorNameMap = workParaBean.getSelectAuthorNameMap();
            setNextNodeTimelimit(freeNextNode);
            for (Map.Entry<String, FlowAuthor> entry : authors.entrySet()) {
                String authKey = "Node-"+entry.getKey();
                FlowAuthor author = entry.getValue();
                authorMap.put(authKey, author.getSelectAuthor());
                authorNameMap.put(authKey, author.getSelectAuthorName());
            }
        } else {
            super.setSelectAuthor();
        }
    }
    protected void setNextNodeTimelimit(FlowNextNode nextNode) {

        String limit = nextNode.getTimeLimit();
        String limitType = nextNode.getTimeLimitType();
        if (StringUtil.hasValue(limit) && StringUtil.hasValue(limitType)) {
            limit = limitType + ";" + limit;
            workParaBean.putNodeLimitSetMap("Node", limit);
        }
    }
    /**
     * 设置横坐标
     *
     * @param axisTypeX 横坐标类型
     * @param iAxisX    横坐标
     */
    private void setAxisX(String axisTypeX, int iAxisX) {
        if (Objects.equal(axisTypeX, "relative-left")) {
            // 向左相对移动，取负数
            iAxisX = -iAxisX;
            workParaBean.setNextNodePosX(iAxisX);
        } else if (Objects.equal(axisTypeX, "relative-right")) {
            workParaBean.setNextNodePosX(iAxisX);
        } else if (Objects.equal(axisTypeX, "absolute-x")) {
            workParaBean.setNextNodeX(iAxisX);
        }
    }

    /**
     * 设置纵坐标
     *
     * @param axisTypeY 纵坐标类型
     * @param iAxisY    坐标值
     */
    private void setAxisY(String axisTypeY, int iAxisY) {
        if (Objects.equal(axisTypeY, "relative-top")) {
            // 向上相对移动，取负数
            iAxisY = -iAxisY;
            workParaBean.setNextNodeY(iAxisY);
        } else if (Objects.equal(axisTypeY, "relative-bottom")) {
            workParaBean.setNextNodeY(iAxisY);
        } else if (Objects.equal(axisTypeY, "absolute-y")) {
            workParaBean.setNextNodeY(iAxisY);
        }
    }

}
