package com.horizon.workflow.support.action;

import static com.horizon.wf.global.StaticVarExtend.OPERATOR_FUNNAME_HUIQIAN;
import static com.horizon.wf.global.StaticVarExtend.OPERATOR_FUNNAME_MOVE;
import static com.horizon.wf.global.StaticVarExtend.OPERATOR_FUNNAME_REPLACE_AUTHOR;

import java.util.List;
import java.util.Map;

import com.horizon.common.base.Objects;
import com.horizon.common.collect.Maps;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.xml.IXmlUser;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.workflow.support.model.FlowAction;
import com.horizon.workflow.support.model.FlowAuthor;
import com.horizon.workflow.support.model.FlowNextNode;

/**
 * 提交操作
 * 
 * @author mwr
 *
 */
public class AuthorSubmitAction extends ActionBaseStrategy {

    @Override
    public FlowAction actionDo() {

        int status = operator();
        switch (status) {
            case StaticVarExtend.F_STATUS_SelectAuthor:
                action.setNextNodes(getNextNodes());
                action.setOperateMsg(message());
                action.setOperateFlag(StaticVarExtend.Submit_Flag_Commit);
                break;

            case StaticVarExtend.F_STATUS_Success:
                String submitFlag = submitFlag();
                action.setOperateMsg(message());
                if (Objects.equal(submitFlag, StaticVarExtend.Submit_Flag)) {
                    action.setNextNodes(getNextNodes());
                    action.setOperateFlag(StaticVarExtend.Submit_Flag_Commit);
                } else {
                    action.setOperateStatus("success");
                }
                break;
            default:
                action.setOperateMsg(message());
                action.setOperateStatus("error");
                break;

        }
        action.setTrackId(trackId());
        action.setWorkId(workId());
        return action;
    }

    /*
     * 重写父类方法，设置下一节点办理人，只设置主办人（Author）
     * 
     * @see
     * com.horizon.workflow.support.action.ActionBaseStrategy#getNextAuthors(com
     * .horizon.wf.core.node.INextNode)
     */
    @Override
    protected Map<String, FlowAuthor> getNextNodeAuthors(FlowNextNode flowNextNode) {

        Map<String, FlowAuthor> authors = Maps.newHashMap();
        //List<IXmlUser> xmlUsers = getIXmlUsers(flowNextNode);
        List<INodeAuthUser> xmlUsers = getNodeAuthUsers(flowNextNode);
        FlowAuthor flowAuthor = null;
        for (IXmlUser xmlUser : xmlUsers) {
            String authorId = xmlUser.getAuthName();
            if (Objects.equal(authorId, StaticVarExtend.AUTH_AUTHOR)) {
                flowAuthor = newFlowAuthor(xmlUser, flowNextNode);
                authors.put(authorId, flowAuthor);
            }
        }
        flowNextNode.setIsShowTabs("false");
        return authors;
    }
    @Override
    protected void setSelectAuthors(FlowAuthor flowAuthor, String authorKey) {

        flowAuthor.setIsFree("true");
        flowAuthor.setFreeArea(workResult.getCurFlowNode()
                .getParticipantsUser(StaticVarExtend.AUTH_AUTHOR).getFreeSelectArea());
        flowAuthor.setIsSelect("true");
        flowAuthor.setSelectType(getSelectType());
    }
    @Override
    protected boolean isOnlySelectUser(String authorControl) {

        boolean isOnly = super.isOnlySelectUser(authorControl);
        String actionName = workResult.getWorkParaBean().getFunname();
        if (Objects.equal(actionName.toLowerCase(), OPERATOR_FUNNAME_HUIQIAN.toLowerCase())) {
            // 会签操作只允许选择人
            isOnly = true;
        }
        return isOnly;
    }

    /**
     * 父类方法作用：获得节点的办理时限 重写父类方法，减签操作没有办理时限
     * 
     * @param nextNode
     *            节点数据对象
     * @return
     */
    @Override
    protected int[] getNextLimit(INextNode nextNode) {

        return null;
    }

    /**
     * 转办做特殊处理，只能做单选
     * 
     * @return
     */
    private String getSelectType() {

        String actionName = workResult.getWorkParaBean().getFunname();
        String type = "checkbox";
        if (Objects.equal(actionName.toLowerCase(), OPERATOR_FUNNAME_MOVE.toLowerCase())) {
            type = "radio";
        }
        if (Objects.equal(actionName.toLowerCase(), OPERATOR_FUNNAME_REPLACE_AUTHOR.toLowerCase())) {
            // 替换办理人操作，如果是单人节点只能选择单人
            int singleType = 1;
            int selectType = workResult.getNextSelectTypeByNodeid(workResult.getCurNode().getNodeid());
            if (Objects.equal(selectType, singleType)) {
                type = "radio";
            }
        }
        return type;
    }
}
