package com.horizon.workflow.support.action;

import com.horizon.wf.bean.WorkParaBean;
import com.horizon.workflow.support.init.WorkflowOperateInit;
import com.horizon.workflow.support.model.FlowAction;

import java.util.Map;

/**
 * 流程操作交互容器
 *
 * @author mwr
 */
public class ActionContext {

    /**
     * 执行流程操作
     *
     * @param workParaBean 流程操作参数bean
     * @return
     */
    public ActionStrategy getActionStrategy(WorkParaBean workParaBean, FlowAction action) {

        Map<String, String> varMaps = action.getFlowVars();
        workParaBean.setNextNodeId(action.getNextNodeId());
        workParaBean.setActionClass(action.getOperateClazz());
        workParaBean.setSubmitflag(action.getOperateFlag());
        workParaBean.setFunname(action.getOperate());
        workParaBean.setActionname(action.getOperateText());
        if (varMaps != null && !varMaps.isEmpty()) {
            // 设置流程变量
            workParaBean.getFlowVarMap().putAll(varMaps);
        }
        ActionBaseStrategy strategy = WorkflowOperateInit.getActionBaseStrategy(action.getOperate());
        strategy.setWorkParaBean(workParaBean);
        strategy.setAction(action);
        return strategy;
    }

}
