package com.horizon.workflow.support.action;

import com.horizon.common.base.*;
import com.horizon.common.collect.Collections2;
import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.core.HorizonCore;
import com.horizon.language.Hi18n;
import com.horizon.profile.AppConfig;
import com.horizon.third.Organization;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.third.adapter.WorkflowBaseAdapther;
import com.horizon.third.entity.User;
import com.horizon.third.init.WorkflowAdapterInit;
import com.horizon.utils.HorizonPorps;
import com.horizon.utils.StringUtil;
import com.horizon.wf.IWorkResult;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.xml.IXmlUser;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.workflow.support.init.WorkflowOperateInit;
import com.horizon.workflow.support.model.FlowAction;
import com.horizon.workflow.support.model.FlowAuthor;
import com.horizon.workflow.support.model.FlowNextNode;
import com.horizon.workflow.support.util.ActionUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 流程操作基类
 *
 * @author mwr
 *
 */
public abstract class ActionBaseStrategy implements ActionStrategy {
    /**
     *
     * 语言文件
     */
    protected static final String LANGUAGE_WORKFLOW = "workflow";

    /**
     * 流程执行结果集
     */
    protected IWorkResult workResult;

    /**
     * 流程操作需要的参数对象
     */
    protected WorkParaBean workParaBean;

    /**
     * 流程结束后返回结果
     */
    protected FlowAction action;

    /**
     * 设置前后台交互数据对象
     *
     * @param action
     *            前后台交互数据对象
     */
    protected void setAction(FlowAction action) {

        this.action = action;
    }

    /**
     * 设置流程操作参数
     *
     * @param workParaBean
     *            流程操作参数对象
     */
    protected void setWorkParaBean(WorkParaBean workParaBean) {

        this.workParaBean = workParaBean;
    }

    /**
     * 由子类实现
     *
     * @return
     */
    protected String getSubFlowId() {

        return null;
    }

    /**
     * 流程操作结束信息
     *
     * @return
     */
    protected String message() {

        return workResult.getBackMsg();
    }

    /**
     * 流程提交标识
     *
     * @return
     */
    protected String submitFlag() {

        return workResult.getWorkParaBean().getSubmitflag();
    }

    /**
     * 流程当前操作人
     *
     * @return
     */
    protected String getcurUserId() {

        return workResult.getCurUser().getUserid();
    }

    /**
     * 流程提交操作
     *
     * @return
     */
    protected int operator() {

        workParaBean.setSelectSubFlowid(getSubFlowId());
        setSelectUsers(this);
        IWorkflowOperator workflow = WorkflowFactory.getWorkflowOperator();
        //IWorkflowOperator workflow = WorkflowFactory.getWorkFlowOperator();
        workResult = workflow.operator(workParaBean);
        int status = workResult.getResult();
        action.setStatus(status);
        return status;
    }

    /**
     * 当IWorkResult返回结果中，需要选择节点时，result=2
     *
     * @return
     */
    protected List<FlowNextNode> getNextNodes() {

        List<INextNode> nextNodes = workResult.getNextNodes();
        Map<String, FlowAuthor> flowAuthors = null;
        List<FlowNextNode> flowNextNodes = Lists.newArrayList();
        for (INextNode nextNode : nextNodes) {
            FlowNextNode flowNextNode = newFlowNextNode(nextNode);
            flowAuthors = getNextNodeAuthors(flowNextNode);
            flowNextNode.setAuthors(flowAuthors);
            flowNextNodes.add(flowNextNode);
        }
        return flowNextNodes;
    }

    /**
     * 用于执行操作时，下一节点信息
     *
     * @param nextNode
     *            用于执行操作时,选择下一节点
     * @return
     */
    protected FlowNextNode newFlowNextNode(INextNode nextNode) {

        int[] limit = getNextLimit(nextNode);
        FlowNextNode flowNextNode = new FlowNextNode();
        boolean isSelected = nextNode.isSelected();
        boolean isDoneNode = nextNode.isDoneNode();
        String nextSelectType = getNextNodeGroup(nextNode);
        flowNextNode.setNodeId(nextNode.getNodeid());
        flowNextNode.setNodeName(nextNode.getNodename());
        flowNextNode.setNodeKey(nextNode.getKeyid());
        flowNextNode.setSelectId(getSelectIds(nextNode.getSelectedIdStr()));
        flowNextNode.setSelectName(getSelectNodeName(nextNode.getShowName()));
        flowNextNode.setIsSelect(String.valueOf(isSelected));
        flowNextNode.setIsDone(String.valueOf(isDoneNode));
        flowNextNode.setNodeGroup(nextSelectType);
        flowNextNode.setNodeStatus(String.valueOf(nextNode.getInitResult()));
        IFlowNode flowNode = nextNode.getFlowNode();
        if(flowNode != null){
            flowNextNode.setMemo(flowNode.getNodeMemo());
        }
//        if(null != nextNode.getXmlNode()){
//            flowNextNode.setMemo(nextNode.getXmlNode().getNodeMemo());
//        }
        if (limit != null && limit.length >= 2) {
            // 设置节点办理时限的默认值
            flowNextNode.setTimeLimit(String.valueOf(limit[1]));
            flowNextNode.setTimeLimitType(String.valueOf(limit[0]));
        }
        if (flowNextNode.getNodeId().startsWith("End")) {
            flowNextNode.setIsShowTabs("true");
        }
        return flowNextNode;

    }

    /**
     * 获得节点的办理时限
     *
     * @param nextNode
     *            节点数据对象
     * @return
     */
    protected int[] getNextLimit(INextNode nextNode) {

        int[] limit = workParaBean.getNodeLimitByActionSet(nextNode.getNodeid());
        if (limit == null) {
            IFlowNode flowNode = nextNode.getFlowNode();
            limit = (flowNode != null) ? flowNode.getNodeLimit() : limit;
//            IXmlNode xmlNode = nextNode.getXmlNode();
//            limit = (xmlNode != null) ? xmlNode.getNodeLimit() : limit;
        }
        return limit;
    }

    /**
     * 当IWorkResult返回结果中，需要选择人员时，result=4
     *
     * @param flowNextNode
     *            下一节点对象
     * @return
     */
    protected Map<String, FlowAuthor> getNextNodeAuthors(FlowNextNode flowNextNode) {

        Map<String, FlowAuthor> authors = Maps.newHashMap();
        //List<IXmlUser> xmlUsers = getIXmlUsers(flowNextNode);
        List<INodeAuthUser> xmlUsers = getNodeAuthUsers(flowNextNode);
        FlowAuthor flowAuthor = null;
        if (xmlUsers != null && !xmlUsers.isEmpty()) {
            for (IXmlUser xmlUser : xmlUsers) {
                String authorId = xmlUser.getAuthName();
                flowAuthor = newFlowAuthor(xmlUser, flowNextNode);
                authors.put(authorId, flowAuthor);
            }
        }
        return authors;
    }

    /**
     * 获取已选择节点的办理人
     *
     * @param flowNextNode
     *            下一节点对象
     */
//    protected List<IXmlUser> getIXmlUsers(final FlowNextNode flowNextNode) {
//
//        List<INextNode> nextNodes = workResult.getNextNodes();
//        Collection<INextNode> filterList = Collections2.filter(nextNodes, new Predicate<INextNode>() {
//
//            @Override
//            public boolean apply(INextNode nextNode) {
//
//                if (nextNode.isSelected()) {
//                    return Objects.equal(nextNode.getNodeid(), flowNextNode.getNodeId());
//                }
//                return false;
//            }
//        });
//        List<IXmlUser> xmlUsers = null;
//        if (!filterList.isEmpty()) {
//            Iterator<INextNode> it = filterList.iterator();
//            IXmlNode xmlNode = it.next().getXmlNode();
//            xmlUsers = xmlNode.getParticipantsUserList();
//        }
//        return xmlUsers;
//    }

    /**
     * 获取已选择节点的办理人
     *
     * @param flowNextNode
     *            下一节点对象
     */
    protected List<INodeAuthUser> getNodeAuthUsers(final FlowNextNode flowNextNode) {

        List<INextNode> nextNodes = workResult.getNextNodes();
        Collection<INextNode> filterList = Collections2.filter(nextNodes, new Predicate<INextNode>() {

            @Override
            public boolean apply(INextNode nextNode) {

                if (nextNode.isSelected()) {
                    return Objects.equal(nextNode.getNodeid(), flowNextNode.getNodeId());
                }
                return false;
            }
        });
        List<INodeAuthUser> nodeAuthUsers = null;
        if (!filterList.isEmpty()) {
            Iterator<INextNode> it = filterList.iterator();
            IFlowNode flowNode = it.next().getFlowNode();
            nodeAuthUsers = flowNode.getParticipantsUserList();
        }
        return nodeAuthUsers;
    }

    /**
     * 用于执行操作时，下一节点参与者
     *
     * @param xmlUser
     *            流程参与者
     * @param flowNextNode
     *            用于执行操作时,选择下一节点
     * @return
     */
    protected FlowAuthor newFlowAuthor(IXmlUser xmlUser, FlowNextNode flowNextNode) {

        FlowAuthor flowAuthor = new FlowAuthor();
        String nodeKey = flowNextNode.getNodeKey();
        String nodeId = flowNextNode.getNodeId();

        String participantId = xmlUser.getAuthName();
        String participantName = xmlUser.getAuthCnName();
        String authorControl = xmlUser.getControlAttribute();

        String authKey = concatKey(nodeKey, participantId);
        boolean isOnlyUser = isOnlySelectUser(authorControl);
        boolean isFreeUser = isFreeSelectUser(authorControl);
        boolean isDefUser = isDefAuthors(authKey);
        String selectType = getSelectType(nodeId, participantId);

        String varStr = xmlUser.getFlowVar();
        flowAuthor.setAuthorFlowVar(varStr);
        flowAuthor.setAuthorId(participantId);
        flowAuthor.setAuthorName(participantName);
        flowAuthor.setSelectType(selectType);
        flowAuthor.setIsUser(String.valueOf(isOnlyUser));
        flowAuthor.setIsFree(String.valueOf(isFreeUser));
        flowAuthor.setFreeArea(xmlUser.getFreeSelectArea());
        flowAuthor.setIsDefUser(String.valueOf(isDefUser));
        setSelectAuthors(flowAuthor, authKey);
        return flowAuthor;
    }

    /**
     * 计算下一节点选择是单选，还是多选
     * <p>
     * {@code INextNode.getGroupName()}有值为多选
     * </p>
     * <p>
     * 否则，为单选
     * </p>
     *
     * @param nextNode
     * @return
     */
    protected String getNextNodeGroup(INextNode nextNode) {

        return StringUtil.null2Empty(nextNode.getGroupName());
    }

    protected void setSelectAuthors(FlowAuthor flowAuthor, String authorKey) {

        String selectAuthor = getSelectAuthor(authorKey);
        String initAuthor = getInitAuthor(authorKey);
        boolean isSelect = true;
        if (StringUtil.hasValue(initAuthor)) {
            selectAuthor = initAuthor;
            List<String> list = Splitter.on(";").omitEmptyStrings().splitToList(selectAuthor);
            if (Objects.equal("radio", flowAuthor.getSelectType())) {
                if (list.size() == 1) {
                    selectAuthor = initAuthor;
                    isSelect = false;
                } else {
                    selectAuthor = null;
                }
            }
            if (Boolean.parseBoolean(flowAuthor.getIsUser())) {
                selectAuthor = null;
                isSelect = true;
            }
        } else if (StringUtil.hasValue(selectAuthor)) {
            isSelect = false;

        }
        boolean isOnlyUser = Boolean.parseBoolean(flowAuthor.getIsUser());
        String selectAuthorName = getAuthorName(selectAuthor);
        flowAuthor.setInitAuthor(ActionUtil.getAuthorMultimap(initAuthor, isOnlyUser));
        flowAuthor.setSelectAuthor(selectAuthor);
        flowAuthor.setSelectAuthorName(selectAuthorName);
        flowAuthor.setIsSelect(String.valueOf(isSelect));
        if (!Boolean.parseBoolean(flowAuthor.getIsDefUser()) && !Boolean.parseBoolean(flowAuthor.getIsFree())) {
            if (!StringUtil.hasValue(flowAuthor.getSelectAuthor())) {
                flowAuthor.setIsSelect("false");
            }
        }

        if (!Objects.equal(flowAuthor.getAuthorId(), StaticVarExtend.AUTH_AUTHOR)) {
            if (StringUtil.hasValue(initAuthor)) {
                flowAuthor.setRequired("true");
            }
        }
    }

    /**
     * 从已选择人员列获取办理人
     *
     * @param authKey
     *            办理人唯一标识
     * @return
     */
    protected String getSelectAuthor(String authKey) {

        Map<String, String> selectAuthors = workResult.getSelectAuthorMap();
        String authorId = selectAuthors.get(authKey);
        authorId = ActionUtil.replacePrefix(authorId);
        return authorId;
    }

    /**
     * 从已设置人员列表获取办理人
     *
     * @param authKey
     *            参与者主键
     * @return
     */
    protected String getInitAuthor(String authKey) {

        Map<String, String> initAuthorMap = workResult.getInitAuthorMap();
        String authId = initAuthorMap.get(authKey);
        authId = ActionUtil.replacePrefix(authId);
        return authId;
    }

    /**
     * 获取没有设置办理人，且不允许跳过的节点列表
     *
     * @return
     */
    protected String getNonExistedAuthorNextNodes() {

        List<INextNode> nextNodes = workResult.getNextNodes();
        List<String> list = Lists.newArrayList();
        for (INextNode nextNode : nextNodes) {
            int initType = nextNode.getInitResult();
            if ((initType == StaticVarExtend.F_STATUS_NoAuthor)) {
                list.add(nextNode.getShowName());
            }
        }

        return Joiner.on(";").join(list.iterator());
    }

    /**
     * 下一节点办理人为自己时，是否自动打开流程（通过流程高级属性设置）。
     *
     * @return
     */
    protected boolean autoOpen() {

        boolean isOpen = false;
        IFlowInfo flowinfo = workResult.getFlowinfo();
        if (flowinfo != null) {
            isOpen = "1".equals(flowinfo.getOpenTodoFlag());
        }
//        if (null != workResult.getFlowInfo()) {
//            isOpen = "1".equals(workResult.getFlowInfo().getOpenTodoFlag());
//        }
        return isOpen;
    }

    /**
     * 当前实例ID
     *
     * @return
     */
    protected String workId() {

        return workResult.getWorkid();
    }

    /**
     * 当前实例trackId
     *
     * @return
     */
    protected String trackId() {

        String trackId = null;
        List<INextNode> nextNodes = workResult.getNextNodes();
        List<String> list = Lists.newArrayList();
        if (nextNodes != null && !nextNodes.isEmpty()) {
            for (INextNode nextNode : nextNodes) {
                String nodeId = nextNode.getNodeid();
                String nextTrackId = workResult.getNxtTrackidByNodeid(nodeId);
                if (StringUtil.hasValue(nextTrackId)) {
                    list.add(Strings.emptyToNull(nextTrackId));
                }
            }
        }
        if (!list.isEmpty()) {
            if (list.size() == 1) {
                trackId = list.get(0);
            } else {
                trackId = Joiner.on(";").skipNulls().join(list.iterator());
            }
        }

        return trackId;
    }

    /**
     * 通过办理人ID，转换为办理人员名称
     *
     * @param authorId
     * @return
     */
    protected String getAuthorName(String authorId) {

        if (!StringUtil.hasValue(authorId)) {
            return null;
        }

        String tenantId = HorizonCore.TENANT_CODE.value();
        String identifier = HorizonCore.TENANT_IDENTIFIER.value();
        Organization org = ThirdAdapterFactory.instanse(tenantId).getOrganizationInstance();
        return org.getNameByIds(authorId, identifier);
    }

    /**
     * 当选择的节点名称没有值时，由当前节点和操作名称替换
     *
     * @param selectName
     * @return
     */
    protected String getSelectNodeName(String selectName) {

        if (!StringUtil.hasValue(selectName)) {
            String actionName = workResult.getWorkParaBean().getActionname();
            //String nodename = workResult.getCurNode().getNodename();
            String nodename = workResult.getCurFlowNode().getNodename();
            selectName = actionName + "(" + nodename + ")";
        }
        return selectName;
    }

    /**
     * 根据节点办理类型确定
     * <p>
     * 单选1, 还是多选2
     *
     * @param nodeId
     *            节点ID
     * @param participantId
     *            办理人ID
     * @return
     */
    protected String getSelectType(String nodeId, String participantId) {

        String checkBtn = "radio";
        int singleType = 1;
        int selectType = workResult.getNextSelectTypeByNodeid(nodeId);
        if (Objects.equal(selectType, singleType)) {
            if (Objects.equal("Reader", participantId) || Objects.equal("SecondAuthor", participantId)) {
                // 读者或协办
                checkBtn = "checkbox";
            }
        } else {
            // 节点类型为多人类型
            checkBtn = "checkbox";
        }

        return checkBtn;
    }

    /**
     * 是否允许自由选择
     *
     * @param authorControl
     *            办理人属性
     * @return
     */
    protected boolean isFreeSelectUser(String authorControl) {

        return authorControl.indexOf("FreeSelect") > -1;
    }

    /**
     * 是否只允许选择人员
     *
     *
     * @return
     */
    protected boolean isOnlySelectUser(String authorControl) {

        return (authorControl.indexOf("OnlySelectUser") > -1);
    }

    /**
     * 是否需要从流程定义列表选择
     *
     * @return
     */
    protected boolean isDefAuthors(String authKey) {

        String value = null;
        Map<String, String> initAuthors = workResult.getInitAuthorMap();
        if (initAuthors != null && !initAuthors.isEmpty()) {
            value = initAuthors.get(authKey);
        }
        return StringUtil.hasValue(value);
    }

    /**
     * 设置节点办理人
     *
     */
    protected void setSelectAuthor() {

        if (action.getNextNodes() == null) {
            return;
        }
        Collection<FlowNextNode> nodes = getSelectNextNodes();
        boolean isTrue = Boolean.parseBoolean(HorizonPorps.getConfig("workflow.replace.subjection"));
        for (Iterator<FlowNextNode> it = nodes.iterator(); it.hasNext();) {
            FlowNextNode nextNode = it.next();
            Map<String, FlowAuthor> authors = nextNode.getAuthors();
            Map<String, String> authorMap = workParaBean.getSelectAuthorMap();
            Map<String, String> authorNameMap = workParaBean.getSelectAuthorNameMap();
            setNextNodeTimelimit(nextNode);
            String nodeKey = nextNode.getNodeKey();
            for (Map.Entry<String, FlowAuthor> entry : authors.entrySet()) {
                String authorKey = concatKey(nodeKey, entry.getKey());
                FlowAuthor author = entry.getValue();
                String authorValue = author.getSelectAuthor();
                // 设置了读者
                boolean hasReader = Objects.equal(entry.getKey(),"Reader") && StringUtil.hasValue(authorValue);
                if(isTrue && hasReader){
                    // 处理jira中的问题WFMS-1180,如果是设置读者去掉subjectId
                    authorValue = ActionUtil.relaceSubjectId(authorValue);
                }
                authorMap.put(authorKey, authorValue);
                authorNameMap.put(authorKey, author.getSelectAuthorName());
            }
        }

    }

    /**
     * 由外部指定办理时限
     *
     * @param nextNode
     *            下一届点对象
     */
    protected void setNextNodeTimelimit(FlowNextNode nextNode) {

        String limit = nextNode.getTimeLimit();
        String limitType = nextNode.getTimeLimitType();
        if (StringUtil.hasValue(limit) && StringUtil.hasValue(limitType)) {
            limit = limitType + ";" + limit;
            workParaBean.putNodeLimitSetMap(nextNode.getNodeId(), limit);
        }
    }

    protected String concatKey(String nodeId, String authorId) {

        return nodeId + "-" + authorId;
    }

    /**
     * 判断当然操作是否在下一节点办理人列表中
     *
     * @param authorId
     *            办理人ID
     * @return
     */
    protected boolean hasNextAuthor(String authorId) {

        boolean isHas = false;
        if (StringUtil.hasValue(authorId)) {
            List<AuthUserImpl> authors = AuthUserImpl.getAuthUserList(authorId);
            if (authors == null || authors.isEmpty()) {
                return isHas;
            }
            Collection<AuthUserImpl> filterList = Collections2.filter(authors, new Predicate<AuthUserImpl>() {

                @Override
                public boolean apply(AuthUserImpl authUser) {

                    return authUser.equalsRunUser(workResult.getCurUser());
                }
            });
            isHas = (filterList != null && !filterList.isEmpty());
        }

        return isHas;
    }

    /**
     * 获取已选择的节点列表
     *
     * @return
     */
    protected Collection<FlowNextNode> getSelectNextNodes() {

        List<FlowNextNode> nextNodes = action.getNextNodes();
        Collection<FlowNextNode> filterList = Collections2.filter(nextNodes, new Predicate<FlowNextNode>() {

            @Override
            public boolean apply(FlowNextNode nextNode) {

                Map<String, FlowAuthor> authors = nextNode.getAuthors();
                boolean isSelect = Boolean.parseBoolean(nextNode.getIsSelect());
                boolean hasAuthors = (null != authors && !authors.isEmpty());
                return (isSelect && hasAuthors);
            }
        });
        return filterList;
    }

    /**
     * 当getSelectedIdStr没有值时，返回当前节点的NodeID
     *
     * @param selectId
     * @return
     */
    private String getSelectIds(String selectId) {

        if (!StringUtil.hasValue(selectId)) {
            selectId= workResult.getCurFlowNode().getNodeid();
            //selectId = workResult.getCurNode().getNodeid();
        }
        return selectId;
    }

    /**
     * 根据办理人ID获取办理人名称
     *
     * @param authorId
     *            办理人ID
     * @return
     */
    protected String getAuhorName(String authorId) {

        return WorkflowOperateInit.getAuhorName(authorId);
    }

    /**
     * 根据办理人名称获取办理人ID
     *
     * @param authorName
     *            办理人名称
     * @return
     */
    protected String getAuhorId(String authorName) {

        return WorkflowOperateInit.getAuhorId(authorName);
    }

    /**
     * 设置办理人
     *
     * @param object
     *            实际的处理类型
     */
    private void setSelectUsers(Object object) {

        // 区别是启动子流程还是其他
        if (object instanceof SubflowSubmitAction || object instanceof RejectSubmitAction) {
            this.setSelectAuthor();
        } else if (object instanceof FreeSubmitAction) {
            setUsersForFreeSubmit(object);
        }else {
            setUsersForDef(object);
        }

    }

    /**
     * 设置办理人，自由提交
     *
     * @param object
     */
    private void setUsersForFreeSubmit(Object object) {

        this.setSelectAuthor();

        // 获取开关
        if (AppConfig.getBoolean("horizon", "workflow.authorParsingToUser")) {
            if (action.getFreeNode() != null && action.getNextNodes() == null) {
                Map<String, String> authorMap = workParaBean.getSelectAuthorMap();
                for (Map.Entry<String, String> entry : authorMap.entrySet()) {
                    setAuthorUsers(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    /**
     * 设置人员 一般提交
     *
     * @param object
     */
    private void setUsersForDef(Object object) {

        List<FlowNextNode> flowNextNodes = action.getNextNodes();
        if (flowNextNodes == null) {
            return;
        }
        this.setSelectAuthor();
        // 获取开关
        if (AppConfig.getBoolean("horizon", "workflow.authorParsingToUser")) {
            // 获取到nodeKey
            String nodeKey = "";
            for (FlowNextNode node : flowNextNodes) {
                if (Objects.equal(node.getIsSelect(), "true")) {
                    nodeKey = node.getNodeKey();
                    if (StringUtil.hasValue(nodeKey)) {
                        String key = concatKey(nodeKey, "Author");
                        String authorIds = workParaBean.getSelectAuthorMap().get(key);
                        // 设置主办
                        setAuthorUsers(key, authorIds);
                        // 设置协办
                        key = concatKey(nodeKey, "SecondAuthor");
                        authorIds = workParaBean.getSelectAuthorMap().get(key);
                        setAuthorUsers(key, authorIds);
                    }
                }
            }
        }
    }

    /**
     * 设置主办/协办
     *
     * @param nodeKey
     *            人员属于哪个节点的标示
     * @param authorIds
     *            所选择的id
     */
    private void setAuthorUsers(String nodeKey, String authorIds) {

        String orgType = AppConfig.get("horizon", "workflow.authorParsingType");
        if (!StringUtil.hasValue(orgType) || !StringUtil.hasValue(authorIds)) {
            return;
        }

        authorIds = resolveSelectUsers(authorIds, orgType);
        String tenantCode = HorizonCore.TENANT_CODE.value();
        Organization organization = ThirdAdapterFactory.instanse(tenantCode).getOrganizationInstance();
        String selectAuthorName = organization.getNameByIds(authorIds, tenantCode);
        workParaBean.getSelectAuthorMap().put(nodeKey, authorIds);
        workParaBean.getSelectAuthorNameMap().put(nodeKey, selectAuthorName);

    }

    /**
     * 解析人员
     *
     * @param authorIds
     *            所选择的id
     * @param orgType
     *            解析的组织机构类型(部门/群组/岗位)
     * @return String 解析好的人员
     */
    private String resolveSelectUsers(String authorIds, String orgType) {

        List<String> author = Lists.newArrayList();
        List<String> selectAuthor = Splitter.on(";").splitToList(authorIds);

        for (String id : selectAuthor) {
            String type = ActionUtil.getType(id);
            if (orgType.indexOf(type) < 0) {
                author.add(id);
            } else {
                WorkflowBaseAdapther adapther = WorkflowAdapterInit.getWorkflowAdapthers("orgs");
                String orgId = ActionUtil.replaceId(id);
                List<User> users = adapther.getUserByOrgId(type, orgId);
                for (User user : users) {
                    author.add(user.getFixId() + "/" + id);
                }
            }
        }
        return StringUtils.join(author, ";");
    }
}
